/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_ListOfStrings;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_MemoryLevelEnable;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumMemoryLevelVisibilityMode;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_ListOfStrings;
import java.util.ArrayList;

public class ConfigOption_MemoryLevelVisibilityOptionList
extends ConfigOption_ListOfStrings
implements IConfigOption_ListOfStrings {
    private EnumMemoryLevelVisibilityMode defaultVisibilityMode;

    public ConfigOption_MemoryLevelVisibilityOptionList(ConfigOption owner, ConfigOptionList nestedMemoryLevelEnableList) {
        this(owner, nestedMemoryLevelEnableList, EnumMemoryLevelVisibilityMode.CACHE_VISIBILITY);
    }

    public ConfigOption_MemoryLevelVisibilityOptionList(ConfigOption owner, ConfigOptionList nestedMemoryLevelEnableList, EnumMemoryLevelVisibilityMode defaultVisibilityMode) {
        super("Memory Level Coloring Options", 0, new ArrayList<String>(), EnumMemoryLevelVisibilityMode.getDefaultIndex(), "Configuration", 3, "", owner, nestedMemoryLevelEnableList, true);
        String descriptionText = "";
        for (EnumMemoryLevelVisibilityMode mode : EnumMemoryLevelVisibilityMode.values()) {
            this.listOfStrings.add(mode.toConfigOptionString());
            if (descriptionText.length() > 0) {
                descriptionText = descriptionText + "\n";
            }
            descriptionText = descriptionText + mode.getDescription();
        }
        this.setDescription(descriptionText);
        this.setDefaultVisibilityMode(defaultVisibilityMode);
        this.setSelectedVisibilityMode(defaultVisibilityMode);
    }

    public ConfigOption_MemoryLevelVisibilityOptionList(ConfigOption_MemoryLevelVisibilityOptionList objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom, owner);
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_MemoryLevelVisibilityOptionList result = new ConfigOption_MemoryLevelVisibilityOptionList(this, (ConfigOption)cloneOwner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    public EnumMemoryLevelVisibilityMode getSelectedVisibilityMode() {
        EnumMemoryLevelVisibilityMode result = EnumMemoryLevelVisibilityMode.fromOrdinal(this.getCurrentIndex());
        return result;
    }

    public void setSelectedVisibilityMode(EnumMemoryLevelVisibilityMode value) {
        String[] errorString = new String[]{""};
        this.setCurrentIndex(value.ordinal(), errorString);
        if (this.hasNestedConfigOptionList()) {
            for (IConfigOption option : (ConfigOptionList)this.getNestedConfigOptionList()) {
                if (!(option instanceof ConfigOption_MemoryLevelEnable)) continue;
                ((ConfigOption_MemoryLevelEnable)option).setMemoryLevelVisibilityModeConfig(value);
            }
        }
    }

    public EnumMemoryLevelVisibilityMode getDefaultVisibilityMode() {
        return this.defaultVisibilityMode;
    }

    public void setDefaultVisibilityMode(EnumMemoryLevelVisibilityMode value) {
        this.defaultVisibilityMode = value;
    }

    public boolean isAnyMemoryLevelBypassed() {
        boolean result = false;
        if (this.hasNestedConfigOptionList()) {
            for (IConfigOption option : this.getNestedConfigOptionList()) {
                ConfigOption_MemoryLevelEnable memLevelEnable;
                if (!(option instanceof ConfigOption_MemoryLevelEnable) || !(memLevelEnable = (ConfigOption_MemoryLevelEnable)option).isBypassed()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isDefaultMemoryLevelBypass() {
        boolean result = true;
        if (this.hasNestedConfigOptionList()) {
            for (IConfigOption option : this.getNestedConfigOptionList()) {
                ConfigOption_MemoryLevelEnable memLevelEnable;
                if (!(option instanceof ConfigOption_MemoryLevelEnable) || (memLevelEnable = (ConfigOption_MemoryLevelEnable)option).isBypassed() == memLevelEnable.isBypassedByDefault()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public String getTooltipText() {
        String result = "Memory Level Coloring";
        switch (this.getSelectedVisibilityMode()) {
            case MEMORY_LEVEL_VISIBILITY: {
                result = "Memory Level Coloring";
                break;
            }
            case CACHE_VISIBILITY: {
                result = "Cache Coloring";
            }
            case NONE: {
                result = this.defaultVisibilityMode == EnumMemoryLevelVisibilityMode.CACHE_VISIBILITY ? "Cache Coloring (disabled)" : "Memory Level Coloring (disabled)";
            }
        }
        return result;
    }
}

