/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption_ListOfStrings;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_ListOfStrings;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import java.util.ArrayList;

public class ConfigOption_MmuBypassOptionList
extends ConfigOption_ListOfStrings
implements IConfigOption_ListOfStrings {
    private EnumMemoryViews currentMemoryView;
    private EnumMemoryViews defaultMemoryView;
    private boolean isVirtualMemorySupported = false;

    public ConfigOption_MmuBypassOptionList(ConfigOption owner, boolean isVirtualMemorySupported) {
        super("Memory View Selection", 0, new ArrayList<String>(), 0, "Configuration", 0, "", owner, null, true);
        this.isVirtualMemorySupported = isVirtualMemorySupported;
        this.listOfStrings.add("CPU Memory View");
        this.listOfStrings.add("Physical Memory View");
        this.listOfStrings.add("CPU Memory View - Ignore Memory Maps");
        this.listOfStrings.add("Don't Care");
        this.currentMemoryView = this.defaultMemoryView = EnumMemoryViews.fromInt(0);
        this.setDescription("CPU Memory View (default): displays memory as seen with the current MMU setting.\nPhysical Memory View: displays memory as if the MMU was disabled. CPU Memory View - Ignore Memory Map: displays memory with the current MMU setting and the Memory Map option turned off.");
    }

    public ConfigOption_MmuBypassOptionList(ConfigOption_MmuBypassOptionList objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), objToCopyFrom.getRank(), objToCopyFrom.getListOfStrings(), objToCopyFrom.getDefaultIndex(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.listOfStrings = new ArrayList();
        this.listOfStrings.addAll(objToCopyFrom.getListOfStrings());
        this.defaultMemoryView = objToCopyFrom.getDefaultMemoryView();
        this.currentMemoryView = objToCopyFrom.getCurrentMemoryView();
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_MmuBypassOptionList result = new ConfigOption_MmuBypassOptionList(this, (ConfigOption)cloneOwner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public boolean setCurrentIndex(int index, String[] errorString) {
        boolean result = this.validate(index, errorString);
        if (result) {
            this.currentMemoryView = EnumMemoryViews.fromInt(index);
        }
        return result;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentMemoryView.getInt();
    }

    @Override
    public boolean setDefaultIndex(int index, String[] errorString) {
        boolean result = this.validate(index, errorString);
        if (result) {
            this.defaultMemoryView = EnumMemoryViews.fromInt(index);
        }
        return result;
    }

    @Override
    public int getDefaultIndex() {
        return this.defaultMemoryView.getInt();
    }

    public EnumMemoryViews getCurrentMemoryView() {
        return this.currentMemoryView;
    }

    public void setCurrentMemoryView(EnumMemoryViews value) {
        this.currentMemoryView = value;
    }

    public EnumMemoryViews getDefaultMemoryView() {
        return this.defaultMemoryView;
    }

    public void setDefaultValue(EnumMemoryViews value) {
        this.defaultMemoryView = value;
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        if (value == null) {
            result = false;
            errorString[0] = "null value entered.";
        } else if (value instanceof EnumMemoryViews) {
            result = true;
        } else if (!(value instanceof Integer)) {
            result = false;
            errorString[0] = "Entered value is not an Integer (index into the list of strings)";
        } else {
            int index = (Integer)value;
            if (index < 0) {
                result = false;
                errorString[0] = "Index must be > 0";
            } else if (this.listOfStrings == null) {
                result = false;
                errorString[0] = "List of strings is null.";
            } else if (this.listOfStrings.size() == 0) {
                result = false;
                errorString[0] = "Empty list of strings";
            } else if (index >= this.listOfStrings.size()) {
                result = false;
                errorString[0] = "Index must be < " + Integer.toString(this.listOfStrings.size()) + " (number of items in list)";
            }
        }
        return result;
    }

    public boolean isVirtualMemorySupported() {
        return this.isVirtualMemorySupported;
    }

    @Override
    public String getCurrentValueAsString() {
        String result = "";
        int index = this.getCurrentIndex();
        if (index < 0 || index >= this.listOfStrings.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        result = (String)this.listOfStrings.get(index);
        return result;
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        int index = Integer.parseInt(newValue);
        this.currentMemoryView = EnumMemoryViews.fromInt(index);
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.defaultMemoryView.equals((Object)this.currentMemoryView);
        return result;
    }

    @Override
    public String getTooltipText() {
        String retval = "";
        if (this.isVirtualMemorySupported()) {
            retval = "Selects whether memory is displayed with the current MMU configuration (CPU Memory View) or with the MMU disabled (Physical Memory View).\nCAUTION: Proper MMU initialization is required in order to safely view or edit Virtual Memory";
        }
        return retval;
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        boolean result = this.hasNestedConfigOptionList();
        return result;
    }

    @Override
    public void setCurrentValue(IConfigOption anotherConfigOptionOfTheSameType) {
        if (!(anotherConfigOptionOfTheSameType instanceof ConfigOption_MmuBypassOptionList)) {
            throw new ClassCastException("ConfigOption_MmuBypassOptionList.setCurrentValue(" + anotherConfigOptionOfTheSameType.getConfigOptionType().toString() + ")");
        }
        ConfigOption_MmuBypassOptionList option = (ConfigOption_MmuBypassOptionList)anotherConfigOptionOfTheSameType;
        String[] errorString = new String[]{""};
        this.setCurrentIndex(option.getCurrentIndex(), errorString);
    }

    @Override
    public void setDefaultValue(IConfigOption anotherConfigOptionOfTheSameType) {
        if (!(anotherConfigOptionOfTheSameType instanceof ConfigOption_MmuBypassOptionList)) {
            throw new ClassCastException("ConfigOption_MmuBypassOptionList.setDefaultValue(" + anotherConfigOptionOfTheSameType.getConfigOptionType().toString() + ")");
        }
        ConfigOption_MmuBypassOptionList option = (ConfigOption_MmuBypassOptionList)anotherConfigOptionOfTheSameType;
        String[] errorString = new String[]{""};
        this.setDefaultIndex(option.getDefaultIndex(), errorString);
    }
}

