/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.configoptions;

import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.ConfigOptionList;
import com.ti.ccstudio.debug.memoryserver.configoptions.EnumConfigOptionType;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption;
import com.ti.ccstudio.debug.memoryserver.configoptions.IConfigOption_String;

public class ConfigOption_String
extends ConfigOption
implements IConfigOption_String {
    private String currentValue = null;
    private String defaultValue = null;

    public ConfigOption_String(String configOptionName, int rank, String defaultValue, String categoryName, int categoryRank, String description, ConfigOption owner, ConfigOptionList nestedListOfConfigOptions, boolean isOptionEnabled) {
        super(configOptionName, EnumConfigOptionType.STRING, rank, categoryName, categoryRank, description, owner, nestedListOfConfigOptions, isOptionEnabled);
        this.currentValue = defaultValue;
        this.defaultValue = defaultValue;
    }

    public ConfigOption_String(ConfigOption_String objToCopyFrom, ConfigOption owner) {
        super(objToCopyFrom.getName(), EnumConfigOptionType.STRING, objToCopyFrom.getRank(), objToCopyFrom.getCategoryName(), objToCopyFrom.getCategoryRank(), objToCopyFrom.getDescription(), owner, null, objToCopyFrom.isOptionEnabled());
        this.currentValue = objToCopyFrom.getCurrentValue();
        this.defaultValue = objToCopyFrom.getDefaultValue();
        this.setMemoryServerOwnedTagObject(objToCopyFrom.getMemoryServerOwnedTagObject());
    }

    @Override
    public IConfigOption clone(IConfigOption cloneOwner) {
        ConfigOption_String result = new ConfigOption_String(this, (ConfigOption)cloneOwner);
        if (this.hasNestedConfigOptionList()) {
            result.setNestedConfigOptionList(this.getNestedConfigOptionList().clone(result));
        }
        result.setTagObject(this.getTagObject());
        return result;
    }

    @Override
    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String value) {
        this.currentValue = value;
    }

    @Override
    public void setCurrentValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_String) {
            ConfigOption_String option = (ConfigOption_String)optionToGetValueFrom;
            this.setCurrentValue(option.getCurrentValue());
            this.setIsOptionEnabled(option.isOptionEnabled());
            if (this.hasNestedConfigOptionList() && optionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setCurrentValues(optionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_String.setCurrentValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public void setDefaultValue(IConfigOption optionToGetValueFrom) {
        if (optionToGetValueFrom instanceof ConfigOption_String) {
            ConfigOption_String option = (ConfigOption_String)optionToGetValueFrom;
            this.setDefaultValue(option.getDefaultValue());
            if (this.hasNestedConfigOptionList() && optionToGetValueFrom.hasNestedConfigOptionList()) {
                this.getNestedConfigOptionList().setDefaultValues(optionToGetValueFrom.getNestedConfigOptionList());
            }
        } else {
            throw new ClassCastException("ConfigOption_String.setDefaultValue(" + optionToGetValueFrom.getConfigOptionType().toString() + ")");
        }
    }

    @Override
    public boolean validate(Object value, String[] errorString) {
        errorString[0] = "OK";
        boolean result = true;
        if (value == null) {
            result = false;
            errorString[0] = "null value entered.";
        } else if (!(value instanceof String)) {
            result = false;
            errorString[0] = "Entered value is not a String.";
        } else if (((String)value).length() == 0) {
            result = false;
            errorString[0] = "Empty string is not valid.";
        }
        return result;
    }

    @Override
    public String getCurrentValueAsString() {
        return this.currentValue;
    }

    @Override
    public void setCurrentValueFromString(String newValue) {
        this.currentValue = newValue;
    }

    @Override
    public boolean isCurrentValueEqualToDefault() {
        boolean result = this.currentValue.equalsIgnoreCase(this.defaultValue);
        return result;
    }

    @Override
    public String getTooltipText() {
        return this.getName() + ":" + this.getCurrentValueAsString();
    }

    @Override
    public boolean isNestedConfigOptionListEnabled() {
        boolean result = this.hasNestedConfigOptionList();
        return result;
    }
}

