/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.enums;

public enum EnumDspValueType {
    DSP_CHAR(0, false, false),
    DSP_UCHAR(1, true, false),
    DSP_SHORT(2, false, false),
    DSP_USHORT(3, true, false),
    DSP_INT(6, false, false),
    DSP_UINT(7, true, false),
    DSP_LONG(8, false, false),
    DSP_ULONG(9, true, false),
    DSP_POINTER(11, true, false),
    DSP_LONGLONG(30, true, false),
    DSP_ULONGLONG(31, true, false),
    DSP_DATA8(12, false, false),
    DSP_DATA16(14, false, false),
    DSP_DATA24(16, false, false),
    DSP_DATA32(18, false, false),
    DSP_DATA40(20, false, false),
    DSP_DATA48(22, false, false),
    DSP_DATA64(24, false, false),
    DSP_UDATA8(13, true, false),
    DSP_UDATA16(15, true, false),
    DSP_UDATA24(17, true, false),
    DSP_UDATA32(19, true, false),
    DSP_UDATA40(21, true, false),
    DSP_UDATA48(23, true, false),
    DSP_UDATA64(25, true, false),
    DSP_FAR_POINTER(27, true, false),
    DSP_NEAR_POINTER(29, true, false),
    DSP_FLOAT(32, false, true),
    DSP_IEEE_FLOAT(34, false, true),
    DSP_DOUBLE(36, false, true),
    DSP_IEEE_DOUBLE(38, false, true),
    DSP_LDOUBLE(40, false, true);

    int dspValueType;
    boolean isUnsigned = false;
    boolean isRealValue = false;

    public static EnumDspValueType fromInt(int i) {
        for (EnumDspValueType dvt : EnumDspValueType.values()) {
            if (dvt.getInt() != i) continue;
            return dvt;
        }
        throw new IndexOutOfBoundsException("EnumDspValueType.fromInt(" + Integer.toString(i) + "): Invalid integer value");
    }

    public static EnumDspValueType fromOrdinal(int i) {
        for (EnumDspValueType dvt : EnumDspValueType.values()) {
            if (dvt.ordinal() != i) continue;
            return dvt;
        }
        throw new IndexOutOfBoundsException("EnumDspValueType.fromInt(" + Integer.toString(i) + "): Invalid integer value");
    }

    private EnumDspValueType(int value, boolean unsigned, boolean realValue) {
        this.dspValueType = value;
        this.isUnsigned = unsigned;
        this.isRealValue = realValue;
    }

    public int getInt() {
        return this.dspValueType;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isRealValue() {
        return this.isRealValue;
    }

    public static int getLastIndex() {
        return DSP_LDOUBLE.ordinal();
    }

    public String toString() {
        String result = super.toString();
        if (result.indexOf("DSP_") == 0) {
            result = result.substring(4, result.length());
        }
        result = result.replaceAll("_", " ");
        return result;
    }

    public static EnumDspValueType valueOfString(String str) {
        String value = str;
        if (str.indexOf("DSP_") < 0) {
            value = "DSP_" + str.replaceAll(" ", "_").toUpperCase();
        }
        return EnumDspValueType.valueOf(value);
    }
}

