/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.enums;

public enum EnumGtiMemResult {
    MEM_ACCESS_OK(0L, "Memory access succeeded."),
    MEM_ACCESS_FAILED(1L, "Memory access failed."),
    MEM_ACCESS_SECURITY_VIOLATION(2L, "Memory access security violation."),
    MEM_NOT_PRESENT(3L, "Memory not present."),
    MEM_ACCESS_INVALID(4L, "Memory access invalid."),
    MEM_ACCESS_NOT_ATTEMPTED(5L, "Memory access not attempted by the driver (Check memory map)."),
    MEM_STAT_MMU_FAULT(6L, "Memory access aborted due to MMU fault."),
    UNDEFINED_MEM_ACCESS_ERROR_CODE(128L, "Undefined memory access error."),
    MEM_REGION_DSP_MEMORY_OBJECT_NULL(256L, "Memory region DspMemoryObject is null - access not performed."),
    DEBUG_SERVER_ERROR_INVALID_INDEX_INTO_MEMORY_OBJECT(65536L, "Debug Server error: Invalid index into memory object."),
    DEBUG_SERVER_ERROR_NOT_IN_MEMORY_MAP(131072L, "Debug Server Error: Not in memory map."),
    DEBUG_SERVER_ERROR_ACCESS_NOT_ATTEMPTED(262144L, "Debug Server Error: Access not attempted."),
    DEBUG_SERVER_ERROR_TARGET_ACCESS_FAILED(524288L, "Debug Server Error: Target Access Failed."),
    DEBUG_SERVER_ERROR_ADDRESS_OUT_OF_RANGE(0x100000L, "Debug Server Error: Address out of range."),
    DEBUG_SERVER_ERROR_TARGET_DISCONNECTED(0x200000L, "Debug Server Error: The target is in a connection state that prevents memory accesses."),
    DEBUG_SERVER_ERROR_EXECUTION_STATE_PREVENTED(0x400000L, "Debug Server Error:The target is in an execution state that prevents memory accesses."),
    DEBUG_SERVER_ERROR_REQUEST_PENDING(0x800000L, "Debug Server Error: The request is still pending in the queue"),
    DEBUG_SERVER_ERROR_DEBUGGER_CASCADE_ABORT(0x1000000L, "Debug Server Error: The debugger is aborting all requests in the queue due to an earlier error");

    long errorCode;
    String description = "";
    boolean dsDescriptionExists = false;
    String dsDescription = null;

    private EnumGtiMemResult(long value, String description) {
        this.errorCode = value;
        this.description = description;
    }

    public static EnumGtiMemResult fromOrdinal(int i) {
        for (EnumGtiMemResult result : EnumGtiMemResult.values()) {
            if (result.getLong() != (long)i) continue;
            result.setDsDescriptionExists(false);
            return result;
        }
        return UNDEFINED_MEM_ACCESS_ERROR_CODE;
    }

    public static EnumGtiMemResult fromOrdinal(int i, String dsDescription) {
        for (EnumGtiMemResult result : EnumGtiMemResult.values()) {
            if (result.getLong() != (long)i) continue;
            result.setDsDescription(dsDescription);
            return result;
        }
        UNDEFINED_MEM_ACCESS_ERROR_CODE.setDsDescription(dsDescription);
        return UNDEFINED_MEM_ACCESS_ERROR_CODE;
    }

    public long getLong() {
        return this.errorCode;
    }

    public String toString() {
        if (this.dsDescriptionExists) {
            return this.dsDescription;
        }
        return this.description;
    }

    protected void setDsDescription(String description) {
        this.dsDescription = description;
        this.dsDescriptionExists = true;
    }

    protected void setDsDescriptionExists(boolean exists) {
        this.dsDescriptionExists = exists;
    }
}

