/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.enums;

import com.ti.ccstudio.debug.memoryserver.enums.EnumCacheLevel;

public enum EnumMemoryLevelIndex {
    L1(0),
    L1D(1),
    L1P(2),
    L2(3),
    L2_SHARED(4),
    L3(5),
    L3_SHARED(6),
    EXTERNAL(7),
    INACCESSIBLE(8),
    PHYSICAL(9),
    NONE(127);

    int index;

    private EnumMemoryLevelIndex(int value) {
        this.index = value;
    }

    public int getIndex() {
        return this.index;
    }

    public static EnumMemoryLevelIndex fromInt(int i) {
        for (EnumMemoryLevelIndex memLevel : EnumMemoryLevelIndex.values()) {
            if (memLevel.getIndex() != i) continue;
            return memLevel;
        }
        throw new IndexOutOfBoundsException("Invalid integer value (" + Integer.toString(i) + ")");
    }

    public static EnumMemoryLevelIndex fromEnumCacheLevel(EnumCacheLevel value) {
        EnumMemoryLevelIndex result = null;
        switch (value) {
            case L1_CACHE: {
                result = L1;
                break;
            }
            case L1D_CACHE: {
                result = L1D;
                break;
            }
            case L1P_CACHE: {
                result = L1P;
                break;
            }
            case L2_CACHE: {
                result = L2;
            }
        }
        return result;
    }

    public String toString() {
        String result = this.name();
        if (result.indexOf("_") > 0) {
            result.replaceAll("_", " ");
        }
        return result;
    }
}

