/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.enums;

import com.ti.ccstudio.debug.memoryserver.enums.EnumGtiMemResult;

public enum EnumMemoryServerErrorCodes {
    OK(0, "OK"),
    MEMORY_ACCESS_OUTSIDE_OF_REQUEST_DESCRIPTOR_ADDRESS_RANGE(1, " Memory access outside of request descriptor address range."),
    REQUESTED_MEMORY_NOT_IN_MEMORY_SERVER_CACHE(2, "Requested memory not in memory server cache."),
    MEMORY_WRITE_COLLISION_WITH_PENDING_MEMORY_READ_ABORTED(3, "Memory Write collision with pending Memory Read Aborted."),
    TARGET_MEMORY_REGION_OBJECT_IN_UNEXPECTED_STATE(4, "Target memory region object in unexpected state."),
    MEMORY_ACCESS_ATTEMPTED_AFTER_REQUEST_ABORTED(5, "Memory access attempted after request aborted."),
    MEMORY_NOT_ACCESSIBLE(6, "Memory not accessible."),
    TARGET_DISCONNECTED(7, "Target disconnected."),
    MEMORY_SECURE_AND_NON_EMULATABLE(8, "Memory configured as secure and non-emulatable."),
    REQUESTED_ACTION_FAILED(9, "Requested action failed for an unspecified reason."),
    REQUESTED_ADDRESS_DOES_NOT_EXIST(10, "Requested address does not exist."),
    TARGET_MEMORY_READ_NOT_ALLOWED_WHILE_RUNNING(11, "Target memory read not allowed while running."),
    TARGET_MEMORY_READ_NOT_ALLOWED(12, "Target memory read not allowed."),
    TARGET_MEMORY_WRITE_NOT_ALLOWED_WHILE_RUNNING(13, "Target memory write not allowed while running."),
    TARGET_MEMORY_WRITE_NOT_ALLOWED(14, "Target memory write not allowed."),
    TARGET_EXPRESSION_EVAL_NOT_ALLOWED_WHILE_RUNNING(15, "Target expression evaluation not allowed while running."),
    TARGET_EXPRESSION_EVAL_NOT_ALLOWED(16, "Target expression evaluation not allowed."),
    TARGET_REGISTER_WRITE_NOT_ALLOWED_WHILE_RUNNING(17, "Target register write not allowed while running."),
    TARGET_REGISTER_WRITE_NOT_ALLOWED(18, "Target register write not allowed.");

    int errorCode;
    String description = "";

    private EnumMemoryServerErrorCodes(int value, String description) {
        this.errorCode = value;
        this.description = description;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return this.description;
    }

    public int getInt() {
        return this.errorCode;
    }

    public static EnumMemoryServerErrorCodes fromInt(int i) {
        for (EnumMemoryServerErrorCodes errCode : EnumMemoryServerErrorCodes.values()) {
            if (errCode.getErrorCode() != i) continue;
            return errCode;
        }
        throw new IndexOutOfBoundsException("EnumMemoryServerErrorCodes.fromInt: Invalid integer value (" + Integer.toString(i) + ")");
    }

    public static EnumMemoryServerErrorCodes fromEnumGtiMemResult(EnumGtiMemResult gtiMemResult) {
        EnumMemoryServerErrorCodes errorCode = REQUESTED_ACTION_FAILED;
        switch (gtiMemResult) {
            case MEM_ACCESS_OK: {
                errorCode = OK;
                break;
            }
            case MEM_NOT_PRESENT: {
                errorCode = MEMORY_NOT_ACCESSIBLE;
                break;
            }
            case MEM_ACCESS_NOT_ATTEMPTED: {
                errorCode = MEMORY_NOT_ACCESSIBLE;
                break;
            }
            case MEM_ACCESS_SECURITY_VIOLATION: {
                errorCode = MEMORY_SECURE_AND_NON_EMULATABLE;
            }
        }
        return errorCode;
    }
}

