/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.extensions.DebugServerEventHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.debug.engine.IDspUser;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;

public abstract class AbstractDebugServerEventListener
extends DebugServerEventHandler
implements IDisposable {
    protected IDspUser refDspUser;
    protected EventObject sourceObj = null;
    protected ArrayList<EventListener> listOfEvents = null;
    private volatile boolean disposed = false;

    AbstractDebugServerEventListener(IDspUser refDspUser) {
        super(null, 0);
        this.refDspUser = refDspUser;
        this.sourceObj = new EventObject(this);
        this.listOfEvents = new ArrayList();
    }

    public void addListener(EventListener listener) {
        if (!this.listOfEvents.contains(listener)) {
            if (this.listOfEvents.size() == 0) {
                this.startListening();
            }
            this.listOfEvents.add(listener);
        }
    }

    public void removeListener(EventListener listener) {
        int numListeners = this.listOfEvents.size();
        if (this.listOfEvents.contains(listener)) {
            this.listOfEvents.remove(listener);
        }
        if (numListeners == 1 && this.listOfEvents.size() == 0) {
            this.stopListening();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            while (this.listOfEvents.size() > 0) {
                this.removeListener(this.listOfEvents.get(0));
            }
            super.dispose();
        }
        this.disposed = true;
    }
}

