/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.CExprEvalEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ICExpressionEvalEventHandler;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExpressionEvalResultArgs;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class CExpressionEvalEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public CExpressionEvalEventListener(IDspUser refDspUser, EventHandlerThread jobToRaiseEvents) {
        super(refDspUser);
        this.eventHandlerThread = jobToRaiseEvents;
        this.addTrigger(refDspUser.onCExprEvaluated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onCExprEvaluated()) {
            short errorCode = 0;
            IExpressionEvaluationData result = null;
            try {
                result = (IExpressionEvaluationData)event.getObjectData();
                String originalExpression = result.getExpression();
                errorCode = result.getErrorCode();
                IDspValue targetData = null;
                if (errorCode == 0) {
                    targetData = result.getTargetData();
                }
                CExpressionEvalResultArgs myCExprEvalArgs = new CExpressionEvalResultArgs(originalExpression, errorCode, targetData);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    String traceMsg = "OnCExprEvaluated(" + originalExpression + ")=";
                    traceMsg = targetData != null && targetData instanceof IDspValue ? traceMsg + targetData.toStringCStyleHex() : traceMsg + "not a valid DspValue";
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo(traceMsg + ", errorCode = " + Integer.toHexString(errorCode), "CExpressionEvalListener.syncHandleEvent", null);
                    }
                }
                CExprEvalEventListenerItem item = new CExprEvalEventListenerItem(myCExprEvalArgs, this);
                this.eventHandlerThread.add(item);
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception in syncHandleEvent", "CExpressionEvalEventListener.syncHandleEvent", e, null);
                }
            }
            finally {
                if (result != null && !result.isDisposed()) {
                    result.dispose();
                }
            }
        }
        return true;
    }

    public void raise(CExpressionEvalResultArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((ICExpressionEvalEventHandler)hdlr).handleCExpressionEvalEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("CExpressionEvalEvent exception", "CExpressionEvalEventListener.raise", e, null);
            }
        }
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((CExpressionEvalResultArgs)eventListenerItem.getArgs());
    }

    public void acquire() {
    }
}

