/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IContinuousRefreshUpdateEventHandler;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryServerEventBaseClass;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import java.util.EventListener;

public class ContinuousRefreshUpdateEventListener
extends MemoryServerEventBaseClass
implements IDisposable {
    private MemoryServer memoryServer = null;
    private ContinuousRefreshEventTimer timer = null;
    private boolean isStopTimerRequested = false;

    public ContinuousRefreshUpdateEventListener(TargetHandler source) {
        super(source);
    }

    public void init(MemoryServer memoryServer) {
        this.memoryServer = memoryServer;
    }

    public int getMillisecondDelay() {
        int result = 5000;
        if (!this.isDisposed() && this.memoryServer != null && !this.memoryServer.isDisposed()) {
            result = this.memoryServer.getContinuousRefreshInterval();
        }
        return result;
    }

    void raise() {
        for (int index = 0; index < this.listOfEventListeners.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEventListeners.get(index);
            if (hdlr == null) continue;
            try {
                ((IContinuousRefreshUpdateEventHandler)hdlr).handleContinuousRefreshUpdateEvent(this.sourceObj);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnContinuousRefreshUpdateEvent exception", "ContinuousRefreshUpdateEventListener.raise", e, null);
            }
        }
    }

    public synchronized void startThread() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.isStopTimerRequested = false;
            this.timer = new ContinuousRefreshEventTimer();
            this.timer.setName("MemoryServer.ContinuousRefreshEventTimer");
            this.timer.start();
        } else {
            if (this.timer.isInterrupted()) {
                try {
                    this.timer.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isStopTimerRequested = false;
            this.timer = new ContinuousRefreshEventTimer();
            this.timer.setName("MemoryServer.ContinuousRefreshEventTimer");
            this.timer.start();
        }
    }

    public synchronized void stopThread() {
        this.isStopTimerRequested = true;
        if (this.timer.isAlive()) {
            this.timer.interrupt();
        }
    }

    class ContinuousRefreshEventTimer
    extends Thread {
        ContinuousRefreshEventTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ok = true;
            int numOutstandingRefreshTokens = 0;
            while (!ContinuousRefreshUpdateEventListener.this.isStopTimerRequested && ok && !ContinuousRefreshUpdateEventListener.this.isDisposed()) {
                try {
                    ContinuousRefreshEventTimer continuousRefreshEventTimer = this;
                    synchronized (continuousRefreshEventTimer) {
                        this.wait(ContinuousRefreshUpdateEventListener.this.getMillisecondDelay());
                    }
                    if (!ContinuousRefreshUpdateEventListener.this.isDisposed() && this.isAlive()) {
                        numOutstandingRefreshTokens = ContinuousRefreshUpdateEventListener.this.memoryServer.getNumOutstandingRefreshTokens();
                        while (numOutstandingRefreshTokens > 0) {
                            this.wait(10L);
                            numOutstandingRefreshTokens = ContinuousRefreshUpdateEventListener.this.memoryServer.getNumOutstandingRefreshTokens();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ok = false;
                }
                if (!ok || ContinuousRefreshUpdateEventListener.this.isStopTimerRequested) continue;
                ContinuousRefreshUpdateEventListener.this.raise();
            }
        }
    }
}

