/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.BooleanEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IExternalMemoryChangedEventHandler;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class ExternalMemoryChangedEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public ExternalMemoryChangedEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onExtMemoryChanged());
    }

    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        block4: {
            if (event.getSource() == this.refDspUser.onExtMemoryChanged()) {
                try {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("External Memory Changed", "ExternalMemoryChangedEventListener.syncHandleEvent", null);
                    }
                    boolean isExtendedMemoryEnabled = event.getBooleanData();
                    BooleanEventListenerItem item = new BooleanEventListenerItem(isExtendedMemoryEnabled, this);
                    this.eventHandlerThread.add(item);
                    this.raise(isExtendedMemoryEnabled);
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("External Memory Changed", "ExternalMemoryChangedEventListener.syncHandleEvent", e, null);
                }
            }
        }
        return true;
    }

    void raise(boolean isExtendedMemoryEnabled) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IExternalMemoryChangedEventHandler)hdlr).handleExternalMemoryChangedEvent(this.sourceObj, isExtendedMemoryEnabled);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnContinuousRefreshUpdateEvent exception", "ExternalMemoryChangedEventListener.raise", e, null);
            }
        }
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise(((BooleanEventListenerItem)eventListenerItem).getBooleanValue());
    }

    public void acquire() {
    }
}

