/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.FileLoadedEventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.FileLoadedEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IFileLoadedEventHandler;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.events.data.IFileLoadedEventData;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class FileLoadedEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public FileLoadedEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onFileLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onFileLoaded()) {
            int errCode = 0;
            IFileLoadedEventData eventData = null;
            try {
                eventData = (IFileLoadedEventData)event.getObjectData();
                errCode = eventData.getErrorCode();
                FileLoadedEventArgs args = new FileLoadedEventArgs(errCode, eventData.isSymbolsOnly());
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("ErrorCode = " + Integer.toString(args.getErrorCode()) + ", isSymbolsOnly = " + Boolean.toString(args.isSymbolsOnly()), "FileLoadedEventListener.syncHandleEvent", null);
                }
                FileLoadedEventListenerItem item = new FileLoadedEventListenerItem(args, this);
                this.eventHandlerThread.add(item);
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("ErrorCode = " + Integer.toString(errCode), "FileLoadedEventListener.syncHandleEvent", e, null);
                }
            }
            finally {
                if (eventData != null && !eventData.isDisposed()) {
                    eventData.dispose();
                }
            }
        }
        return true;
    }

    void raise(FileLoadedEventArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IFileLoadedEventHandler)hdlr).handleFileLoadedEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnFileLoadedEvent exception", "FileLoadedEventListener.raise", e, null);
            }
        }
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((FileLoadedEventArgs)eventListenerItem.getArgs());
    }

    public void acquire() {
    }
}

