/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.HaltEventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.HaltEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IHaltEventHandler;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class HaltEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public HaltEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onHalt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onHalt()) {
            IDspValue currentPC = null;
            long pc = -1L;
            try {
                currentPC = (IDspValue)event.getObjectData();
                pc = currentPC.toLongLong();
                if (pc < 0L) {
                    pc &= Long.MAX_VALUE;
                }
                HaltEventArgs myHaltEventArgs = new HaltEventArgs(pc);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("PC = 0x" + Long.toHexString(pc), "HaltEventListener.syncHandleEvent", null);
                }
                HaltEventListenerItem item = new HaltEventListenerItem(myHaltEventArgs, this);
                this.eventHandlerThread.add(item);
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("PC = 0x" + Long.toHexString(pc), "HaltEventListener.syncHandleEvent", e, null);
                }
            }
            finally {
                if (currentPC != null && !currentPC.isDisposed()) {
                    currentPC.dispose();
                }
            }
        }
        return true;
    }

    void raise(HaltEventArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IHaltEventHandler)hdlr).handleHaltEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnHaltEvent exception", "HaltEventListener.raise", e, null);
            }
        }
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((HaltEventArgs)eventListenerItem.getArgs());
    }

    public void acquire() {
    }
}

