/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryMapChangedEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.MemoryEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class MemoryMapChangedEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public MemoryMapChangedEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onMemoryMapUpdate());
    }

    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        block4: {
            if (event.getSource() == this.refDspUser.onMemoryMapUpdate()) {
                try {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Memory AdrsMap Update", "MemoryMapChangedEventListener.syncHandleEvent", null);
                    }
                    MemoryEventListenerItem item = new MemoryEventListenerItem(null, this);
                    this.eventHandlerThread.add(item);
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("Memory AdrsMap Update", "MemoryMapChangedEventListener.syncHandleEvent", e, null);
                }
            }
        }
        return true;
    }

    void raise() {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IMemoryMapChangedEventHandler)hdlr).handleMemoryMapChangedEvent(this.sourceObj);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnContinuousRefreshUpdateEvent exception", "MemoryMapChangedEventListener.raise", e, null);
            }
        }
    }

    public void acquire() {
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise();
    }
}

