/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryRequestCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.MemoryEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class MemoryRequestCompleteEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public MemoryRequestCompleteEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onMemoryRequestComplete());
    }

    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        block5: {
            if (event.getSource() == this.refDspUser.onMemoryRequestComplete()) {
                IDspMemory memory = null;
                IMemoryAccessEventData data = null;
                IDspValue dspStartAddress = null;
                int numMAUs = 0;
                long startAdrs = -1L;
                try {
                    data = (IMemoryAccessEventData)event.getObjectData();
                    memory = data.getMemory();
                    boolean requestAborted = data.wasRequestAborted();
                    short pageNum = (short)memory.getPageNumber();
                    dspStartAddress = this.refDspUser.createDspValue(IDspValue.Type.UDATA64, 0L);
                    memory.getStartAddress(dspStartAddress);
                    startAdrs = dspStartAddress.toLongLong();
                    if (startAdrs < 0L) {
                        startAdrs = UInt63.getFromSignedLong(startAdrs);
                    }
                    numMAUs = memory.getLength();
                    MemoryUpdateArgs myMemoryUpdateArgs = new MemoryUpdateArgs(pageNum, startAdrs, numMAUs, true, requestAborted, memory);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("OnMemoryRequestComplete(startAdrs=0x" + dspStartAddress.toStringTIStyleHex() + ", length = 0x" + Integer.toHexString(numMAUs) + "), aborted = " + Boolean.toString(requestAborted), "MemoryRequestCompleteEventListener.synchHandleEvent", null);
                    }
                    MemoryEventListenerItem item = new MemoryEventListenerItem(myMemoryUpdateArgs, this);
                    this.eventHandlerThread.add(item);
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block5;
                    MemoryServerTrace.logException("startAdrs=0x" + Long.toHexString(startAdrs) + ", length = 0x" + Integer.toHexString(numMAUs), "MemoryRequestCompleteEventListener.syncHandleEvent", e, null);
                }
            }
        }
        return true;
    }

    public void raise(MemoryUpdateArgs args) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS) && this.listOfEvents.size() > 1) {
            MemoryServerTrace.logWarning("MemoryRequestCompleteEventListener.listOfEvents.size() == " + Integer.toString(this.listOfEvents.size()), "MemoryRequestCompleteEventListener.raise", null);
        }
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IMemoryRequestCompleteEventHandler)hdlr).handleMemoryRequestCompleteEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("IMemoryRequestCompleteEventHandler exception", "MemoryRequestCompleteEventListener.raise", e, null);
            }
        }
    }

    public void acquire() {
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((MemoryUpdateArgs)eventListenerItem.getArgs());
    }
}

