/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryUpdateEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.MemoryEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class MemoryUpdateEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public MemoryUpdateEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onRefreshWithReason());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onRefreshWithReason()) {
            IRefreshEventData data = null;
            data = (IRefreshEventData)event.getObjectData();
            if (data.getReasonForRefresh() == IRefreshEventData.RefreshReason.TargetWrite) {
                long startAdrs = -1L;
                try {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("onRefreshWithReason(reason=" + data.getReasonForRefresh(), "MemoryUpdateEventListener.syncHandleEvent", null);
                    }
                    MemoryEventListenerItem item = new MemoryEventListenerItem(null, this);
                    this.eventHandlerThread.add(item);
                }
                catch (Exception e) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logException("startAdrs=0x" + Long.toHexString(startAdrs), "MemoryUpdateEventListener.syncHandleEvent", e, null);
                    }
                }
                finally {
                    if (data != null && !data.isDisposed()) {
                        data.dispose();
                    }
                }
            }
        }
        return true;
    }

    public void raise(MemoryUpdateArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IMemoryUpdateEventHandler)hdlr).handleMemoryUpdateEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                MemoryServerTrace.logException("OnMemoryUpdateEvent exception", "MemoryUpdateEventListener.raise", e, null);
            }
        }
    }

    public void acquire() {
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((MemoryUpdateArgs)eventListenerItem.getArgs());
    }
}

