/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumReasonForRefresh;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ProbePointHitEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.public_events.IClientRefreshRequiredEventHandler;
import com.ti.ccstudio.debug.memoryserver.public_events.RefreshRequiredEventArgs;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.ccstudio.debug.memoryserver.target.RefreshToken;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IRegisteredView;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import java.util.EventListener;
import java.util.EventObject;

public class ProbePointHitEventListener
implements IDisposable,
IObjectEventListener<IRefreshEventData>,
IRaiseEventOnThread,
EventListener,
IClientRefreshRequiredEventHandler {
    private IRegisteredView registeredView;
    private IClientRefreshRequiredEventHandler client = null;
    private EventHandlerThread eventHandlerThread = null;
    private String clientName = "";
    private MemoryServer memoryServer = null;
    private EventObject sourceObj = null;

    public ProbePointHitEventListener(IDspUser refDspUser, IClientRefreshRequiredEventHandler client, String clientName, MemoryServer memoryServer, EventHandlerThread eventHdlrThread) {
        this.client = client;
        this.memoryServer = memoryServer;
        this.registeredView = refDspUser.registerViewForRefresh(clientName);
        this.eventHandlerThread = eventHdlrThread;
        this.registeredView.onRefreshWithReason().addIObjectEventListener((IObjectEventListener)this);
        this.sourceObj = new EventObject(this);
    }

    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((RefreshRequiredEventArgs)eventListenerItem.getArgs());
    }

    void raise(RefreshRequiredEventArgs args) {
        block3: {
            try {
                this.client.handleClientRefreshRequiredEvent(this.sourceObj, args);
                RefreshToken refreshToken = args.getRefreshToken();
                if (refreshToken != null) {
                    this.memoryServer.endRefresh(this, refreshToken);
                }
                args.setRefreshToken(null);
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                MemoryServerTrace.logException("ProbePointHitEventListener exception", "ProbePointHitEventListener.raise", e, null);
            }
        }
    }

    public String toString() {
        return "MemoryServer.ProbePointHitEventListener";
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed()) {
            if (this.registeredView != null && !this.registeredView.isDisposed()) {
                this.registeredView.dispose();
            }
            this.registeredView = null;
        }
    }

    @Override
    public void handleClientRefreshRequiredEvent(EventObject sender, RefreshRequiredEventArgs args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(IRefreshEventData data) {
        if (data.getReasonForRefresh() == IRefreshEventData.RefreshReason.ProbePointHit || data.getReasonForRefresh() == IRefreshEventData.RefreshReason.UserRequested) {
            String info = "Probe point hit: client name = " + this.getClientName();
            try {
                RefreshRequiredEventArgs args = new RefreshRequiredEventArgs(data.getRefreshType() == IRefreshEventData.RefreshType.RetainHighlights, 0, 0L, 0L, EnumReasonForRefresh.PROBE_POINT_HIT, info);
                args.setRefreshToken((RefreshToken)this.memoryServer.beginRefresh(this));
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo(info, "ProbePointHitEventListener.syncHandleEvent", null);
                }
                ProbePointHitEventListenerItem item = new ProbePointHitEventListenerItem(args, this);
                this.eventHandlerThread.add(item);
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException(info, "ProbePointHitEventListener.syncHandleEvent", e, null);
                }
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

