/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspRegister;

public class RegisterUpdateArgs
extends EventArgs
implements IDisposable {
    private int id = 0;
    private String name = null;
    private int valueArg = 0;
    private long addressOfRegister = 0L;
    private int numMAUs = 0;
    private int pageRegisterIsLocatedIn = 0;
    private boolean is_self = false;
    private boolean is_aborted = false;
    private IDspRegister dspRegisterObj;
    private volatile boolean isDisposed = false;

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.valueArg;
    }

    public long getAddressOfRegister() {
        return this.addressOfRegister;
    }

    public int getNumMAUs() {
        return this.numMAUs;
    }

    public int getPageRegisterIsLocatedIn() {
        return this.pageRegisterIsLocatedIn;
    }

    public boolean isSelf() {
        return this.is_self;
    }

    public boolean isAborted() {
        return this.is_aborted;
    }

    public IDspRegister getDspRegisterObj() {
        return this.dspRegisterObj;
    }

    public RegisterUpdateArgs(int id, String name, int value, int page, long address, int lengthInMAUs, boolean isSelf, IDspRegister ccsDspRegister, boolean isAborted) {
        this.id = id;
        this.name = name;
        this.valueArg = value;
        this.pageRegisterIsLocatedIn = page;
        this.addressOfRegister = UInt63.getFromSignedLong(address);
        this.numMAUs = lengthInMAUs;
        this.is_self = isSelf;
        this.dspRegisterObj = ccsDspRegister;
        this.is_aborted = isAborted;
    }

    public String toString() {
        String result = "RegisterUpdateArgs: Reg ID=0x" + Long.toHexString(this.id) + ", Reg address=0x" + Long.toHexString(this.addressOfRegister) + ", num MAUs=" + Long.toString(this.numMAUs);
        if (this.is_aborted) {
            result = result + "! RegisterReadRequest aborted";
        }
        return result;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.dspRegisterObj.isDisposed()) {
            this.dspRegisterObj.dispose();
        }
        this.dspRegisterObj = null;
        this.isDisposed = true;
    }
}

