/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IRegisterUpdateEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.RegisterEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.RegisterUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EventListener;

public class RegisterUpdateEventListener
extends AbstractDebugServerEventListener
implements IDisposable,
IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public RegisterUpdateEventListener(IDspUser refDspUser, EventHandlerThread eventHdlrThread) {
        super(refDspUser);
        this.eventHandlerThread = eventHdlrThread;
        this.addTrigger(refDspUser.onRegisterUpdate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onRegisterUpdate()) {
            IDspValue registerValue = null;
            IDspValue dspStartAddress = null;
            IDspRegister register = null;
            IRegisterAccessEventData regAccessEventData = null;
            String regName = "unknown";
            int regId = -1;
            try {
                regAccessEventData = (IRegisterAccessEventData)event.getObjectData();
                register = regAccessEventData.getRegister();
                boolean is_aborted = regAccessEventData.wasRequestAborted();
                regId = register.getID();
                boolean is_self = false;
                registerValue = this.refDspUser.createDspValue(EnumDspValueType.DSP_INT.getInt(), 0);
                register.getDspValue(registerValue, 0);
                dspStartAddress = this.refDspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0);
                if (dspStartAddress.sizeOf() == 0) {
                    dspStartAddress.dispose();
                    dspStartAddress = this.refDspUser.createDspValue(EnumDspValueType.DSP_POINTER.getInt(), 0);
                }
                register.getStartAddress(dspStartAddress);
                long startAdrs = dspStartAddress.toLongLong();
                if (startAdrs < 0L) {
                    startAdrs &= Long.MAX_VALUE;
                }
                RegisterUpdateArgs myRegisterUpdateArgs = new RegisterUpdateArgs(regId, regName, registerValue.toLong(), register.getPageNumber(), startAdrs, register.getLength(), is_self, register, is_aborted);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("Register " + regName + " (ID=0x" + Integer.toHexString(regId) + ") = 0x" + Long.toHexString(registerValue.toLong()), "RegisterUpdateEventListener.syncHandleEvent", null);
                }
                RegisterEventListenerItem item = new RegisterEventListenerItem(myRegisterUpdateArgs, this);
                this.eventHandlerThread.add(item);
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception: Register " + regName + " (ID=0x" + Integer.toHexString(regId) + ") = 0x" + Long.toHexString(registerValue.toLong()), "RegisterUpdateEventListener.syncHandleEvent", e, null);
                }
            }
            finally {
                if (registerValue != null && !registerValue.isDisposed()) {
                    registerValue.dispose();
                }
                if (dspStartAddress != null && !dspStartAddress.isDisposed()) {
                    dspStartAddress.dispose();
                }
                if (regAccessEventData != null && !regAccessEventData.isDisposed()) {
                    regAccessEventData.dispose();
                }
            }
        }
        return true;
    }

    void raise(RegisterUpdateArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((IRegisterUpdateEventHandler)hdlr).handleRegisterUpdateEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("OnRegisterUpdateEvent exception", "RegisterUpdateEventListener.raise", e, null);
            }
        }
    }

    public void acquire() {
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((RegisterUpdateArgs)eventListenerItem.getArgs());
    }
}

