/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.eventhandlers;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.AbstractDebugServerEventListener;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetPropertyEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.TargetPropertyEventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.TargetPropertyEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRaiseEventOnThread;
import com.ti.ccstudio.debug.memoryserver.target.EventHandlerThread;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.events.data.ITargetPropertyData;
import java.util.EventListener;

public class TargetPropertyGetEventListener
extends AbstractDebugServerEventListener
implements IRaiseEventOnThread {
    private EventHandlerThread eventHandlerThread = null;

    public TargetPropertyGetEventListener(IDspUser refDspUser, EventHandlerThread jobToRaiseEvents) {
        super(refDspUser);
        this.eventHandlerThread = jobToRaiseEvents;
        this.addTrigger(refDspUser.onPropertyGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncHandleEvent(ServerEvent event) {
        if (event.getSource() == this.refDspUser.onPropertyGet()) {
            boolean errorCode = false;
            boolean wasSuccessful = false;
            ITargetPropertyData result = null;
            try {
                result = (ITargetPropertyData)event.getObjectData();
                if (result != null) {
                    wasSuccessful = result.wasSuccessful();
                    ITargetPropertyData targetData = result;
                    TargetPropertyEventArgs myTargetPropertyArgs = new TargetPropertyEventArgs(targetData, true);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        String traceMsg = myTargetPropertyArgs.toString();
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo(traceMsg, "TargetPropertyGetEventListener.syncHandleEvent", null);
                        }
                    }
                    TargetPropertyEventListenerItem item = new TargetPropertyEventListenerItem(myTargetPropertyArgs, this);
                    this.eventHandlerThread.add(item);
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception in syncHandleEvent", "TargetPropertyGetEventListener.syncHandleEvent", e, null);
                }
            }
            finally {
                if (result != null && !result.isDisposed()) {
                    result.dispose();
                }
            }
        }
        return true;
    }

    public void raise(TargetPropertyEventArgs args) {
        for (int index = 0; index < this.listOfEvents.size(); ++index) {
            EventListener hdlr = (EventListener)this.listOfEvents.get(index);
            if (hdlr == null) continue;
            try {
                ((ITargetPropertyEventHandler)hdlr).handleOnTargetPropertyEvent(this.sourceObj, args);
                continue;
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                MemoryServerTrace.logException("TargetPropertyGetEvalEvent exception", "TargetPropertyGetEventListener.raise", e, null);
            }
        }
    }

    @Override
    public void raise(IEventListenerItem eventListenerItem) {
        this.raise((TargetPropertyEventArgs)eventListenerItem.getArgs());
    }

    public void acquire() {
    }
}

