/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.events.internal;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;

public class MemoryServerEventBaseClass
implements IDisposable {
    protected EventObject sourceObj = null;
    protected ArrayList<EventListener> listOfEventListeners = null;
    private volatile boolean disposed = false;

    public MemoryServerEventBaseClass(Object source) {
        this.sourceObj = new EventObject(source);
        this.listOfEventListeners = new ArrayList();
    }

    public void addListener(EventListener listener) {
        if (!this.listOfEventListeners.contains(listener)) {
            this.listOfEventListeners.add(listener);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
            MemoryServerTrace.logWarning("Client tried to register for event " + this.getClass().getSimpleName() + " more than once. sourceObj = " + this.sourceObj.getSource().toString(), "MemoryServerEventBaseClass.addListener(" + listener.getClass().getCanonicalName() + ")", null);
        }
    }

    public void removeListener(EventListener listener) {
        this.listOfEventListeners.remove(listener);
    }

    public int getNumListeners() {
        return this.listOfEventListeners.size();
    }

    public void clearEventListeners() {
        this.listOfEventListeners.clear();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            while (this.listOfEventListeners.size() > 0) {
                this.listOfEventListeners.remove(0);
            }
        }
        this.disposed = true;
    }

    public String toString() {
        String result = "";
        for (EventListener listener : this.listOfEventListeners) {
            result = result + listener.getClass().getSimpleName() + "\n";
        }
        return result;
    }

    public void acquire() {
    }
}

