/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.extensions;

import com.ti.ccstudio.debug.memoryserver.extensions.DebugServerEventHandler;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import java.util.LinkedList;
import java.util.List;

public class AsyncEventJob
extends Thread {
    private List<DebugServerEventHandler> eventHandlerQueue = new LinkedList<DebugServerEventHandler>();
    private List<ServerEvent> eventQueue = new LinkedList<ServerEvent>();
    private boolean isDisposed;

    public AsyncEventJob(String name) {
        super(name);
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.preemptAndReset(true);
    }

    public boolean shouldRun() {
        return !this.eventHandlerQueue.isEmpty() && !this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.shouldRun()) {
            DebugServerEventHandler handler = null;
            ServerEvent event = null;
            List<DebugServerEventHandler> list = this.eventHandlerQueue;
            synchronized (list) {
                if (this.eventHandlerQueue.isEmpty()) {
                    return;
                }
                handler = this.eventHandlerQueue.remove(0);
                event = this.eventQueue.remove(0);
            }
            boolean isStale = (Boolean)event.getProperty("isStale", false);
            if (isStale) continue;
            handler.asyncHandleEvent(event, null);
            handler.eventHandled(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEventHandler(DebugServerEventHandler handler, ServerEvent event) {
        if (this.isDisposed) {
            return;
        }
        List<DebugServerEventHandler> list = this.eventHandlerQueue;
        synchronized (list) {
            this.eventHandlerQueue.add(handler);
            this.eventQueue.add(event != null ? event : ServerEvent.DUMMY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndReset(boolean block) {
        this.stop();
        if (block) {
            try {
                if (this != Thread.currentThread()) {
                    this.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List<DebugServerEventHandler> list = this.eventHandlerQueue;
        synchronized (list) {
            this.eventHandlerQueue.clear();
            this.eventQueue.clear();
        }
    }
}

