/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.extensions;

import com.ti.ccstudio.debug.memoryserver.extensions.AsyncEventJob;
import com.ti.ccstudio.debug.memoryserver.extensions.ServerEvent;
import com.ti.debug.engine.events.data.IActivityEnabledEventData;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.IBooleanEventCallback;
import com.ti.debug.engine.events.types.INumberEvent;
import com.ti.debug.engine.events.types.INumberEventCallback;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventCallback;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventCallback;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.events.types.IStringEventCallback;
import com.ti.debug.engine.framework.IDisposable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DebugServerEventHandler {
    public static final int MODE_CONTINUOUS = 0;
    public static final int MODE_GATE = 1;
    public static final int MODE_TURNSTILE = 2;
    protected boolean isTurnstileMode;
    protected boolean isSyncOnlyMode;
    protected boolean isPreemptive;
    protected boolean isListening;
    protected boolean isDisposed;
    protected AsyncEventJob asyncEventJob;
    protected Set<ServerEvent> events = new HashSet<ServerEvent>();
    private Map<ISimpleEvent, SimpleEventCallback> simpleEventCallbacks = new HashMap<ISimpleEvent, SimpleEventCallback>();
    private Map<IBooleanEvent, BooleanEventCallback> booleanEventCallbacks = new HashMap<IBooleanEvent, BooleanEventCallback>();
    private Map<INumberEvent, NumberEventCallback> numberEventCallbacks = new HashMap<INumberEvent, NumberEventCallback>();
    private Map<IStringEvent, StringEventCallback> stringEventCallbacks = new HashMap<IStringEvent, StringEventCallback>();
    private Map<IObjectEvent<?>, ObjectEventCallback> objectEventCallbacks = new HashMap();

    protected DebugServerEventHandler(AsyncEventJob asyncEventJob) {
        this(asyncEventJob, 0);
    }

    protected DebugServerEventHandler(AsyncEventJob asyncEventJob, int listeningMode) {
        this.asyncEventJob = asyncEventJob;
        this.isSyncOnlyMode = asyncEventJob == null;
        this.isTurnstileMode = listeningMode == 2;
        this.isListening = listeningMode == 0;
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.stopListening();
        if (!this.isSyncOnlyMode && this.asyncEventJob != null) {
            this.asyncEventJob.preemptAndReset(true);
        }
        for (SimpleEventCallback simpleEventCallback : this.simpleEventCallbacks.values()) {
            simpleEventCallback.dispose();
        }
        for (BooleanEventCallback booleanEventCallback : this.booleanEventCallbacks.values()) {
            booleanEventCallback.dispose();
        }
        for (NumberEventCallback numberEventCallback : this.numberEventCallbacks.values()) {
            numberEventCallback.dispose();
        }
        for (ObjectEventCallback objectEventCallback : this.objectEventCallbacks.values()) {
            objectEventCallback.dispose();
        }
    }

    public void addTrigger(ISimpleEvent source) {
        if (source == null) {
            StackTraceElement e = new Exception().getStackTrace()[1];
            System.out.println("DebugServerEventHandler.addTrigger() - null source: " + e.getFileName() + " [" + e.getLineNumber() + "]");
            return;
        }
        this.simpleEventCallbacks.put(source, new SimpleEventCallback(source));
    }

    public void removeTrigger(ISimpleEvent source) {
        SimpleEventCallback callback = this.simpleEventCallbacks.remove(source);
        if (callback != null) {
            callback.dispose();
        }
    }

    public void addTrigger(IBooleanEvent source) {
        if (source == null) {
            StackTraceElement e = new Exception().getStackTrace()[1];
            System.out.println("DebugServerEventHandler.addTrigger() - null source: " + e.getFileName() + " [" + e.getLineNumber() + "]");
            return;
        }
        this.booleanEventCallbacks.put(source, new BooleanEventCallback(source));
    }

    public void removeTrigger(IBooleanEvent source) {
        BooleanEventCallback callback = this.booleanEventCallbacks.remove(source);
        if (callback != null) {
            callback.dispose();
        }
    }

    public void addTrigger(INumberEvent source) {
        if (source == null) {
            StackTraceElement e = new Exception().getStackTrace()[1];
            System.out.println("DebugServerEventHandler.addTrigger() - null source: " + e.getFileName() + " [" + e.getLineNumber() + "]");
            return;
        }
        this.numberEventCallbacks.put(source, new NumberEventCallback(source));
    }

    public void removeTrigger(INumberEvent source) {
        NumberEventCallback callback = this.numberEventCallbacks.remove(source);
        if (callback != null) {
            callback.dispose();
        }
    }

    public void addTrigger(IStringEvent source) {
        if (source == null) {
            StackTraceElement e = new Exception().getStackTrace()[1];
            System.out.println("DebugServerEventHandler.addTrigger() - null source: " + e.getFileName() + " [" + e.getLineNumber() + "]");
            return;
        }
        this.stringEventCallbacks.put(source, new StringEventCallback(source));
    }

    public void removeTrigger(IStringEvent source) {
        StringEventCallback callback = this.stringEventCallbacks.remove(source);
        if (callback != null) {
            callback.dispose();
        }
    }

    public void addTrigger(IObjectEvent source) {
        if (source == null) {
            StackTraceElement e = new Exception().getStackTrace()[1];
            System.out.println("DebugServerEventHandler.addTrigger() - null source: " + e.getFileName() + " [" + e.getLineNumber() + "]");
            return;
        }
        this.objectEventCallbacks.put(source, new ObjectEventCallback(source));
    }

    public void removeTrigger(IObjectEvent source) {
        ObjectEventCallback callback = this.objectEventCallbacks.remove(source);
        if (callback != null) {
            callback.dispose();
        }
    }

    public void setIsPreemptive(boolean value) {
        this.isPreemptive = value;
    }

    public void startListening() {
        this.isListening = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        ServerEvent[] eventsCopy = new ServerEvent[]{};
        Set<ServerEvent> set = this.events;
        synchronized (set) {
            eventsCopy = this.events.toArray(new ServerEvent[this.events.size()]);
        }
        for (ServerEvent event : eventsCopy) {
            event.dispose();
        }
        set = this.events;
        synchronized (set) {
            this.isListening = false;
            for (ServerEvent event : this.events) {
                event.dispose();
                event.setProperty("isStale", true);
            }
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(ServerEvent event) {
        if (!this.isListening) {
            event.dispose();
            return;
        }
        Set<ServerEvent> set = this.events;
        synchronized (set) {
            if (!this.isListening) {
                event.dispose();
                return;
            }
            this.events.add(event);
        }
        if (this.isTurnstileMode) {
            this.isListening = false;
        }
        if (!this.syncHandleEvent(event) || this.isSyncOnlyMode) {
            this.eventHandled(event);
            return;
        }
        if (this.asyncEventJob == null) {
            return;
        }
        if (this.isPreemptive) {
            this.asyncEventJob.preemptAndReset(false);
        }
        this.asyncEventJob.queueEventHandler(this, event);
        this.asyncEventJob.run();
    }

    public boolean syncHandleEvent(ServerEvent event) {
        return true;
    }

    public void asyncHandleEvent(ServerEvent event, Object monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventHandled(ServerEvent event) {
        event.dispose();
        Set<ServerEvent> set = this.events;
        synchronized (set) {
            this.events.remove(event);
        }
    }

    private class ObjectEventCallback
    implements IObjectEventCallback {
        private IObjectEvent source;

        public ObjectEventCallback(IObjectEvent source) {
            this.source = source;
            this.source.addListener((Object)this);
        }

        public void dispose() {
            this.source.removeListener((Object)this);
        }

        public void onEvent(Object data) {
            ServerEvent serverEvent = null;
            if (data instanceof IEventData) {
                serverEvent = new ServerEvent(this.source, (IEventData)data);
            } else if (data instanceof IDisposable) {
                serverEvent = new ServerEvent(this.source, (IDisposable)data);
            } else if (data instanceof IActivityEnabledEventData) {
                serverEvent = new ServerEvent(this.source, (IActivityEnabledEventData)data);
            }
            if (serverEvent == null) {
                System.out.println("DebugServer contact validation!The object in IObjectCallback.onEvent() in not an instance of IEventData or IDisposable!");
                assert (serverEvent != null);
            }
            DebugServerEventHandler.this.handleEvent(serverEvent);
        }
    }

    private class StringEventCallback
    implements IStringEventCallback {
        private IStringEvent source;

        public StringEventCallback(IStringEvent source) {
            this.source = source;
            this.source.addListener((Object)this);
        }

        public void dispose() {
            this.source.removeListener((Object)this);
        }

        public void onEvent(String data) {
            DebugServerEventHandler.this.handleEvent(new ServerEvent(this.source, data));
        }
    }

    private class NumberEventCallback
    implements INumberEventCallback {
        private INumberEvent source;

        public NumberEventCallback(INumberEvent source) {
            this.source = source;
            this.source.addListener((Object)this);
        }

        public void dispose() {
            this.source.removeListener((Object)this);
        }

        public void onEvent(long data) {
            DebugServerEventHandler.this.handleEvent(new ServerEvent(this.source, data));
        }
    }

    private class BooleanEventCallback
    implements IBooleanEventCallback {
        private IBooleanEvent source;

        public BooleanEventCallback(IBooleanEvent source) {
            this.source = source;
            this.source.addListener((Object)this);
        }

        public void dispose() {
            this.source.removeListener((Object)this);
        }

        public void onEvent(boolean data) {
            DebugServerEventHandler.this.handleEvent(new ServerEvent(this.source, data));
        }
    }

    private class SimpleEventCallback
    implements ISimpleEventCallback {
        private ISimpleEvent source;

        public SimpleEventCallback(ISimpleEvent source) {
            this.source = source;
            this.source.addListener((Object)this);
        }

        public void dispose() {
            this.source.removeListener((Object)this);
        }

        public void onEvent() {
            DebugServerEventHandler.this.handleEvent(new ServerEvent(this.source));
        }
    }
}

