/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.extensions;

import com.ti.debug.engine.events.data.IActivityEnabledEventData;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.INumberEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.framework.IDisposable;
import java.util.HashMap;
import java.util.Map;

public class ServerEvent {
    public static final ServerEvent DUMMY = new ServerEvent(null);
    private Object source;
    private boolean booleanData;
    private long numberData;
    private String stringData;
    private IDisposable disposableObjectData;
    private IEventData<?> eventObjectData;
    private IActivityEnabledEventData activityEventObjectData;
    private boolean getObjectDataCalled = false;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ServerEvent(ISimpleEvent source) {
        this.source = source;
    }

    public ServerEvent(IBooleanEvent source, boolean data) {
        this.source = source;
        this.booleanData = data;
    }

    public ServerEvent(INumberEvent source, long data) {
        this.source = source;
        this.numberData = data;
    }

    public ServerEvent(IStringEvent source, String data) {
        this.source = source;
        this.stringData = data;
    }

    public ServerEvent(IObjectEvent<?> source, IDisposable disposableObjectData) {
        this.source = source;
        this.disposableObjectData = disposableObjectData;
    }

    public ServerEvent(IObjectEvent<?> source, IEventData<?> eventObjectData) {
        this.source = source;
        this.eventObjectData = eventObjectData;
    }

    public ServerEvent(IObjectEvent<?> source, IActivityEnabledEventData activityEventObjectData) {
        this.source = source;
        this.activityEventObjectData = activityEventObjectData;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key, Object defaultValue) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Object value = this.properties.get(key);
            return value != null ? value : defaultValue;
        }
    }

    public boolean getBooleanData() {
        return this.booleanData;
    }

    public long getNumberData() {
        return this.numberData;
    }

    public String getStringData() {
        return this.stringData;
    }

    public Object getObjectData() {
        if (this.eventObjectData != null) {
            Object disposealbe = this.eventObjectData.getEventData();
            if (!(disposealbe instanceof IDisposable)) {
                System.out.println("DebugServer contact validation!The object returned by IEventData.getEventData() in not an instance of IDisposable!");
            }
            assert (disposealbe instanceof IDisposable);
            return (IDisposable)disposealbe;
        }
        if (this.disposableObjectData != null) {
            this.getObjectDataCalled = true;
            return this.disposableObjectData;
        }
        if (this.activityEventObjectData != null) {
            return this.activityEventObjectData;
        }
        System.out.println("ServerEvent.getObjectData() - the event data is null.");
        assert (false);
        return null;
    }

    void dispose() {
        if (this.eventObjectData != null) {
            this.eventObjectData = null;
        }
        if (this.disposableObjectData != null && !this.getObjectDataCalled) {
            this.disposableObjectData = null;
        }
    }
}

