/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.interfaces;

import com.ti.ccstudio.debug.memoryserver.MemoryPageHandler;
import com.ti.ccstudio.debug.memoryserver.TileConversionParameters;
import com.ti.ccstudio.debug.memoryserver.configoptions.ClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.configoptions.MemoryView;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumReasonForRefresh;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSpecialDisplayStrings;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestParameters;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMmuHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITiledMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.IMemoryItem;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.ListOfMemoryInfoItems;
import com.ti.ccstudio.debug.memoryserver.public_events.IClientRefreshRequiredEventHandler;
import com.ti.ccstudio.debug.memoryserver.public_events.IMemoryHierarchyUpdatedEventHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.util.DataTypeFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface IMemoryServer {
    public boolean isMemoryAnalysisSupported();

    public boolean isPhysicalMemorySupported();

    public boolean isMmuBypassSupported();

    public Collection<MemoryView> getSupportedViews();

    public int getMaxAddressBusWidth(short var1, EnumMemoryViews var2);

    public boolean isMemoryLevelVisibilitySupported();

    public ClientConfigOptions getClientConfigOptions();

    public int getAddressIncrementInMAUs(MemoryRequestDescriptor var1);

    public void flushAllHostCachesOfTargetMemory(EnumReasonForRefresh var1);

    public void flushHostCachesOfTargetMemory(short var1, boolean var2);

    public EnumMemoryRequestErrorCodes requestTargetMemoryRead(Object var1, long var2, int var4, IMemoryRequestParameters var5, IMemoryRequestClient var6, Object var7, long[] var8, String[] var9);

    public EnumMemoryRequestErrorCodes requestTiledTargetMemoryRead(Object var1, IMemoryRequestParameters var2, TileConversionParameters var3, ITiledMemoryRequestClient var4, Object var5, long[] var6, String[] var7);

    public List<IMemoryItem> readTiledMemoryItems(MemoryRequestDescriptor var1);

    public long getTiledAddress(TileConversionParameters var1, EnumDspValueType var2);

    public void getTiledRowColumnFromAddress(long var1, TileConversionParameters var3, EnumDspValueType var4);

    public EnumMemoryRequestErrorCodes requestCExpressionEvaluation(Object var1, String var2, IMemoryRequestParameters var3, IMemoryRequestClient var4, Object var5, long[] var6, String[] var7);

    public EnumMemoryRequestErrorCodes requestTargetMemoryWrite_Data(Object var1, long var2, long var4, IMemoryRequestParameters var6, IMemoryRequestClient var7, Object var8, long[] var9, String[] var10);

    public EnumMemoryRequestErrorCodes requestTargetMemoryWrite_String(Object var1, long var2, String var4, IMemoryRequestParameters var5, IMemoryRequestClient var6, Object var7, long[] var8, String[] var9);

    public String readMemory_String(long var1, MemoryRequestDescriptor var3, long[] var4, EnumMemoryServerErrorCodes[] var5);

    public boolean readMemory_UpdateAdrsSpecificProperties(long var1, MemoryRequestDescriptor var3, ListOfMemoryInfoItems[] var4, EnumMemoryServerErrorCodes[] var5);

    public int getNumMAUsPerMemoryItem(MemoryRequestDescriptor var1);

    public List<DataTypeFormat> getSupportedTypes(short var1);

    public String getSpecialDataStringForMemoryItem(MemoryRequestDescriptor var1, EnumSpecialDisplayStrings var2);

    public boolean readMemoryItems(long var1, ArrayList<IMemoryItem> var3, MemoryRequestDescriptor var4, EnumMemoryServerErrorCodes[] var5);

    public String getContextAsXmlString();

    public void setContextFromXmlString(String var1, String var2);

    public void registerForRefreshRequiredCallback(IClientRefreshRequiredEventHandler var1);

    public void unRegisterForRefreshRequiredCallback(IClientRefreshRequiredEventHandler var1, boolean var2);

    public void registerForContinuousRefreshCallback(IClientRefreshRequiredEventHandler var1);

    public void unRegisterForContinuousRefreshCallback(IClientRefreshRequiredEventHandler var1, boolean var2);

    public void registerForProbePointHitCallback(IClientRefreshRequiredEventHandler var1, String var2);

    public void unRegisterForProbePointHitCallback(IClientRefreshRequiredEventHandler var1, boolean var2);

    public void registerForMemoryHierarchyUpdatedEventCallback(IMemoryHierarchyUpdatedEventHandler var1);

    public void unRegisterForMemoryHierarchyUpdatedEventCallback(IMemoryHierarchyUpdatedEventHandler var1, boolean var2);

    public Object beginRefresh(IClientRefreshRequiredEventHandler var1);

    public void endRefresh(IClientRefreshRequiredEventHandler var1, Object var2);

    public IMmuHandler getMmuHandler();

    public ArrayList<MemoryPageHandler> getMemoryPageHandlerList();

    public void setContinuousRefreshInterval(int var1);
}

