/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRegionStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsRegion;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class AdrsMap
implements Iterable<IMemoryRegion> {
    private String mapName;
    private MemoryTypeDescriptor memoryTypeDescriptor = null;
    protected IRecyclingFactory classFactory = null;
    protected ITargetDeviceInfo targetDeviceInfo = null;
    protected short memoryPageNum = 0;
    protected List<IMemoryRegion> adrsRegionList;
    private int currentIndex = -1;

    public AdrsMap(ITargetDeviceInfo targetInfo, short memoryPageNumber, String name, MemoryTypeDescriptor memType, IRecyclingFactory memoryAttributeClassFactoryObj) {
        this.classFactory = memoryAttributeClassFactoryObj;
        this.mapName = name;
        this.memoryPageNum = memoryPageNumber;
        this.memoryTypeDescriptor = memType;
        this.adrsRegionList = Collections.synchronizedList(new ArrayList());
        this.targetDeviceInfo = targetInfo;
    }

    public String getMapName() {
        return this.mapName;
    }

    public MemoryTypeDescriptor getMemoryTypeDescriptor() {
        return this.memoryTypeDescriptor;
    }

    public void setMemoryTypeDescriptor(MemoryTypeDescriptor value) {
        this.memoryTypeDescriptor = value;
    }

    public IRecyclingFactory getClassFactory() {
        return this.classFactory;
    }

    public void setClassFactory(IRecyclingFactory value) {
        this.classFactory = value;
    }

    public ITargetDeviceInfo getTargetDeviceInfo() {
        return this.targetDeviceInfo;
    }

    public long getMinAdrs() {
        return this.targetDeviceInfo.getMinAdrsInMemoryPage(this.memoryPageNum);
    }

    public long getMaxAdrs(EnumMemoryViews view) {
        return this.targetDeviceInfo.getMaxAdrsInMemoryPage(this.memoryPageNum, view);
    }

    public long getMaxAdrs() {
        return this.getMaxAdrs(EnumMemoryViews.CPU_MEMORY_VIEW);
    }

    public short getMemoryPageNum() {
        return this.memoryPageNum;
    }

    public int getAdrsRegionCount() {
        return this.adrsRegionList.size();
    }

    public void addRegion(long startAdrs, long endAdrs, EnumMemoryViews memoryView) {
        ArrayList<IMemoryRegion> list = new ArrayList<IMemoryRegion>();
        this.getListOfHolesInMap(startAdrs, endAdrs, memoryView, list);
        for (IMemoryRegion region : list) {
            this.adrsRegionList.add(region);
        }
        Collections.sort(this.adrsRegionList);
    }

    public void discardRequest(MemoryRequestDescriptor request) {
        for (IMemoryRegion adrsRegion : this.adrsRegionList) {
            adrsRegion.getOriginalClientRequestList().remove(request);
        }
    }

    public void addRegion(IMemoryRegion adrsRegion) {
        ArrayList<IMemoryRegion> list = new ArrayList<IMemoryRegion>();
        this.getListOfRegionsInAddressRange(adrsRegion.getStartAdrs(), adrsRegion.getLengthInMAUs(), list);
        if (list.size() != 0 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to add a region overlapping existing regions:(StartAdrs = " + Long.toHexString(adrsRegion.getStartAdrs()) + ", endAdrs = " + Long.toHexString(adrsRegion.getEndAdrs()) + ")", "AdrsMap.addRegion", null);
        }
        if (list.size() == 0) {
            this.adrsRegionList.add(adrsRegion);
        } else {
            this.addRegion(adrsRegion.getStartAdrs(), adrsRegion.getEndAdrs(), adrsRegion.getMemoryView());
            adrsRegion.release();
        }
        Collections.sort(this.adrsRegionList);
    }

    public void removeRegion(IMemoryRegion adrsRegion) {
        this.adrsRegionList.remove(adrsRegion);
        Collections.sort(this.adrsRegionList);
    }

    public void clearMap() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("AdrsMap " + this.getMapName() + " for " + this.getMemoryTypeDescriptor().getName() + " - Clearing " + Integer.toString(this.adrsRegionList.size()) + " adrs regions from map", "AdrsMap.clearMap", null);
        }
        IMemoryRegion adrsRegion = null;
        int i = 0;
        while (i < this.adrsRegionList.size()) {
            adrsRegion = this.adrsRegionList.get(i);
            if (!adrsRegion.getStatus().contains((Object)EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING)) {
                adrsRegion.release();
                this.adrsRegionList.remove(i);
                continue;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Leaving pending address region " + adrsRegion.toString(), "AdrsMap.clearMap", null);
            }
            ++i;
        }
    }

    public void defragmentMap() {
        boolean merged = false;
        long followingAdrs = 0L;
        long firstRegionStartAdrs = 0L;
        long firstRegionLength = 0L;
        if (this.adrsRegionList.size() > 1) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Defragmenting  " + this.getMapName() + " [" + Integer.toString(this.adrsRegionList.size()) + " regions]", "AdrsMap.DefragmentMap", null);
            }
            AdrsRegion firstRegion = (AdrsRegion)this.adrsRegionList.get(0);
            AdrsRegion nextRegion = null;
            int index = 1;
            while (index < this.adrsRegionList.size()) {
                nextRegion = (AdrsRegion)this.adrsRegionList.get(index);
                long[] outFollowingAdrs = new long[]{followingAdrs};
                firstRegion.getFollowingAdrs(this.getMaxAdrs(firstRegion.getMemoryView()), outFollowingAdrs);
                followingAdrs = outFollowingAdrs[0];
                if (nextRegion.getStartAdrs() == followingAdrs) {
                    firstRegionStartAdrs = firstRegion.getStartAdrs();
                    firstRegionLength = firstRegion.getLengthInMAUs();
                    merged = firstRegion.mergeWithNextAdjacentRegion(nextRegion);
                } else {
                    merged = false;
                }
                if (merged) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Defrag - merging  region " + Integer.toString(index - 1) + "[start adrs=0x" + Long.toHexString(firstRegionStartAdrs) + ", length=0x" + Long.toHexString(firstRegionLength) + ", flags=0x" + Long.toHexString(firstRegion.getMemoryLevelEnableFlags()) + ", status=" + firstRegion.getStatus() + "] with region " + Integer.toString(index) + " [start adrs=0x" + Long.toHexString(nextRegion.getStartAdrs()) + ", length=0x" + Long.toHexString(nextRegion.getLengthInMAUs()) + ", flags=0x" + Long.toHexString(nextRegion.getMemoryLevelEnableFlags()) + ", status=" + nextRegion.getStatus() + "], new length=0x" + Long.toHexString(firstRegion.getLengthInMAUs()), "AdrsMap.defragmentMap", null);
                    }
                    this.adrsRegionList.remove(nextRegion);
                    firstRegion.getListOfDefraggedAdrsRegions().add(nextRegion);
                    continue;
                }
                firstRegion = nextRegion;
                ++index;
            }
        }
    }

    public boolean contains(AdrsRegion adrsRegion) {
        boolean result = this.adrsRegionList.contains(adrsRegion);
        return result;
    }

    public boolean isAdrsInMap(long adrs) {
        boolean found = false;
        for (IMemoryRegion adrsRegion : this.adrsRegionList) {
            if (!adrsRegion.isAdrsInRegion(adrs)) continue;
            found = true;
            break;
        }
        return found;
    }

    public IMemoryRegion findAdrsRegionContainingAdrs(long adrs) {
        IMemoryRegion foundAdrsRegion = null;
        for (IMemoryRegion adrsRegion : this.adrsRegionList) {
            if (!adrsRegion.isAdrsInRegion(adrs)) continue;
            foundAdrsRegion = adrsRegion;
            break;
        }
        return foundAdrsRegion;
    }

    public IMemoryRegion findClosestAdrsRegionHigherThanAdrs(long adrs) {
        IMemoryRegion nextAdrsRegion = null;
        for (IMemoryRegion adrsRegion : this.adrsRegionList) {
            if (adrsRegion.getStartAdrs() <= adrs && adrsRegion.getEndAdrs() <= adrs) continue;
            nextAdrsRegion = adrsRegion;
            break;
        }
        return nextAdrsRegion;
    }

    public IMemoryRegion findClosestAdrsRegionLowerThanAdrs(long adrs) {
        IMemoryRegion prevAdrsRegion = null;
        boolean found = false;
        for (IMemoryRegion adrsRegion : this.adrsRegionList) {
            if (adrsRegion.getEndAdrs() < adrs || adrsRegion.getStartAdrs() < adrs) {
                found = true;
                break;
            }
            prevAdrsRegion = adrsRegion;
        }
        if (!found) {
            prevAdrsRegion = null;
        }
        return prevAdrsRegion;
    }

    public void getListOfRegionsInAddressRange(long startAdrs, long numMAUs, ArrayList<IMemoryRegion> list) {
        this.getListOfRegionsInAddressRange(startAdrs, numMAUs, list, EnumSet.of(EnumMemoryRegionStatus.READY_FOR_USE, EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING, EnumMemoryRegionStatus.ABORT_PENDING));
    }

    private boolean doesRegionStatusMeetFilterCriteria(EnumSet<EnumMemoryRegionStatus> regionStatus, EnumSet<EnumMemoryRegionStatus> filterCriteria) {
        boolean result = false;
        for (EnumMemoryRegionStatus flag : regionStatus) {
            if (!filterCriteria.contains((Object)flag)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void getListOfRegionsInAddressRange(long startAdrs, long numMAUs, ArrayList<IMemoryRegion> list, EnumSet<EnumMemoryRegionStatus> filter) {
        long endAdrsInRange = this.targetDeviceInfo.getEndAdrsInRange(startAdrs, numMAUs, this.memoryPageNum);
        IMemoryRegion region = this.findAdrsRegionContainingAdrs(startAdrs);
        if (region == null) {
            region = this.findClosestAdrsRegionHigherThanAdrs(startAdrs);
        }
        while (region != null && region.getStartAdrs() <= endAdrsInRange) {
            if (this.doesRegionStatusMeetFilterCriteria(region.getStatus(), filter)) {
                list.add(region);
            }
            region = this.findClosestAdrsRegionHigherThanAdrs(region.getEndAdrs());
        }
    }

    public void getListOfHolesInMap(long startAdrs, long endAdrs, EnumMemoryViews memoryView, ArrayList<IMemoryRegion> list) {
        long maxAdrs = this.getMaxAdrs(memoryView);
        if (this.adrsRegionList.size() == 0) {
            IMemoryRegion newAdrsRegion = (IMemoryRegion)((Object)this.classFactory.createInstance());
            newAdrsRegion.config(startAdrs, endAdrs, this.memoryPageNum, memoryView, this.memoryTypeDescriptor.getGtiMemHierarchyReadEnableFlags(), this.memoryTypeDescriptor.getMemoryLevelEnableFlags());
            list.add(newAdrsRegion);
        } else {
            IMemoryRegion endAdrsRegion;
            long[] outFirstAdrs = new long[]{startAdrs};
            long[] outLastAdrs = new long[]{endAdrs};
            long[] outTempAdrs = new long[]{0L};
            IMemoryRegion newAdrsRegion = null;
            IMemoryRegion nextAdrsRegion = null;
            IMemoryRegion prevAdrsRegion = null;
            IMemoryRegion startAdrsRegion = this.findAdrsRegionContainingAdrs(startAdrs);
            if (startAdrsRegion != null) {
                startAdrsRegion.getFollowingAdrs(maxAdrs, outFirstAdrs);
            }
            if ((endAdrsRegion = this.findAdrsRegionContainingAdrs(endAdrs)) != null) {
                endAdrsRegion.getPreceedingAdrs(this.getMinAdrs(), outLastAdrs);
            }
            while (outFirstAdrs[0] <= endAdrs && outLastAdrs[0] >= startAdrs && outFirstAdrs[0] <= outLastAdrs[0]) {
                nextAdrsRegion = this.findClosestAdrsRegionHigherThanAdrs(outFirstAdrs[0]);
                if (nextAdrsRegion == null) {
                    newAdrsRegion = (IMemoryRegion)((Object)this.classFactory.createInstance());
                    newAdrsRegion.config(outFirstAdrs[0], outLastAdrs[0], this.getMemoryPageNum(), memoryView, this.memoryTypeDescriptor.getGtiMemHierarchyReadEnableFlags(), this.memoryTypeDescriptor.getMemoryLevelEnableFlags());
                    list.add(newAdrsRegion);
                    outFirstAdrs[0] = endAdrs;
                    break;
                }
                outTempAdrs[0] = outLastAdrs[0];
                nextAdrsRegion.getPreceedingAdrs(this.getMinAdrs(), outTempAdrs);
                prevAdrsRegion = this.findAdrsRegionContainingAdrs(outTempAdrs[0]);
                if (outTempAdrs[0] == outFirstAdrs[0] && prevAdrsRegion == null || outTempAdrs[0] >= outFirstAdrs[0]) {
                    if (outTempAdrs[0] > outLastAdrs[0]) {
                        outTempAdrs[0] = outLastAdrs[0];
                    }
                    newAdrsRegion = (IMemoryRegion)((Object)this.classFactory.createInstance());
                    newAdrsRegion.config(outFirstAdrs[0], outTempAdrs[0], this.getMemoryPageNum(), memoryView, this.getMemoryTypeDescriptor().getGtiMemHierarchyReadEnableFlags(), this.memoryTypeDescriptor.getMemoryLevelEnableFlags());
                    list.add(newAdrsRegion);
                }
                nextAdrsRegion.getFollowingAdrs(maxAdrs, outFirstAdrs);
            }
            Collections.sort(list);
        }
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public IMemoryRegion getCurrent() {
        IMemoryRegion result = null;
        if (this.adrsRegionList.size() > this.currentIndex) {
            result = this.adrsRegionList.get(this.currentIndex);
        }
        return result;
    }

    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.adrsRegionList.size()) {
            result = true;
        }
        return result;
    }

    @Override
    public Iterator<IMemoryRegion> iterator() {
        this.reset();
        return this.adrsRegionList.iterator();
    }

    public IMemoryRegion next() {
        IMemoryRegion result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.adrsRegionList.size()) {
            this.adrsRegionList.remove(this.currentIndex);
            if (this.currentIndex >= this.adrsRegionList.size()) {
                this.currentIndex = this.adrsRegionList.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

