/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRegionStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryRegionReadCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMmuHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestList;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class AdrsRegion
implements IFactoryCreatedObject,
IMemoryRegion,
IMemoryRequestClient {
    private RequestDescriptorQueue targetAccessRequestQueue = null;
    private IDspUser dspUser = null;
    private TargetHandler target = null;
    private IMmuHandler mmuHdlr = null;
    private TargetDeviceInfo targetInfo = null;
    private int memoryHierarchyReadEnableFlags = 0;
    private short memoryPageNum;
    private int memoryLevelEnableFlags = 0;
    private IDspMemory dspMemoryObj = null;
    private IDspMemory2 dspMemory2Obj = null;
    protected ArrayList<AdrsRegion> listOfDefraggedAdrsRegions = null;
    private Object tagObject = null;
    private EnumSet<EnumMemoryRegionStatus> status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
    private MemoryRequestDescriptor targetAccessRequestDescriptor = null;
    private long startAdrs = 0L;
    private long endAdrs;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private RequestList originalClientRequestList;
    private MemoryRegionReadCompleteEvent onMemoryRegionReadComplete = null;
    public MemoryServerEvent onRelease;
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;

    public AdrsRegion(TargetHandler targetDevice, RequestDescriptorQueue targetAccessRequestQueue, IMmuHandler mmuHdlr) {
        this.target = targetDevice;
        this.mmuHdlr = mmuHdlr;
        this.targetInfo = this.target.info;
        this.dspUser = this.target.getDspUser();
        this.targetAccessRequestQueue = targetAccessRequestQueue;
        this.originalClientRequestList = new RequestList();
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED));
        this.targetAccessRequestDescriptor = null;
        this.listOfDefraggedAdrsRegions = new ArrayList();
        this.onMemoryRegionReadComplete = new MemoryRegionReadCompleteEvent(this);
    }

    public long getMinimumMemoryRegionBlockSizeInMaus() {
        long result = 1L;
        if (this.target != null) {
            result = this.target.info.getMinNumMausPerMemoryRead();
        }
        return result;
    }

    @Override
    public short getMemoryPageNum() {
        return this.memoryPageNum;
    }

    @Override
    public void setMemoryPageNum(short value) {
        this.memoryPageNum = value;
    }

    @Override
    public int getMemoryLevelEnableFlags() {
        return this.memoryLevelEnableFlags;
    }

    @Override
    public void setMemoryLevelEnableFlags(int value) {
        this.memoryLevelEnableFlags = value;
    }

    public IDspMemory getDspMemoryObj() {
        return this.dspMemoryObj;
    }

    private void setDspMemoryObj(IDspMemory value) {
        if (this.dspMemoryObj != null && !this.dspMemoryObj.isDisposed()) {
            this.dspMemoryObj.dispose();
        }
        this.dspMemoryObj = value;
        if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
            this.dspMemory2Obj.dispose();
        }
        this.dspMemory2Obj = value.getIDspMemory2();
    }

    public ArrayList<AdrsRegion> getListOfDefraggedAdrsRegions() {
        return this.listOfDefraggedAdrsRegions;
    }

    public Object getTagObject() {
        return this.tagObject;
    }

    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    @Override
    public EnumSet<EnumMemoryRegionStatus> getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EnumSet<EnumMemoryRegionStatus> value) {
        this.status.clear();
        this.status.addAll(value);
    }

    public MemoryRequestDescriptor getTargetAccessRequestDescriptor() {
        return this.targetAccessRequestDescriptor;
    }

    public void setTargetAccessRequestDescriptor(MemoryRequestDescriptor value) {
        this.targetAccessRequestDescriptor = value;
    }

    @Override
    public void release() {
        if (this.targetAccessRequestDescriptor != null) {
            this.targetAccessRequestDescriptor.releaseAndDequeue();
            this.targetAccessRequestDescriptor = null;
        }
        for (RequestDescriptorBaseClass req : this.originalClientRequestList) {
            ((MemoryRequestDescriptor)req).releaseAndDequeue();
        }
        this.originalClientRequestList.clear();
        this.status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
        if (this.listOfDefraggedAdrsRegions.size() > 0) {
            for (AdrsRegion adrsRegion : this.listOfDefraggedAdrsRegions) {
                adrsRegion.release();
            }
            this.listOfDefraggedAdrsRegions.clear();
        }
        this.onMemoryRegionReadComplete.clearEventListeners();
        if (this.getFactory() != null) {
            this.getFactory().onRelease(this);
        }
    }

    public boolean mergeWithNextAdjacentRegion(AdrsRegion nextAdjacentRegion) {
        boolean merged = false;
        if (this.endAdrs < nextAdjacentRegion.getEndAdrs() && this.getStatus().contains((Object)EnumMemoryRegionStatus.READY_FOR_USE) && nextAdjacentRegion.getStatus().contains((Object)EnumMemoryRegionStatus.READY_FOR_USE)) {
            this.endAdrs = nextAdjacentRegion.getEndAdrs();
            if (this.dspMemoryObj != null) {
                this.dspMemoryObj.setLength((int)this.getLengthInMAUs());
                this.dspMemoryObj.copyOverlappingMemory(nextAdjacentRegion.getDspMemoryObj());
            }
            for (RequestDescriptorBaseClass reqObj : nextAdjacentRegion.getOriginalClientRequestList()) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("AdrsRegion.MergeWithNextAdjacentRegion - attempting to merge with a region that has " + nextAdjacentRegion.getOriginalClientRequestList().size() + " outstanding client requests: this=" + this.toString() + ",nextAdjacentRegion=" + nextAdjacentRegion.toString(), "AdrsRegion.mergeWithNextAdjacentRegion", this.target.info);
                }
                this.originalClientRequestList.add(reqObj);
            }
            nextAdjacentRegion.getOriginalClientRequestList().clear();
            merged = true;
        }
        return merged;
    }

    @Override
    public void abortPendingRequests() {
        if (this.targetAccessRequestDescriptor != null) {
            this.setStatus(EnumSet.of(EnumMemoryRegionStatus.ABORT_PENDING));
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO) && this.onMemoryRegionReadComplete != null) {
                MemoryServerTrace.logInfo("AdrsRegion.AbortPendingRequests - targetAccessRequestDescriptor = " + this.targetAccessRequestDescriptor.toString(), "AdrsRegion.abortPendingRequests", this.target.info);
            }
            this.onMemoryReadCompleted(EventArgs.Empty);
        }
    }

    protected synchronized void requestDspUserMemoryRead() {
        int flags = -1;
        if (this.mmuHdlr != null && this.mmuHdlr.useDriverMmuBypassAPIs()) {
            flags = this.target.getMemLevelInfoHdlr().calculateMemAccessIdFlags(this.memoryView, this.memoryHierarchyReadEnableFlags);
        }
        this.dspMemory2Obj.setMemoryAccessLevel(flags);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
            MemoryServerTrace.logTransaction("MemoryHierarchyReadEnableFlags = 0x" + Integer.toHexString(flags) + ", MemoryView = " + this.getMemoryView().toString() + ", mapOn = " + Boolean.toString(this.dspUser.getMapOn()), "AdrsRegion.requestDspUserMemoryRead", this.target.info);
        }
        this.dspUser.requestMemoryRead(this.dspMemoryObj, false);
        this.status = EnumSet.of(EnumMemoryRegionStatus.READY_FOR_USE);
    }

    public long getStartAddressOfLineContainingAdrs(long adrs) {
        long mask = this.getMinimumMemoryRegionBlockSizeInMaus() - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return UInt63.getFromSignedLong(adrs) & mask;
    }

    public long getEndAddressOfLineContainingAdrs(long adrs) {
        long mask = this.getMinimumMemoryRegionBlockSizeInMaus() - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return (UInt63.getFromSignedLong(adrs) & mask) + (this.getMinimumMemoryRegionBlockSizeInMaus() - 1L);
    }

    @Override
    public long getStartAdrs() {
        return this.startAdrs;
    }

    @Override
    public void setStartAdrs(long value) {
        this.startAdrs = this.getStartAddressOfLineContainingAdrs(value);
        if (this.endAdrs < this.startAdrs) {
            this.endAdrs = this.startAdrs;
        }
    }

    @Override
    public long getEndAdrs() {
        return this.endAdrs;
    }

    @Override
    public void setEndAdrs(long value) {
        this.endAdrs = this.getEndAddressOfLineContainingAdrs(value);
        if (this.startAdrs > this.endAdrs) {
            this.startAdrs = this.endAdrs;
        }
    }

    @Override
    public long getLengthInMAUs() {
        return this.targetInfo.getNumMausInAddressRange(this.startAdrs, this.endAdrs, this.memoryPageNum);
    }

    @Override
    public void setLengthInMAUs(long value) {
        this.endAdrs = this.targetInfo.getEndAdrsInRange(this.startAdrs, value, this.memoryPageNum);
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    @Override
    public RequestList getOriginalClientRequestList() {
        return this.originalClientRequestList;
    }

    @Override
    public void config(long startAddress, long endAddress, short memoryPageNumber, EnumMemoryViews memoryView, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAdrs = UInt63.getFromSignedLong(startAddress);
        long uEndAdrs = UInt63.getFromSignedLong(endAddress);
        this.memoryView = memoryView;
        long numMAUs = this.targetInfo.getNumMausInAddressRange(uStartAdrs, uEndAdrs, memoryPageNumber);
        this.config(startAddress, memoryPageNumber, memoryView, numMAUs, memoryHierarchyReadEnableFlags, memoryLevelEnableFlags);
    }

    @Override
    public void config(long startAddress, short memoryPageNumber, EnumMemoryViews memoryView, long numMAUs, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAdrs = UInt63.getFromSignedLong(startAddress);
        this.setStartAdrs(uStartAdrs);
        this.setEndAdrs(this.targetInfo.getEndAdrsInRange(uStartAdrs, numMAUs, memoryPageNumber));
        this.memoryPageNum = memoryPageNumber;
        this.memoryView = memoryView;
        this.memoryHierarchyReadEnableFlags = memoryHierarchyReadEnableFlags;
        this.memoryLevelEnableFlags = memoryLevelEnableFlags;
        this.targetAccessRequestDescriptor = null;
        if (this.dspUser != null) {
            int flags;
            IDspValue dspAdrs = this.dspUser.createDspValue(IDspValue.Type.UDATA64, this.startAdrs);
            long address = dspAdrs.toLongLong();
            if (this.dspMemoryObj != null) {
                this.dspMemoryObj.changeStartAddress(dspAdrs);
                if (this.dspMemoryObj.getLength() != (int)this.getLengthInMAUs()) {
                    this.dspMemoryObj.setLength((int)this.getLengthInMAUs());
                }
                if (this.dspMemoryObj.getPageNumber() != this.memoryPageNum) {
                    this.dspMemoryObj.setPageNumber((int)this.memoryPageNum);
                }
            } else {
                this.setDspMemoryObj(this.dspUser.createDspMemory(dspAdrs, (int)this.getLengthInMAUs(), memoryPageNumber));
            }
            if (0 == (flags = memoryHierarchyReadEnableFlags)) {
                flags = -1;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("AdrsRegion setting memory access level flags to 0x" + Integer.toHexString(flags), "AdrsRegion.config", this.targetInfo);
            }
            this.dspMemory2Obj.setMemoryAccessLevel(flags);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                this.dspMemoryObj.getStartAddress(dspAdrs);
                long checkAdrs = dspAdrs.toLongLong();
                if (checkAdrs != (long)((int)this.startAdrs)) {
                    String msg = "Setting dspAdrs to 0x" + Long.toHexString(this.startAdrs) + ", check value = 0x" + Long.toHexString(checkAdrs);
                    MemoryServerTrace.logWarning(msg, "AdrsRegion.config", this.targetInfo);
                }
            }
            dspAdrs.dispose();
        }
        this.status = EnumSet.of(EnumMemoryRegionStatus.CONFIGURED);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("Adrs Region configured: " + this.toString(), "AdrsRegion.config", this.targetInfo);
        }
    }

    public void configExact(long startAddress, short memoryPageNumber, EnumMemoryViews memoryView, long numMAUs, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAdrs;
        this.startAdrs = uStartAdrs = UInt63.getFromSignedLong(startAddress);
        this.endAdrs = this.targetInfo.getEndAdrsInRange(uStartAdrs, numMAUs, memoryPageNumber);
        this.memoryPageNum = memoryPageNumber;
        this.memoryView = memoryView;
        this.memoryHierarchyReadEnableFlags = memoryHierarchyReadEnableFlags;
        this.memoryLevelEnableFlags = memoryLevelEnableFlags;
        this.targetAccessRequestDescriptor = null;
        if (this.dspUser != null) {
            int flags;
            IDspValue dspAdrs = this.dspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.ordinal(), (int)this.startAdrs);
            if (dspAdrs.sizeOf() == 0) {
                dspAdrs.dispose();
                dspAdrs = this.dspUser.createDspValue(EnumDspValueType.DSP_POINTER.ordinal(), (int)this.startAdrs);
            }
            if (this.dspMemoryObj != null) {
                this.dspMemoryObj.changeStartAddress(dspAdrs);
                if (this.dspMemoryObj.getLength() != (int)this.getLengthInMAUs()) {
                    this.dspMemoryObj.setLength((int)this.getLengthInMAUs());
                }
                if (this.dspMemoryObj.getPageNumber() != this.memoryPageNum) {
                    this.dspMemoryObj.setPageNumber((int)this.memoryPageNum);
                }
            } else {
                this.setDspMemoryObj(this.dspUser.createDspMemory(dspAdrs, (int)this.getLengthInMAUs(), memoryPageNumber));
            }
            if (0 == (flags = this.memoryHierarchyReadEnableFlags)) {
                flags = -1;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("AdrsRegion setting memory access level flags to 0x" + Integer.toHexString(flags), "AdrsRegion.configExact", this.targetInfo);
            }
            this.dspMemory2Obj.setMemoryAccessLevel(flags);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                this.dspMemoryObj.getStartAddress(dspAdrs);
                long checkAdrs = dspAdrs.toLongLong();
                if (checkAdrs != (long)((int)this.startAdrs)) {
                    MemoryServerTrace.logWarning("Setting dspAdrs to 0x" + Long.toHexString(this.startAdrs) + ", check value = 0x" + Long.toHexString(checkAdrs), "AdrsRegion.Config", this.targetInfo);
                }
            }
            dspAdrs.dispose();
            this.status = EnumSet.of(EnumMemoryRegionStatus.CONFIGURED);
        }
    }

    @Override
    public void requestInfoFromTarget() {
        if (this.targetAccessRequestQueue != null) {
            if (this.targetAccessRequestQueue.getRequestDescriptorFactory() == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("AdrsRegion configuration error: RequestDescriptorFactory == null", "AdrsRegion.RequestInfoFromTarget", this.targetInfo);
            }
            if (this.targetAccessRequestDescriptor != null) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Attempt to assign targetAccessRequestDescriptor to an address region that already has one assigned:\n" + this.targetAccessRequestDescriptor.toString(), "\n AdrsRegion.Status = " + this.getStatus() + "AdrsRegion.RequestInfoFromTarget", this.targetInfo);
                }
                this.targetAccessRequestDescriptor.releaseAndDequeue();
                this.targetAccessRequestDescriptor = null;
            }
            this.targetAccessRequestDescriptor = (MemoryRequestDescriptor)this.targetAccessRequestQueue.getRequestDescriptorFactory().createInstance();
            if (this.originalClientRequestList.contains(this.targetAccessRequestDescriptor)) {
                MemoryServerTrace.logError("new clientRequest already exists in OriginalClientRequestList", "AdrsRegion.RequestInfoFromTarget", this.target.info);
            }
            if (this.targetAccessRequestQueue.containsRequest(this.targetAccessRequestDescriptor)) {
                MemoryServerTrace.logError("new clientRequest already exists in TargetAccessRequestQueue", "AdrsRegion.RequestInfoFromTarget", this.target.info);
            }
            this.status = EnumSet.of(EnumMemoryRegionStatus.MEMORY_REQUEST_PENDING);
            this.targetAccessRequestQueue.addRequest(this.targetAccessRequestDescriptor);
            this.targetAccessRequestDescriptor.config(this, EnumMemoryRequestTypes.READ, EnumStringFormatStyle.TI_STYLE_HEX, EnumDspValueType.DSP_INT, this.memoryPageNum, this.memoryLevelEnableFlags, (short)0, null, this.startAdrs, this.getLengthInMAUs(), this.getMemoryView(), this, this);
            this.targetAccessRequestDescriptor.setDspMemoryObj(this.dspMemoryObj);
            if (this.targetAccessRequestDescriptor != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                MemoryServerTrace.logTransaction("targetAccessRequestDescriptor created and configured: " + this.targetAccessRequestDescriptor.toString() + "\n" + this.targetAccessRequestQueue.getRequestDescriptorFactory().getStatus(), "AdrsRegion.RequestInfoFromTarget", this.targetInfo);
            }
            try {
                if (MemoryServer.TRACE__MEMORY_SERVER) {
                    System.out.println("requestDspUserMemoryRead() start @ " + System.currentTimeMillis() + " ms");
                }
                this.requestDspUserMemoryRead();
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException(e.getMessage(), "AdrsRegion.RequestInfoFromTarget", e, this.targetInfo);
                }
                this.targetAccessRequestDescriptor.releaseAndDequeue();
                this.targetAccessRequestDescriptor = null;
            }
        }
    }

    @Override
    public boolean getPreceedingAdrs(long minAdrs, long[] preceedingAdrs) {
        boolean retval = true;
        preceedingAdrs[0] = this.startAdrs;
        if (this.startAdrs > UInt63.getFromSignedLong(minAdrs)) {
            preceedingAdrs[0] = preceedingAdrs[0] - 1L;
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean getFollowingAdrs(long maxAdrs, long[] followingAdrs) {
        boolean retval = true;
        followingAdrs[0] = this.endAdrs;
        if (this.startAdrs < UInt63.getFromSignedLong(maxAdrs)) {
            followingAdrs[0] = this.targetInfo.getNextAdrs(followingAdrs[0], 1, this.memoryPageNum);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean isAdrsInRegion(long adrs) {
        long uAdrs = UInt63.getFromSignedLong(adrs);
        return uAdrs >= this.startAdrs && uAdrs <= this.endAdrs;
    }

    @Override
    public MemoryRegionReadCompleteEvent getOnMemoryRegionReadCompleteEvent() {
        return this.onMemoryRegionReadComplete;
    }

    public void onMemoryReadCompleted(EventArgs e) {
        if (MemoryServer.TRACE__MEMORY_SERVER) {
            System.out.println("AdrsRegion.onMemoryReadCompleted() start @ " + System.currentTimeMillis() + " ms");
        }
        if (this.onMemoryRegionReadComplete == null) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("TargetMemory: OnMemoryReadComplete == null (nobody to notify)", "AdrsRegion.OnMemoryReadCompleted", this.targetInfo);
            }
        } else {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("TargetMemory: invoking the OnMemoryReadComplete function: " + this.onMemoryRegionReadComplete.toString(), "AdrsRegion.OnMemoryReadCompleted", this.targetInfo);
            }
            this.onMemoryRegionReadComplete.raise(e);
        }
    }

    public String toString() {
        String result = "AdrsRegion ";
        result = result + " 0x" + Long.toHexString(this.startAdrs) + " - 0x" + Long.toHexString(this.endAdrs);
        result = result + ", PageNum=" + Long.toString(this.getMemoryPageNum());
        result = result + " LevelEnableFlags=0x" + Integer.toHexString(this.memoryLevelEnableFlags);
        result = result + " memoryHierarchyReadEnableFlags(for GTI)=0x" + Integer.toHexString(this.memoryHierarchyReadEnableFlags);
        result = result + " Status=" + this.getStatus() + "]";
        return result;
    }

    @Override
    public int compareTo(IMemoryRegion adrsRegion) {
        int retval = 0;
        if (this.startAdrs > adrsRegion.getStartAdrs()) {
            retval = 1;
        } else if (this.startAdrs < adrsRegion.getStartAdrs()) {
            retval = -1;
        }
        return retval;
    }

    @Override
    public void onMemoryRequestCompleteHandler(MemoryRequestDescriptor req, long requestStartAdrs, long requestLengthInMAUs) {
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED));
        if (this.targetAccessRequestDescriptor == null) {
            MemoryServerTrace.logError("targetAccessRequestDescriptor == null", "AdrsRegion.OnMemoryRequestCompleteHandler", this.targetInfo);
        }
        if (req == null) {
            MemoryServerTrace.logError("ccsMemoryRequestDescriptor == null", "AdrsRegion.OnMemoryRequestCompleteHandler", this.targetInfo);
        }
        if (this.targetAccessRequestDescriptor != null && req != null && req != this.targetAccessRequestDescriptor) {
            MemoryServerTrace.logError("Mismatched target access request descriptor: Expected: " + this.targetAccessRequestDescriptor.toString() + "\nReceived:" + req.toString(), "AdrsRegion.OnMemoryRequestCompleteHandler", this.targetInfo);
        }
        if (req.getMemoryUpdateInfo() == null) {
            MemoryServerTrace.logError("MemoryRequestDescriptor.MemoryUpdateInfo == null for request " + req.toString(), "AdrsRegion.OnMemoryRequestCompleteHandler", this.targetInfo);
            this.setStatus(EnumSet.of(EnumMemoryRegionStatus.MEMORY_REQUEST_FAILED));
        } else {
            if (req.getMemoryUpdateInfo().isAborted()) {
                this.setStatus(EnumSet.of(EnumMemoryRegionStatus.MEMORY_REQUEST_FAILED));
            } else {
                this.setStatus(EnumSet.of(EnumMemoryRegionStatus.READY_FOR_USE));
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("TargetMemory: Status = " + this.getStatus() + ", reqID=" + req.getRequestIdStr() + ", req.MemoryUpdateInfo = " + req.getMemoryUpdateInfo().toString() + ", invoking the OnMemoryReadComplete function.", "AdrsRegion.OnMemoryReadCompleteHandler", this.targetInfo);
            }
            this.onMemoryReadCompleted(EventArgs.Empty);
        }
        this.targetAccessRequestDescriptor = null;
    }

    protected void onReleased(EventArgs e) {
        if (this.onRelease != null) {
            this.onRelease.raise(e);
        }
        this.factory.onRelease(this);
    }

    @Override
    public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor ccsCExprEvalRequestDescriptor) {
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "AdrsRegion.dispose", this.target.info);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                this.listOfDefraggedAdrsRegions.clear();
                if (this.dspMemoryObj != null && !this.dspMemoryObj.isDisposed()) {
                    this.dspMemoryObj.dispose();
                }
                this.dspMemoryObj = null;
                if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
                    this.dspMemory2Obj.dispose();
                }
                this.dspMemory2Obj = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public int get(List<IDspMemory.IMemoryValue> memValues, long index, long lengthInMaus, IDspValue type, IDspValue.Format format) {
        return this.dspMemory2Obj.getValues(memValues, type, format, (int)index);
    }

    public int getMemoryHitTypeCode(long index) {
        return this.dspMemory2Obj.getMemoryHitTypeCode(index);
    }

    public String getErrorString(long index) {
        if (this.dspMemory2Obj != null) {
            return this.dspMemory2Obj.getErrorString((int)index, false);
        }
        return "";
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

