/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.maps.AdrsMap;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheList
implements Iterable<AdrsMap> {
    private ArrayList<AdrsMap> cacheList = new ArrayList();
    private int currentIndex = -1;

    public AdrsMap get(int memoryLevelIndex) {
        if (memoryLevelIndex > this.cacheList.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.cacheList.get(memoryLevelIndex);
    }

    public int size() {
        return this.cacheList.size();
    }

    public void add(AdrsMap mapObj) {
        this.cacheList.add(mapObj);
    }

    public void remove(AdrsMap mapObj) {
        this.cacheList.remove(mapObj);
    }

    public AdrsMap getCache(int memoryHierarchyListIndex) {
        AdrsMap result = null;
        if (memoryHierarchyListIndex < this.cacheList.size()) {
            result = this.cacheList.get(memoryHierarchyListIndex);
        }
        return result;
    }

    public void clear() {
        for (AdrsMap cache : this.cacheList) {
            cache.clearMap();
        }
        this.cacheList.clear();
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public AdrsMap getCurrent() {
        AdrsMap result = null;
        if (this.cacheList.size() > this.currentIndex) {
            result = this.cacheList.get(this.currentIndex);
        }
        return result;
    }

    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.cacheList.size()) {
            result = true;
        }
        return result;
    }

    public AdrsMap next() {
        AdrsMap result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    @Override
    public Iterator<AdrsMap> iterator() {
        this.reset();
        return this.cacheList.iterator();
    }

    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.cacheList.size()) {
            this.cacheList.remove(this.currentIndex);
            if (this.currentIndex >= this.cacheList.size()) {
                this.currentIndex = this.cacheList.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

