/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryPageHandler;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryProtectionFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegionList;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.framework.IDisposable;
import java.util.EnumSet;

public class MemoryMapHandler
implements IDisposable {
    static String NO_PROTECTION = "RAM";
    private IDspUser dspUser = null;
    private IDspValue dspAdrs = null;
    private IDspValue dspLength = null;
    protected MemoryPageHandler owner = null;
    protected TargetDeviceInfo targetInfo;
    private short memoryPageNumber = 0;
    private volatile boolean disposed = false;

    public MemoryMapHandler(MemoryPageHandler owner, TargetDeviceInfo info) {
        this.owner = owner;
        if (owner != null) {
            this.memoryPageNumber = owner.getMemoryPageNumber();
        }
        this.targetInfo = info;
        this.initDspUser();
    }

    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    private void initDspUser() {
        block7: {
            try {
                this.dspUser = this.targetInfo.getOwner().getDspUser();
                if (this.dspUser != null) {
                    if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                        this.dspAdrs.dispose();
                    }
                    this.dspAdrs = this.dspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0);
                    if (this.dspAdrs.sizeOf() == 0) {
                        if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                            this.dspAdrs.dispose();
                        }
                        this.dspAdrs = this.dspUser.createDspValue(EnumDspValueType.DSP_POINTER.getInt(), 0);
                    }
                    if (this.dspLength != null && !this.dspLength.isDisposed()) {
                        this.dspLength.dispose();
                    }
                    this.dspLength = this.dspUser.createDspValue(EnumDspValueType.DSP_LONG.getInt(), 0);
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block7;
                MemoryServerTrace.logException("Exception in InitDspUser (memory page = " + Integer.toString(this.memoryPageNumber) + "): " + ex.getMessage(), "MemoryMapHandler.InitDspUser", ex, this.targetInfo);
            }
        }
    }

    public boolean isMemoryMapEnabled() {
        boolean result = false;
        if (this.dspUser != null) {
            result = this.dspUser.getMapOn();
        }
        return result;
    }

    public void EnableMemoryMap() {
        if (this.dspUser != null) {
            this.dspUser.enableMemoryMap(true);
        }
    }

    public void DisableMemoryMap() {
        if (this.dspUser != null) {
            this.dspUser.enableMemoryMap(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMemoryMaps(long startAdrs, MemoryMapRegionList regionList) {
        boolean status = true;
        long maxAdrs = Long.MAX_VALUE;
        if (this.dspUser == null || regionList == null || startAdrs < 0L) {
            return false;
        }
        regionList.clearMap();
        if (!this.dspUser.getMapOn()) {
            regionList.addRegion(startAdrs, maxAdrs, EnumSet.noneOf(EnumMemoryProtectionFlags.class), NO_PROTECTION);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Memory Maps are disabled - treating memory page " + Integer.toString(this.memoryPageNumber) + " as unprotected.", "MemoryMapHandler.getMemoryMaps", this.targetInfo);
            }
        } else {
            this.dspAdrs.assignLong((int)startAdrs);
            long regionStartAdrs = 0L;
            long regionEndAdrs = 0L;
            while (status) {
                try {
                    int nRegStop;
                    UInt63 uEndAdrs;
                    int nRegStart;
                    UInt63 uStartAdrs;
                    IDspUser.MemoryMapInfo memoryMapInfo = null;
                    memoryMapInfo = this.dspUser.findMemoryMapSection(this.dspAdrs, this.memoryPageNumber);
                    status = memoryMapInfo.getSuccess();
                    if (memoryMapInfo == null || !memoryMapInfo.getSuccess()) continue;
                    EnumSet<EnumMemoryProtectionFlags> memProtectionFlags = EnumSet.noneOf(EnumMemoryProtectionFlags.class);
                    if (!memoryMapInfo.getReadable()) {
                        memProtectionFlags.add(EnumMemoryProtectionFlags.READ_PROTECTED);
                    }
                    if (!memoryMapInfo.getWriteable()) {
                        memProtectionFlags.add(EnumMemoryProtectionFlags.WRITE_PROTECTED);
                    }
                    if ((regionStartAdrs = (uStartAdrs = new UInt63(nRegStart = memoryMapInfo.getStartAddress())).getValue()) > maxAdrs) {
                        regionStartAdrs = maxAdrs;
                    }
                    if ((regionEndAdrs = (uEndAdrs = new UInt63(nRegStop = memoryMapInfo.getEndAddress())).getValue()) >= maxAdrs) {
                        regionEndAdrs = maxAdrs;
                        status = false;
                    }
                    regionList.addRegion(regionStartAdrs, regionEndAdrs, memProtectionFlags, memoryMapInfo.getAttribute());
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Memory AdrsMap region created for memory page " + Integer.toString(this.memoryPageNumber) + ": " + "0x" + Long.toHexString(regionStartAdrs) + " - 0x" + Long.toHexString(regionEndAdrs) + " [" + memProtectionFlags.toString() + "]", "MemoryMapHandler.getMemoryMaps", this.targetInfo);
                    }
                    uEndAdrs.setValue(regionEndAdrs + 1L);
                    this.dspAdrs.assignLong((int)uEndAdrs.getValue());
                    uEndAdrs.setValue(this.dspAdrs.toLongLong());
                    if (uEndAdrs.getValue() >= regionEndAdrs) continue;
                    status = false;
                }
                catch (Exception exc) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logException(exc.getMessage(), "MemoryMapHandler.getMemoryMaps", exc, this.targetInfo);
                    }
                    status = false;
                }
            }
        }
        return true;
    }

    public boolean isAdrsReadable(long startAdrs, long endAdrs) {
        if (this.dspUser != null) {
            this.dspAdrs.assignLongLong(startAdrs);
            long length = endAdrs - startAdrs;
            this.dspLength.assignLongLong(length);
            return this.dspUser.getMemoryReadable(this.memoryPageNumber, this.dspAdrs, this.dspLength);
        }
        return true;
    }

    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                    this.dspAdrs.dispose();
                }
                this.dspAdrs = null;
                if (this.dspLength != null && !this.dspLength.isDisposed()) {
                    this.dspLength.dispose();
                }
                this.dspLength = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void acquire() {
    }
}

