/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryProtectionFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRegionStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryRegionReadCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestList;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import java.util.EnumSet;

public class MemoryMapRegion
implements IFactoryCreatedObject,
IMemoryRegion {
    private TargetDeviceInfo targetInfo = null;
    private long MinimumMemoryRegionBlockSizeInMaus = 256L;
    private boolean memoryMapsNeedToBeAlignedToLinesOfMemory = false;
    private EnumSet<EnumMemoryProtectionFlags> memoryProtectionFlags = EnumSet.noneOf(EnumMemoryProtectionFlags.class);
    private String memoryAttributeString = null;
    private short memoryPageNum;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private EnumSet<EnumMemoryRegionStatus> status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
    private long startAdrs = 0L;
    private long endAdrs;
    private int memoryLevelEnableFlags = 0;
    private RequestList originalClientRequestList = null;
    private MemoryRegionReadCompleteEvent onMemoryRegionReadComplete = null;
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;

    public MemoryMapRegion(TargetDeviceInfo targetDeviceInfo, MemoryMapHandler memoryMapHandler) {
        this.targetInfo = targetDeviceInfo;
        this.status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
        this.onMemoryRegionReadComplete = new MemoryRegionReadCompleteEvent(this);
        this.memoryProtectionFlags.clear();
    }

    public EnumSet<EnumMemoryProtectionFlags> getMemoryProtectionFlags() {
        return this.memoryProtectionFlags;
    }

    public void setMemoryProtectionFlags(EnumSet<EnumMemoryProtectionFlags> value) {
        this.memoryProtectionFlags.clear();
        this.memoryProtectionFlags.addAll(value);
    }

    public void setMemoryAttributeString(String attrString) {
        this.memoryAttributeString = attrString;
    }

    public String getAttributeString() {
        return this.memoryAttributeString;
    }

    @Override
    public short getMemoryPageNum() {
        return this.memoryPageNum;
    }

    @Override
    public void setMemoryPageNum(short value) {
        this.memoryPageNum = value;
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    @Override
    public EnumSet<EnumMemoryRegionStatus> getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EnumSet<EnumMemoryRegionStatus> value) {
        this.status.clear();
        this.status.addAll(value);
    }

    public long getStartAddressOfLineContainingAdrs(long adrs) {
        long lineLength = this.MinimumMemoryRegionBlockSizeInMaus;
        long mask = lineLength - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return UInt63.getFromSignedLong(adrs) & mask;
    }

    public long getEndAddressOfLineContainingAdrs(long adrs) {
        long lineLength = this.MinimumMemoryRegionBlockSizeInMaus;
        long mask = lineLength - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return (UInt63.getFromSignedLong(adrs) & mask) + (lineLength - 1L);
    }

    @Override
    public void release() {
        this.onMemoryRegionReadComplete.clearEventListeners();
        if (this.getFactory() != null) {
            this.getFactory().onRelease(this);
        }
    }

    @Override
    public void abortPendingRequests() {
    }

    public void config(long startAddress, long endAddress, short memoryPageNumber, EnumMemoryViews memoryView) {
        this.config(startAddress, endAddress, memoryPageNumber, memoryView, 0, 0);
    }

    @Override
    public void config(long startAddress, long endAddress, short memoryPageNumber, EnumMemoryViews memoryView, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long numMAUs = this.targetInfo.getNumMausInAddressRange(UInt63.getFromSignedLong(startAddress), UInt63.getFromSignedLong(endAddress), memoryPageNumber);
        this.config(startAddress, memoryPageNumber, memoryView, numMAUs, memoryHierarchyReadEnableFlags, memoryLevelEnableFlags);
    }

    @Override
    public void config(long startAddress, short memoryPageNumber, EnumMemoryViews memoryView, long numMAUs, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAddress = UInt63.getFromSignedLong(startAddress);
        if (this.memoryMapsNeedToBeAlignedToLinesOfMemory) {
            this.setStartAdrs(this.getStartAddressOfLineContainingAdrs(uStartAddress));
            this.setEndAdrs(this.targetInfo.getEndAdrsInRange(uStartAddress, numMAUs, memoryPageNumber));
            this.setEndAdrs(this.getEndAddressOfLineContainingAdrs(this.endAdrs));
        } else {
            this.setStartAdrs(uStartAddress);
            this.setEndAdrs(this.targetInfo.getEndAdrsInRange(uStartAddress, numMAUs, memoryPageNumber));
        }
        this.memoryPageNum = memoryPageNumber;
        this.memoryView = memoryView;
        this.memoryProtectionFlags.clear();
        this.memoryLevelEnableFlags = memoryLevelEnableFlags;
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.READY_FOR_USE));
    }

    public void config(IMemoryRegion regionToCopy) {
        this.setStartAdrs(regionToCopy.getStartAdrs());
        this.setEndAdrs(regionToCopy.getEndAdrs());
        this.setMemoryPageNum(regionToCopy.getMemoryPageNum());
        this.memoryProtectionFlags.clear();
        if (regionToCopy instanceof MemoryMapRegion) {
            this.setMemoryProtectionFlags(((MemoryMapRegion)regionToCopy).getMemoryProtectionFlags());
        }
        this.memoryView = regionToCopy.getMemoryView();
        this.memoryLevelEnableFlags = regionToCopy.getMemoryLevelEnableFlags();
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.READY_FOR_USE));
    }

    @Override
    public void setStartAdrs(long value) {
        long uStartAdrs = UInt63.getFromSignedLong(value);
        this.startAdrs = this.memoryMapsNeedToBeAlignedToLinesOfMemory ? this.getStartAddressOfLineContainingAdrs(uStartAdrs) : uStartAdrs;
        if (this.endAdrs < this.startAdrs) {
            this.endAdrs = this.startAdrs;
        }
    }

    @Override
    public long getStartAdrs() {
        return this.startAdrs;
    }

    @Override
    public void setEndAdrs(long value) {
        long uEndAdrs = UInt63.getFromSignedLong(value);
        this.endAdrs = this.memoryMapsNeedToBeAlignedToLinesOfMemory ? this.getEndAddressOfLineContainingAdrs(uEndAdrs) : uEndAdrs;
        if (this.startAdrs > this.endAdrs) {
            this.startAdrs = this.endAdrs;
        }
    }

    @Override
    public long getEndAdrs() {
        return this.endAdrs;
    }

    @Override
    public long getLengthInMAUs() {
        return this.targetInfo.getNumMausInAddressRange(this.startAdrs, this.endAdrs, this.memoryPageNum);
    }

    @Override
    public void setLengthInMAUs(long value) {
        this.endAdrs = this.targetInfo.getEndAdrsInRange(this.startAdrs, value, this.memoryPageNum);
    }

    @Override
    public int getMemoryLevelEnableFlags() {
        return this.memoryLevelEnableFlags;
    }

    @Override
    public void setMemoryLevelEnableFlags(int value) {
        this.memoryLevelEnableFlags = value;
    }

    @Override
    public boolean getPreceedingAdrs(long minAdrs, long[] preceedingAdrs) {
        boolean retval = true;
        preceedingAdrs[0] = this.startAdrs;
        if (this.startAdrs > UInt63.getFromSignedLong(minAdrs)) {
            preceedingAdrs[0] = preceedingAdrs[0] - 1L;
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean getFollowingAdrs(long maxAdrs, long[] followingAdrs) {
        boolean retval = true;
        long uMaxAdrs = UInt63.getFromSignedLong(maxAdrs);
        followingAdrs[0] = this.endAdrs;
        if (this.startAdrs < uMaxAdrs) {
            followingAdrs[0] = this.targetInfo.getNextAdrs(followingAdrs[0], 1, this.memoryPageNum);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean isAdrsInRegion(long adrs) {
        long uAdrs = UInt63.getFromSignedLong(adrs);
        return uAdrs >= this.getStartAdrs() && uAdrs <= this.getEndAdrs();
    }

    @Override
    public RequestList getOriginalClientRequestList() {
        return this.originalClientRequestList;
    }

    @Override
    public MemoryRegionReadCompleteEvent getOnMemoryRegionReadCompleteEvent() {
        return this.onMemoryRegionReadComplete;
    }

    @Override
    public void requestInfoFromTarget() {
        if (this.onMemoryRegionReadComplete != null) {
            this.onMemoryRegionReadComplete.raise(EventArgs.Empty);
        }
    }

    @Override
    public int compareTo(IMemoryRegion adrsRegion) {
        int retval = 0;
        if (this.getStartAdrs() > adrsRegion.getStartAdrs()) {
            retval = 1;
        } else if (this.getStartAdrs() < adrsRegion.getStartAdrs()) {
            retval = -1;
        }
        return retval;
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "MemoryMapRegion.dispose", this.targetInfo);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (this.disposed || disposing) {
            // empty if block
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

