/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryProtectionFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsMap;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapHandler;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapRegion;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;

public class MemoryMapRegionList
extends AdrsMap {
    private MemoryMapHandler memoryMapHdlr = null;

    public MemoryMapRegionList(ITargetDeviceInfo targetInfo, short memoryPageNumber, String name, MemoryTypeDescriptor memType, IRecyclingFactory memoryAttributeClassFactoryObj, MemoryMapHandler memoryMapHdlr) {
        super(targetInfo, memoryPageNumber, name, memType, memoryAttributeClassFactoryObj);
        this.memoryMapHdlr = memoryMapHdlr;
        this.init();
    }

    public void init() {
        if (this.memoryMapHdlr != null) {
            this.memoryMapHdlr.getMemoryMaps(0L, this);
        }
    }

    public void addRegion(long startAdrs, long endAdrs, EnumSet<EnumMemoryProtectionFlags> memProtectionFlags) {
        this.addRegion(startAdrs, endAdrs, memProtectionFlags, null);
    }

    public void addRegion(long startAdrs, long endAdrs, EnumSet<EnumMemoryProtectionFlags> memProtectionFlags, String memMapAttributeString) {
        MemoryMapRegion mpRegion = (MemoryMapRegion)this.classFactory.createInstance();
        mpRegion.config(startAdrs, endAdrs, this.memoryPageNum, EnumMemoryViews.CPU_MEMORY_VIEW);
        mpRegion.setMemoryProtectionFlags(memProtectionFlags);
        mpRegion.setMemoryAttributeString(memMapAttributeString);
        this.adrsRegionList.add(mpRegion);
        Collections.sort(this.adrsRegionList);
    }

    public boolean isAdrsRangeEmulatable(long startAdrs, long endAdrs) {
        ArrayList<IMemoryRegion> listOfReadableRegions = new ArrayList<IMemoryRegion>();
        this.getListOfRegionsInAddressRange(startAdrs, endAdrs, listOfReadableRegions);
        boolean result = true;
        for (IMemoryRegion region : listOfReadableRegions) {
            if (!((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.EMULATION_ACCESS_DISABLED)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean isAdrsRangeReadable(long startAdrs, long endAdrs) {
        ArrayList<IMemoryRegion> listOfReadableRegions = new ArrayList<IMemoryRegion>();
        this.getListOfRegionsInAddressRange(startAdrs, endAdrs, listOfReadableRegions);
        boolean result = true;
        for (IMemoryRegion region : listOfReadableRegions) {
            if (!((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.READ_PROTECTED) && !((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.EMULATION_ACCESS_DISABLED)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean isAdrsRangeWriteable(long startAdrs, long endAdrs) {
        ArrayList<IMemoryRegion> listOfReadableRegions = new ArrayList<IMemoryRegion>();
        this.getListOfRegionsInAddressRange(startAdrs, endAdrs, listOfReadableRegions);
        boolean result = true;
        for (IMemoryRegion region : listOfReadableRegions) {
            if (!((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.WRITE_PROTECTED) && !((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.EMULATION_ACCESS_DISABLED)) continue;
            result = false;
            break;
        }
        return result;
    }

    public void getListOfReadableRegions(long startAdrs, long endAdrs, ArrayList<IMemoryRegion> list) {
        this.getListOfAttributeQualifiedRegions(startAdrs, endAdrs, EnumSet.of(EnumMemoryProtectionFlags.READ_PROTECTED), EnumSet.noneOf(EnumMemoryProtectionFlags.class), list);
    }

    public void getListOfWriteableRegions(long startAdrs, long endAdrs, ArrayList<IMemoryRegion> list) {
        this.getListOfAttributeQualifiedRegions(startAdrs, endAdrs, EnumSet.of(EnumMemoryProtectionFlags.WRITE_PROTECTED), EnumSet.noneOf(EnumMemoryProtectionFlags.class), list);
    }

    public void getListOfAttributeQualifiedRegions(long startAdrs, long endAdrs, EnumSet<EnumMemoryProtectionFlags> memProtectionFlagsBitfieldMask, EnumSet<EnumMemoryProtectionFlags> memProtectionFlagsToSearchFor, ArrayList<IMemoryRegion> list) {
        list.clear();
        ArrayList<IMemoryRegion> memRegions = new ArrayList<IMemoryRegion>();
        long numMAUs = this.targetDeviceInfo.getNumMausInAddressRange(startAdrs, endAdrs, this.memoryPageNum);
        if (numMAUs < 0L && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("NumMAUs = " + Long.toString(numMAUs) + " ( less than zero!)", "MemoryMapRegionList.getListOfAttributeQualifiedRegions", this.targetDeviceInfo);
        }
        this.getListOfRegionsInAddressRange(startAdrs, numMAUs, memRegions);
        boolean allFlagsMatch = true;
        for (IMemoryRegion region : memRegions) {
            for (EnumMemoryProtectionFlags flag : memProtectionFlagsBitfieldMask) {
                if (((MemoryMapRegion)region).getMemoryProtectionFlags().contains((Object)flag) == memProtectionFlagsToSearchFor.contains((Object)flag)) continue;
                allFlagsMatch = false;
                break;
            }
            if (allFlagsMatch) {
                list.add((MemoryMapRegion)region);
            }
            allFlagsMatch = true;
        }
    }

    public void attachTestableMemoryMapHdlr(MemoryMapHandler hdlr, IRecyclingFactory memoryAttributeClassFactoryObj) {
        this.memoryMapHdlr = hdlr;
        if (memoryAttributeClassFactoryObj != null) {
            this.classFactory = memoryAttributeClassFactoryObj;
        }
        this.init();
    }
}

