/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.maps;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryProtectionFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRegionStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryRegionReadCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.maps.MemoryMapHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestList;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import java.util.EnumSet;

public class MemoryProtectionRegion
implements IFactoryCreatedObject,
IMemoryRegion {
    private ITargetDeviceInfo targetInfo = null;
    private EnumSet<EnumMemoryProtectionFlags> memoryProtectionFlags = EnumSet.noneOf(EnumMemoryProtectionFlags.class);
    private short memoryPageNum;
    private EnumSet<EnumMemoryRegionStatus> status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
    private boolean memoryMapsNeedToBeAlignedToLinesOfMemory = true;
    private long startAdrs = 0L;
    private long endAdrs;
    private int memoryLevelEnableFlags = 0;
    private RequestList originalClientRequestList = null;
    private MemoryRegionReadCompleteEvent onMemoryRegionReadComplete = null;
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private volatile boolean disposed = false;

    public MemoryProtectionRegion(ITargetDeviceInfo targetDeviceInfo, MemoryMapHandler memoryMapHandler) {
        this.targetInfo = targetDeviceInfo;
        this.status = EnumSet.of(EnumMemoryRegionStatus.UNINITIALIZED);
        this.onMemoryRegionReadComplete = new MemoryRegionReadCompleteEvent(this);
    }

    public EnumSet<EnumMemoryProtectionFlags> getMemoryProtectionFlags() {
        return this.memoryProtectionFlags;
    }

    public void setMemoryProtectionFlags(EnumSet<EnumMemoryProtectionFlags> value) {
        this.memoryProtectionFlags.clear();
        this.memoryProtectionFlags.addAll(value);
    }

    @Override
    public short getMemoryPageNum() {
        return this.memoryPageNum;
    }

    @Override
    public void setMemoryPageNum(short value) {
        this.memoryPageNum = value;
    }

    @Override
    public EnumSet<EnumMemoryRegionStatus> getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EnumSet<EnumMemoryRegionStatus> value) {
        this.status.clear();
        this.status.addAll(value);
    }

    public boolean isWriteable() {
        boolean result = true;
        result = !this.getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.WRITE_PROTECTED);
        return result;
    }

    public boolean isReadable() {
        boolean result = true;
        result = !this.getMemoryProtectionFlags().contains((Object)EnumMemoryProtectionFlags.READ_PROTECTED);
        return result;
    }

    public boolean isAccessible() {
        boolean result = true;
        if (!this.isReadable() && !this.isWriteable()) {
            result = false;
        }
        return result;
    }

    public long getMinimumMemoryRegionBlockSizeInMaus() {
        long result = 1L;
        if (this.targetInfo != null) {
            result = this.targetInfo.getMinNumMausPerMemoryRead();
        }
        return result;
    }

    public long getStartAddressOfLineContainingAdrs(long adrs) {
        long lineLength = this.getMinimumMemoryRegionBlockSizeInMaus();
        long mask = lineLength - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return UInt63.getFromSignedLong(adrs) & mask;
    }

    public long getEndAddressOfLineContainingAdrs(long adrs) {
        long lineLength = this.getMinimumMemoryRegionBlockSizeInMaus();
        long mask = lineLength - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return (UInt63.getFromSignedLong(adrs) & mask) + (lineLength - 1L);
    }

    @Override
    public void release() {
        this.onMemoryRegionReadComplete.clearEventListeners();
        this.factory.onRelease(this);
    }

    public void config(long startAddress, long endAddress, short memoryPageNumber) {
        this.config(startAddress, endAddress, memoryPageNumber, this.memoryView, 0, 0);
    }

    @Override
    public void config(long startAddress, long endAddress, short memoryPageNumber, EnumMemoryViews memoryView, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAddress = UInt63.getFromSignedLong(startAddress);
        long uEndAddress = UInt63.getFromSignedLong(endAddress);
        long numMAUs = this.targetInfo.getNumMausInAddressRange(uStartAddress, uEndAddress, memoryPageNumber);
        this.config(uStartAddress, memoryPageNumber, memoryView, numMAUs, memoryHierarchyReadEnableFlags, memoryLevelEnableFlags);
    }

    @Override
    public void config(long startAddress, short memoryPageNumber, EnumMemoryViews memoryView, long numMAUs, int memoryHierarchyReadEnableFlags, int memoryLevelEnableFlags) {
        long uStartAddress = UInt63.getFromSignedLong(startAddress);
        this.memoryView = memoryView;
        if (this.memoryMapsNeedToBeAlignedToLinesOfMemory) {
            this.setStartAdrs(this.getStartAddressOfLineContainingAdrs(uStartAddress));
            this.endAdrs = this.targetInfo.getEndAdrsInRange(uStartAddress, numMAUs, memoryPageNumber);
            this.endAdrs = this.getEndAddressOfLineContainingAdrs(this.endAdrs);
        } else {
            this.setStartAdrs(uStartAddress);
            this.setEndAdrs(this.targetInfo.getEndAdrsInRange(uStartAddress, numMAUs, memoryPageNumber));
        }
        this.memoryPageNum = memoryPageNumber;
        this.memoryLevelEnableFlags = memoryLevelEnableFlags;
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.READY_FOR_USE));
    }

    public void config(IMemoryRegion regionToCopy) {
        this.setStartAdrs(regionToCopy.getStartAdrs());
        this.setEndAdrs(regionToCopy.getEndAdrs());
        this.setMemoryPageNum(regionToCopy.getMemoryPageNum());
        this.memoryLevelEnableFlags = regionToCopy.getMemoryLevelEnableFlags();
        this.setStatus(EnumSet.of(EnumMemoryRegionStatus.CONFIGURED, EnumMemoryRegionStatus.READY_FOR_USE));
    }

    @Override
    public long getStartAdrs() {
        return this.startAdrs;
    }

    @Override
    public void setStartAdrs(long value) {
        this.startAdrs = this.memoryMapsNeedToBeAlignedToLinesOfMemory ? this.getStartAddressOfLineContainingAdrs(value) : UInt63.getFromSignedLong(value);
        if (this.endAdrs < this.startAdrs) {
            this.endAdrs = this.startAdrs;
        }
    }

    @Override
    public long getEndAdrs() {
        return this.endAdrs;
    }

    @Override
    public void setEndAdrs(long value) {
        this.endAdrs = this.memoryMapsNeedToBeAlignedToLinesOfMemory ? this.getEndAddressOfLineContainingAdrs(value) : UInt63.getFromSignedLong(value);
        if (this.startAdrs > this.endAdrs) {
            this.startAdrs = this.endAdrs;
        }
    }

    @Override
    public long getLengthInMAUs() {
        return this.targetInfo.getNumMausInAddressRange(this.startAdrs, this.endAdrs, this.memoryPageNum);
    }

    @Override
    public void setLengthInMAUs(long value) {
        this.endAdrs = this.targetInfo.getEndAdrsInRange(this.startAdrs, value, this.memoryPageNum);
    }

    @Override
    public int getMemoryLevelEnableFlags() {
        return this.memoryLevelEnableFlags;
    }

    @Override
    public void setMemoryLevelEnableFlags(int value) {
        this.memoryLevelEnableFlags = value;
    }

    @Override
    public boolean getPreceedingAdrs(long minAdrs, long[] preceedingAdrs) {
        boolean retval = true;
        preceedingAdrs[0] = this.startAdrs;
        if (this.startAdrs > UInt63.getFromSignedLong(minAdrs)) {
            preceedingAdrs[0] = preceedingAdrs[0] - 1L;
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean getFollowingAdrs(long maxAdrs, long[] followingAdrs) {
        boolean retval = true;
        followingAdrs[0] = this.endAdrs;
        if (this.startAdrs < UInt63.getFromSignedLong(maxAdrs)) {
            followingAdrs[0] = this.targetInfo.getNextAdrs(followingAdrs[0], 1, this.memoryPageNum);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean isAdrsInRegion(long adrs) {
        long uAdrs = UInt63.getFromSignedLong(adrs);
        return uAdrs >= this.getStartAdrs() && uAdrs <= this.getEndAdrs();
    }

    @Override
    public RequestList getOriginalClientRequestList() {
        return this.originalClientRequestList;
    }

    @Override
    public MemoryRegionReadCompleteEvent getOnMemoryRegionReadCompleteEvent() {
        return this.onMemoryRegionReadComplete;
    }

    public void RequestInfoFromTarget() {
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void abortPendingRequests() {
    }

    @Override
    public void requestInfoFromTarget() {
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    @Override
    public int compareTo(IMemoryRegion adrsRegion) {
        int retval = 0;
        if (this.startAdrs > adrsRegion.getStartAdrs()) {
            retval = 1;
        } else if (this.startAdrs < adrsRegion.getStartAdrs()) {
            retval = -1;
        }
        return retval;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "MemoryProtectionRegion.dispose", this.targetInfo);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (this.disposed || disposing) {
            // empty if block
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

