/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryhierarchy;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.AddressMappedAttributeDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import java.util.ArrayList;

public class AddressMappedAttributeHandler {
    private MemoryTypeDescriptor owner = null;
    private String nameOfAttribute = "";
    private String description = "";
    private long pageSizeInMAUs = 1024L;
    private String registerName = "";
    private RegisterHandler registerHdlr = null;
    private long globalAddressMask = 0L;
    private RegisterHandler regHdlrGlobalAdrsSpaceId = null;
    private RegisterDecoder regDecoderGlobalAdrsSpaceId = null;
    private ArrayList<AddressMappedAttributeDescriptor> listOfAttributes = null;

    public AddressMappedAttributeHandler(MemoryTypeDescriptor owner, String strPropertyCategoryName, String strXPathQueryRoot, XmlElement attrNode, RegisterList listOfRegHandlers) {
        XmlHelper xmlHelper = new XmlHelper();
        this.owner = owner;
        this.nameOfAttribute = xmlHelper.getString(attrNode, "Name", "", 0);
        this.description = xmlHelper.getString(attrNode, "Description", "", 0);
        this.registerName = xmlHelper.getString(attrNode, "ConfigReg", "", 0);
        this.registerHdlr = listOfRegHandlers.getRegisterHandler(this.registerName);
        this.listOfAttributes = new ArrayList();
        if (this.registerHdlr != null) {
            this.pageSizeInMAUs = xmlHelper.getLong(attrNode, "PageSizeInMAUs", 1024L, 0);
            this.globalAddressMask = xmlHelper.getLong(attrNode, "GlobalAddressMask", 0L, 0);
            String globalAdrsSpaceIdRegisterName = xmlHelper.getString(attrNode, "GlobalAddressSpaceIdBits/ConfigReg", "", 0);
            String globalAdrsSpaceIdDecoderName = xmlHelper.getString(attrNode, "GlobalAddressSpaceIdBits/DecoderName", "", 0);
            if (globalAdrsSpaceIdRegisterName.length() > 0 && globalAdrsSpaceIdDecoderName.length() > 0) {
                this.regHdlrGlobalAdrsSpaceId = listOfRegHandlers.getRegisterHandler(globalAdrsSpaceIdRegisterName);
                this.regDecoderGlobalAdrsSpaceId = this.regHdlrGlobalAdrsSpaceId.getDecoder(globalAdrsSpaceIdDecoderName);
            }
            int numFlags = xmlHelper.getInt(attrNode, "NumFlags", 0, 0);
            AddressMappedAttributeDescriptor attrDesc = null;
            if (numFlags > 0) {
                for (int flagNum = 0; flagNum < numFlags; ++flagNum) {
                    MyXPathNodeIterator attrNodeIterator = attrNode.select("Flag[@index='" + Integer.toString(flagNum) + "']", true);
                    if (attrNodeIterator == null) continue;
                    XmlElement attrFlagNode = attrNodeIterator.get(0);
                    attrDesc = new AddressMappedAttributeDescriptor((Object)this, attrFlagNode, this.registerHdlr);
                    this.listOfAttributes.add(attrDesc);
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo(this.toString(), "AddressMappedAttributeHandler constructor", null);
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
            MemoryServerTrace.logWarning("Did not find valid config register in xml path " + strXPathQueryRoot + " for memory type " + owner.getName(), "AddressMappedAttributeHandler constructor", null);
        }
    }

    public AddressMappedAttributeHandler(MemoryTypeDescriptor owner, String strPropertyCategoryName, String strXPathQueryRoot, DeviceXMLReader.AddressMappedAttributeInfo attrNode, RegisterList listOfRegHandlers) {
        this.owner = owner;
        this.nameOfAttribute = attrNode.name;
        this.description = attrNode.description;
        this.registerName = attrNode.registerName;
        this.registerHdlr = listOfRegHandlers.getRegisterHandler(this.registerName);
        this.listOfAttributes = new ArrayList();
        if (this.registerHdlr != null) {
            this.pageSizeInMAUs = attrNode.pageSizeInMAUs;
            this.globalAddressMask = attrNode.globalAddressMask;
            String globalAdrsSpaceIdRegisterName = attrNode.globalAdrsSpaceIdRegisterName;
            String globalAdrsSpaceIdDecoderName = attrNode.globalAdrsSpaceIdDecoderName;
            if (globalAdrsSpaceIdRegisterName.length() > 0 && globalAdrsSpaceIdDecoderName.length() > 0) {
                this.regHdlrGlobalAdrsSpaceId = listOfRegHandlers.getRegisterHandler(globalAdrsSpaceIdRegisterName);
                this.regDecoderGlobalAdrsSpaceId = this.regHdlrGlobalAdrsSpaceId.getDecoder(globalAdrsSpaceIdDecoderName);
            }
            int numFlags = attrNode.numFlags;
            AddressMappedAttributeDescriptor attrDesc = null;
            if (numFlags > 0) {
                for (int flagNum = 0; flagNum < numFlags; ++flagNum) {
                    DeviceXMLReader.AddressMappedAttributeDescriptorInfo descInfo = attrNode.attrDescList.get(flagNum);
                    if (descInfo == null) continue;
                    attrDesc = new AddressMappedAttributeDescriptor((Object)this, descInfo, this.registerHdlr);
                    this.listOfAttributes.add(attrDesc);
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo(this.toString(), "AddressMappedAttributeHandler constructor", null);
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
            MemoryServerTrace.logWarning("Did not find valid config register in xml path " + strXPathQueryRoot + " for memory type " + owner.getName(), "AddressMappedAttributeHandler constructor", null);
        }
    }

    public MemoryTypeDescriptor getOwner() {
        return this.owner;
    }

    public void setOwner(MemoryTypeDescriptor value) {
        this.owner = value;
    }

    public String getNameOfAttribute() {
        return this.nameOfAttribute;
    }

    public void setNameOfAttribute(String value) {
        this.nameOfAttribute = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public long getPageSizeInMAUs() {
        return this.pageSizeInMAUs;
    }

    public void setPageSizeInMAUs(long value) {
        this.pageSizeInMAUs = value;
    }

    public String getRegisterName() {
        return this.registerName;
    }

    public void setRegisterName(String value) {
        this.registerName = value;
    }

    public RegisterHandler getRegisterHdlr() {
        return this.registerHdlr;
    }

    public void setRegisterHandler(RegisterHandler value) {
        this.registerHdlr = value;
    }

    public long getGlobalAddressMask() {
        return this.globalAddressMask;
    }

    public void setGlobalAddressMask(long value) {
        this.globalAddressMask = value;
    }

    public long getGlobalAddressSpaceIds() {
        long result = 0L;
        if (this.regDecoderGlobalAdrsSpaceId != null) {
            result = this.regDecoderGlobalAdrsSpaceId.decode();
        }
        return result;
    }

    public ArrayList<AddressMappedAttributeDescriptor> getListOfAttributes() {
        return this.listOfAttributes;
    }

    public boolean isAdrsInScope(long adrs) {
        boolean result = false;
        long extendedAdrsBits = adrs & this.globalAddressMask;
        if (extendedAdrsBits == 0L || extendedAdrsBits == this.getGlobalAddressSpaceIds()) {
            result = this.owner.isAdrsInThisMemoryType(adrs);
        }
        return result;
    }

    public boolean getRegisterValueForAdrs(long adrs, long[] regValue) {
        boolean result = false;
        int foundIndex = 0;
        regValue[0] = 0L;
        if (this.isAdrsInScope(adrs)) {
            long baseAdrs;
            long localAdrs = adrs & (this.getGlobalAddressMask() ^ 0xFFFFFFFFFFFFFFFFL);
            long workingAdrs = baseAdrs = this.owner.getStartAddress();
            int regIndex = 0;
            while ((long)regIndex < this.getRegisterHdlr().getNumRegistersInSet()) {
                if (localAdrs >= workingAdrs && localAdrs < workingAdrs + this.getPageSizeInMAUs()) {
                    result = true;
                    foundIndex = regIndex;
                    regValue[0] = this.getRegisterHdlr().getContextSaveValues().get(regIndex);
                    break;
                }
                workingAdrs += this.getPageSizeInMAUs();
                ++regIndex;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && MemoryServerTrace.verboseTraceMinAdrs <= adrs && MemoryServerTrace.verboseTraceMaxAdrs >= adrs && result) {
                MemoryServerTrace.logVerbose("Register Name: " + this.registerHdlr.getName() + ", index = " + foundIndex + ", regValue = 0x" + Long.toHexString(regValue[0]) + " for adrs 0x" + Long.toHexString(adrs), "AddressMappedAttributeHandler.GetRegisterValueForAdrs", null);
            }
        }
        return result;
    }

    public String getSummaryText(long adrs) {
        String result;
        block11: {
            result = "";
            long decoderResult = 0L;
            String strDecoderResult = "";
            boolean commaFlag = false;
            long[] regValue = new long[]{0L};
            try {
                boolean ok = this.getRegisterValueForAdrs(adrs, regValue);
                if (ok && this.listOfAttributes != null) {
                    for (AddressMappedAttributeDescriptor desc : this.listOfAttributes) {
                        if (desc == null || desc.getDecoder() == null) continue;
                        RegisterDecoder decoder = desc.getDecoder();
                        if (desc.isDisplayBinaryData()) {
                            if (commaFlag) {
                                result = result + ", ";
                            }
                            result = result + desc.getPropertyName() + "=" + decoder.decode_Binary(regValue[0]);
                            commaFlag = true;
                            continue;
                        }
                        if (decoder.isAStringTable) {
                            strDecoderResult = decoder.decode_String(regValue[0]);
                            if (commaFlag) {
                                result = result + ", ";
                            }
                            result = result + desc.getPropertyName() + "=" + strDecoderResult;
                            commaFlag = true;
                            continue;
                        }
                        decoderResult = decoder.decode(regValue[0]);
                        String tempStr = "";
                        if (decoderResult != 0L) {
                            tempStr = desc.getPropertyName();
                        }
                        if (tempStr.length() <= 0) continue;
                        if (commaFlag) {
                            tempStr = ", " + tempStr;
                        }
                        result = result + tempStr;
                        commaFlag = true;
                    }
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && MemoryServerTrace.verboseTraceMinAdrs <= adrs && MemoryServerTrace.verboseTraceMaxAdrs >= adrs) {
                        MemoryServerTrace.logVerbose("Attr Name: " + this.getNameOfAttribute() + ", summary text = " + result, "AddressMappedAttributeHandler.GetSummaryText", null);
                    }
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block11;
                MemoryServerTrace.logException("Exception while getting summary for adrs 0x" + Long.toHexString(adrs), "AddressMappedAttributeHandler.getSummaryText", ex, null);
            }
        }
        return result;
    }

    public String toString() {
        String result = "AddressMappedAttributeHandler " + this.getNameOfAttribute() + ": ConfigReg = " + this.registerName + "[";
        for (AddressMappedAttributeDescriptor desc : this.listOfAttributes) {
            result = result + desc.getPropertyName() + " ";
        }
        result = result + "]";
        return result;
    }
}

