/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryhierarchy;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryCapabilityFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IMemoryLevelAttributes;
import com.ti.debug.engine.IMemoryLevelInfo;
import java.util.EnumSet;

public class MemLevelInfoBit
implements IDisposable {
    private boolean isARM = false;
    private IMemoryLevelInfo info = null;
    private IMemoryLevelAttributes levelAttributes = null;
    private short bitPosition = 0;
    private EnumMemoryLevelIndex memoryLevelIndex = EnumMemoryLevelIndex.NONE;
    private volatile boolean isDisposed = false;

    public MemLevelInfoBit(boolean isARM, IDspMemory2 dspMemory2Obj, short bitPosition) {
        this.info = dspMemory2Obj.getMemoryLevelInfo((int)bitPosition);
        this.bitPosition = bitPosition;
        this.isARM = isARM;
    }

    public boolean isARM() {
        return this.isARM();
    }

    public IMemoryLevelInfo getInfo() {
        return this.info;
    }

    public int getMemAccessIdParamBits() {
        int result = 1 << this.bitPosition;
        return result;
    }

    public IMemoryLevelAttributes getLevelAttributes() {
        IMemoryLevelAttributes result = null;
        if (this.info != null && this.levelAttributes == null) {
            this.levelAttributes = this.info.getLevelAttributes();
            int memLevel = this.getMemLevel();
            boolean isProgram = this.getIsProgram();
            boolean isData = this.getIsData();
            boolean isShared = this.getIsShared();
            boolean isExternal = this.getIsExternal();
            if (isExternal) {
                this.memoryLevelIndex = EnumMemoryLevelIndex.EXTERNAL;
            } else {
                switch (memLevel) {
                    case 1: {
                        if (isProgram && isData) {
                            this.memoryLevelIndex = EnumMemoryLevelIndex.L1;
                            break;
                        }
                        if (isProgram) {
                            this.memoryLevelIndex = EnumMemoryLevelIndex.L1P;
                            break;
                        }
                        this.memoryLevelIndex = EnumMemoryLevelIndex.L1D;
                        break;
                    }
                    case 2: {
                        if (isShared) {
                            this.memoryLevelIndex = EnumMemoryLevelIndex.L2_SHARED;
                            break;
                        }
                        this.memoryLevelIndex = EnumMemoryLevelIndex.L2;
                        break;
                    }
                    case 3: {
                        if (isShared) {
                            this.memoryLevelIndex = EnumMemoryLevelIndex.L3_SHARED;
                            break;
                        }
                        this.memoryLevelIndex = EnumMemoryLevelIndex.L3;
                        break;
                    }
                    default: {
                        this.memoryLevelIndex = EnumMemoryLevelIndex.EXTERNAL;
                    }
                }
            }
        }
        if ((result = this.levelAttributes) == null) {
            MemoryServerTrace.logError("info.getLevelAttributes = null", "MemLevelInfoBit.getLevelAttributes", null);
        }
        return result;
    }

    public String getMemTypeName() {
        String result = "";
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean hasLevelAttributes() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_MEM_LEVEL) {
            result = this.getLevelAttributes() != null;
        }
        return result;
    }

    public IMemoryLevelInfo.MEM_ACCESS_TYPE getBitType() {
        IMemoryLevelInfo.MEM_ACCESS_TYPE result = IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_RESERVED;
        if (this.info != null) {
            result = this.info.getBitType();
        }
        return result;
    }

    public boolean isMemoryLevelAccessBit() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_MEM_LEVEL) {
            result = true;
        }
        return result;
    }

    public short getBitPosition() {
        return this.bitPosition;
    }

    public boolean bitExists() {
        boolean result = false;
        if (this.info != null) {
            result = true;
        }
        return result;
    }

    public EnumMemoryLevelIndex getMemoryLevelIndex() {
        return this.memoryLevelIndex;
    }

    public int getMemLevel() {
        int result = 1;
        if (this.bitExists() && this.hasLevelAttributes()) {
            result = (int)this.getLevelAttributes().getMemLevel();
        }
        if (result < 1) {
            result = -1;
        }
        return result;
    }

    public String getMemLevelName() {
        String result = this.getMemoryLevelIndex().toString();
        return result;
    }

    public boolean getIsMmuBypass() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_OP_MMU_CURRENT) {
            result = true;
        }
        return result;
    }

    public boolean getIsStage2MmuBypass() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_OP_MMU_STAGE2_CURRENT) {
            result = true;
        }
        return result;
    }

    public EnumSet<EnumMemoryCapabilityFlags> getMemLevelCapabilityFlags() {
        EnumSet<EnumMemoryCapabilityFlags> result = EnumSet.noneOf(EnumMemoryCapabilityFlags.class);
        if (this.bitExists() && this.getIsMemLevelBypassable() && !this.isARM) {
            result.add(EnumMemoryCapabilityFlags.CAN_BE_BYPASSED);
        }
        return result;
    }

    public boolean getIsEnsureCoherent() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_OP_COHERENT) {
            result = true;
        }
        return result;
    }

    public boolean getIsEnsureRationalEndstate() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_OP_ENDSTATE_RATIONAL) {
            result = true;
        }
        return result;
    }

    public boolean getIsCache() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            result = this.getLevelAttributes().getIsCache();
        }
        return result;
    }

    public boolean getIsProgram() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsProgram();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsData() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsIO() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsIO();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsExternal() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsExternal();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsShared() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsShared();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsMemLevelBypassable() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_MEM_LEVEL && this.hasLevelAttributes()) {
            result = this.getLevelAttributes().getIsBypassable();
        }
        return result;
    }

    public boolean getIsPaged() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsPaged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsDefaultPage() {
        boolean result = false;
        if (this.getIsData()) {
            result = true;
        }
        return result;
    }

    public int getCacheLineSize() {
        int result = 0;
        if (this.hasLevelAttributes()) {
            try {
                int shift = (int)this.getLevelAttributes().getCacheLineSize();
                result = 1 << shift;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsSimulatedDatalessCache() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getIsSimulatedDatalessCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getCanBeProtected() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getCanBeProtected();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getCanBeSecured() {
        boolean result = false;
        if (this.hasLevelAttributes()) {
            try {
                result = this.getLevelAttributes().getCanBeSecured();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getIsQueryBit() {
        boolean result = false;
        if (this.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_QUERY) {
            result = true;
        }
        return result;
    }

    public boolean isSetByDefaultForAllAccesses() {
        boolean result = false;
        return result;
    }

    public boolean isSetByDefaultForPhysicalMemoryAccesses() {
        boolean result = false;
        if (this.getIsEnsureCoherent()) {
            result = this.isARM;
        }
        if (this.getIsEnsureRationalEndstate()) {
            result = this.isARM;
        }
        return result;
    }

    public String getStatus() {
        String result = "";
        if (!this.isDisposed) {
            result = "MemLevelInfoBit[" + this.getBitPosition() + "]: 0x" + Integer.toHexString(this.getMemAccessIdParamBits()) + ": type=" + this.getBitType();
            if (this.hasLevelAttributes()) {
                result = result + ", name = " + this.getMemTypeName() + ", memLevelName=" + this.getMemLevelName();
                if (this.getIsData()) {
                    result = result + "[Data]";
                }
                if (this.getIsProgram()) {
                    result = result + "[Prog]";
                }
                if (this.getIsCache()) {
                    result = result + "[Cache]";
                }
                if (this.getCanBeProtected()) {
                    result = result + "[CanBeProtected]";
                }
                if (this.getCanBeSecured()) {
                    result = result + "[CanBeSecured]";
                }
                if (this.getIsExternal()) {
                    result = result + "[External]";
                }
                if (this.getIsShared()) {
                    result = result + "[Shared]";
                }
                if (this.getIsMemLevelBypassable()) {
                    result = result + "[MemLevel CanBeBypassed]";
                }
            }
            if (this.getIsQueryBit()) {
                result = result + "[Query]";
            }
            if (this.getIsMmuBypass()) {
                result = result + "[MMU Bypass]";
            }
            if (this.getIsEnsureCoherent()) {
                result = result + "[EnsureCoherent]";
            }
            if (this.getIsEnsureRationalEndstate()) {
                result = result + "[Ensure Rational Endstate]";
            }
            if (this.isSetByDefaultForAllAccesses()) {
                result = result + "[Set by Default]";
            }
            result = result + "gti mem_access_id param bits = 0x" + Integer.toHexString(this.getMemAccessIdParamBits());
        }
        return result;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.info != null && !this.info.isDisposed()) {
                this.info.dispose();
                this.info = null;
            }
            if (this.levelAttributes != null && !this.levelAttributes.isDisposed()) {
                this.levelAttributes.dispose();
                this.levelAttributes = null;
            }
        }
    }
}

