/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryhierarchy;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoBit;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryLevelInfo;
import java.util.ArrayList;

public class MemLevelInfoHdlr
implements IDisposable {
    private IDspUser refDspUser = null;
    private TargetHandler target = null;
    private ArrayList<MemLevelInfoBit> listOfMemLevelInfoBits = null;
    private boolean isMmuBypassSupported = false;
    private boolean isStage2MmuBypassSupported = false;
    private boolean isCacheVisibilitySupported = false;
    long maxPhysicalMemoryWidth = 0L;
    long maxStage2PhysicalMemoryWidth = 0L;
    private int gtiCpuViewMemAccessIdFlags = 0;
    private int gtiPhysicalMemAccessIdFlags = 0;
    private int gtiStage2PhysicalMemAccessIdFlags = 0;
    private int gtiMemAccessIdFlags_AllLevels = 0;
    private ArrayList<MemoryTypeDescriptor> listOfMemoryTypes;
    private volatile boolean isDisposed = false;

    public MemLevelInfoHdlr(TargetHandler target, IDspUser refDspUser) {
        this.target = target;
        this.refDspUser = refDspUser;
        this.listOfMemLevelInfoBits = new ArrayList();
    }

    public void init() {
        this.listOfMemLevelInfoBits.clear();
        this.readMemoryLevelInfoFromDebugServer();
    }

    public ArrayList<MemLevelInfoBit> getListOfMemLevelInfoBits() {
        return this.listOfMemLevelInfoBits;
    }

    public boolean isMmuBypassSupported() {
        return this.isMmuBypassSupported;
    }

    public boolean isStage2MmuBypassSupported() {
        return this.isStage2MmuBypassSupported;
    }

    public boolean isCacheVisibilitySupported() {
        return this.isCacheVisibilitySupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMemoryLevelInfoFromDebugServer() {
        boolean result = false;
        this.gtiPhysicalMemAccessIdFlags = 0;
        this.gtiCpuViewMemAccessIdFlags = 0;
        if (this.refDspUser != null && !this.target.isDisconnected()) {
            IDspMemory dspMemoryObj;
            result = true;
            int startAdrs = 0;
            long numMAUs = 100L;
            short memPageNum = 0;
            MemLevelInfoBit memLevelInfoBit = null;
            IDspValue dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.ordinal(), startAdrs);
            if (dspAdrs.sizeOf() == 0) {
                dspAdrs.dispose();
                dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_POINTER.ordinal(), startAdrs);
            }
            if ((dspMemoryObj = this.refDspUser.createDspMemory(dspAdrs, (int)numMAUs, memPageNum)) != null) {
                IDspMemory2 dspMemory2Obj = dspMemoryObj.getIDspMemory2();
                try {
                    if (this.listOfMemLevelInfoBits.size() > 0) {
                        for (MemLevelInfoBit bit : this.listOfMemLevelInfoBits) {
                            if (bit == null || bit.isDisposed()) continue;
                            bit.dispose();
                        }
                    }
                    this.listOfMemLevelInfoBits.clear();
                    this.isCacheVisibilitySupported = false;
                    this.isMmuBypassSupported = false;
                    boolean isARM = this.target.info.isARMdevice();
                    for (short bitPos = 0; bitPos < 31; bitPos = (short)(bitPos + 1)) {
                        memLevelInfoBit = new MemLevelInfoBit(isARM, dspMemory2Obj, bitPos);
                        this.listOfMemLevelInfoBits.add(memLevelInfoBit);
                        if (memLevelInfoBit.isSetByDefaultForAllAccesses()) {
                            this.gtiMemAccessIdFlags_AllLevels |= memLevelInfoBit.getMemAccessIdParamBits();
                        }
                        if (memLevelInfoBit.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_RESERVED) continue;
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo(memLevelInfoBit.getStatus(), "MemLevelInfoHdlr.readMemoryLevelInfoFromDebugServer", this.target.info);
                        }
                        if (memLevelInfoBit.getIsMmuBypass()) {
                            this.isMmuBypassSupported = true;
                            this.gtiCpuViewMemAccessIdFlags = memLevelInfoBit.getMemAccessIdParamBits();
                        } else if (memLevelInfoBit.getIsStage2MmuBypass()) {
                            this.isStage2MmuBypassSupported = true;
                            this.gtiPhysicalMemAccessIdFlags |= memLevelInfoBit.getMemAccessIdParamBits();
                            this.gtiCpuViewMemAccessIdFlags = memLevelInfoBit.getMemAccessIdParamBits();
                        } else if (memLevelInfoBit.getBitType() == IMemoryLevelInfo.MEM_ACCESS_TYPE.MEM_ACCESS_MEM_LEVEL) {
                            this.gtiMemAccessIdFlags_AllLevels |= memLevelInfoBit.getMemAccessIdParamBits();
                            if (memLevelInfoBit.getLevelAttributes().getPhysicalAddressWidth() != 0L) {
                                this.gtiPhysicalMemAccessIdFlags |= memLevelInfoBit.getMemAccessIdParamBits();
                                this.setMaxPhysicalMemoryWidth(memLevelInfoBit.getLevelAttributes().getPhysicalAddressWidth());
                            }
                            if (memLevelInfoBit.getLevelAttributes().getStage2PhysicalAddressWidth() != 0L) {
                                this.setStage2MaxPhysicalMemoryWidth(memLevelInfoBit.getLevelAttributes().getStage2PhysicalAddressWidth());
                                this.gtiStage2PhysicalMemAccessIdFlags |= memLevelInfoBit.getMemAccessIdParamBits();
                            }
                        }
                        if (memLevelInfoBit.getIsCache()) {
                            this.isCacheVisibilitySupported = true;
                        }
                        if (!memLevelInfoBit.isSetByDefaultForPhysicalMemoryAccesses()) continue;
                        this.gtiPhysicalMemAccessIdFlags |= memLevelInfoBit.getMemAccessIdParamBits();
                        this.gtiStage2PhysicalMemAccessIdFlags |= memLevelInfoBit.getMemAccessIdParamBits();
                    }
                }
                finally {
                    if (dspAdrs != null) {
                        dspAdrs.dispose();
                    }
                    if (dspMemoryObj != null) {
                        dspMemoryObj.dispose();
                    }
                    if (dspMemory2Obj != null) {
                        dspMemory2Obj.dispose();
                    }
                }
            }
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("gtiCpuViewMemAccessIdFlags = 0x" + Long.toHexString(this.gtiCpuViewMemAccessIdFlags) + ", gtiPhysicalMemAccessIdFlags=0x" + Long.toHexString(this.gtiPhysicalMemAccessIdFlags) + ", isMmuBypassSupported=" + Boolean.toString(this.isMmuBypassSupported), "MemLevelInfoHdlr.readMemoryLevelInfoFromDebugServer", this.target.info);
        }
        return result;
    }

    public int getMaxPhysicalMemoryWidth() {
        return (int)this.maxPhysicalMemoryWidth;
    }

    private void setMaxPhysicalMemoryWidth(long width) {
        if (width > this.maxPhysicalMemoryWidth) {
            this.maxPhysicalMemoryWidth = width;
        }
    }

    public int getStage2MaxPhysicalMemoryWidth() {
        return (int)this.maxStage2PhysicalMemoryWidth;
    }

    private void setStage2MaxPhysicalMemoryWidth(long width) {
        if (width > this.maxStage2PhysicalMemoryWidth) {
            this.maxStage2PhysicalMemoryWidth = width;
        }
    }

    public boolean getMemTypesFromDriver(ArrayList<MemoryTypeDescriptor> listOfMemoryTypes, short memoryPageNumber, RegisterList listOfRegHandlers) {
        boolean result = false;
        int numL1Levels = 0;
        int numL1CacheLevels = 0;
        int numL2Levels = 0;
        int numL2CacheLevels = 0;
        int numL3Levels = 0;
        int numL3CacheLevels = 0;
        for (MemLevelInfoBit bit : this.listOfMemLevelInfoBits) {
            int memTypeIndex = 0;
            MemoryTypeDescriptor memType = null;
            if (bit.bitExists() && bit.isMemoryLevelAccessBit()) {
                result = true;
                int memLevelBitFlag = 0;
                if (bit.getMemLevel() > 0) {
                    memLevelBitFlag = 1 << bit.getMemLevel() - 1;
                }
                boolean isCacheTagRamSupported = false;
                if (!this.target.isDisconnected()) {
                    isCacheTagRamSupported = this.target.getDspTask().capableCacheTagRamReader();
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo(bit.getStatus(), "MemLevelInfoHdlr.getMemTypesFromDriver", this.target.info);
                }
                int maxNumCacheLines = 0;
                if (bit.getIsCache()) {
                    switch (bit.getMemoryLevelIndex()) {
                        case L1: {
                            maxNumCacheLines = 1024;
                            break;
                        }
                        case L1D: {
                            maxNumCacheLines = 512;
                            break;
                        }
                        case L1P: {
                            maxNumCacheLines = 1024;
                            break;
                        }
                        case L2: {
                            maxNumCacheLines = 16384;
                            break;
                        }
                        case L2_SHARED: {
                            maxNumCacheLines = 16384;
                            break;
                        }
                        case L3: {
                            maxNumCacheLines = 16384;
                            break;
                        }
                        case L3_SHARED: {
                            maxNumCacheLines = 16384;
                        }
                    }
                }
                switch (bit.getMemoryLevelIndex()) {
                    case L1: {
                        ++numL1Levels;
                        if (!bit.getIsCache()) break;
                        ++numL1CacheLevels;
                        break;
                    }
                    case L1P: {
                        ++numL1Levels;
                        if (!bit.getIsCache()) break;
                        ++numL1CacheLevels;
                        break;
                    }
                    case L1D: {
                        ++numL1Levels;
                        if (!bit.getIsCache()) break;
                        ++numL1CacheLevels;
                        break;
                    }
                    case L2: {
                        ++numL2Levels;
                        if (!bit.getIsCache()) break;
                        ++numL2CacheLevels;
                        break;
                    }
                    case L2_SHARED: {
                        ++numL2Levels;
                        if (bit.getIsCache()) {
                            ++numL2CacheLevels;
                        }
                    }
                    case L3: {
                        ++numL3Levels;
                        if (!bit.getIsCache()) break;
                        ++numL3CacheLevels;
                        break;
                    }
                    case L3_SHARED: {
                        ++numL3Levels;
                        if (!bit.getIsCache()) break;
                        ++numL3CacheLevels;
                    }
                }
                memType = new MemoryTypeDescriptor(memTypeIndex, bit.getMemTypeName(), bit.getMemLevelName(), bit.getMemLevel(), memLevelBitFlag, bit.getMemAccessIdParamBits(), bit.getIsCache(), bit.getMemLevelCapabilityFlags(), bit.getIsProgram(), bit.getIsData(), bit.getIsIO(), bit.getIsExternal(), bit.getIsShared(), bit.getIsDefaultPage(), "0x" + Long.toHexString(this.target.info.getMinAdrsInMemoryPage(memoryPageNumber)), this.target.info.getMemoryPageDataWidth(memoryPageNumber), false, false, bit.getIsPaged(), bit.getIsMmuBypass(), bit.getCacheLineSize(), maxNumCacheLines, isCacheTagRamSupported, memoryPageNumber);
                listOfMemoryTypes.add(memType);
            }
            ++memTypeIndex;
        }
        if (numL1Levels > 1 || numL2Levels > 1 || numL3Levels > 1) {
            if (numL1Levels > numL1CacheLevels) {
                numL1Levels -= numL1CacheLevels;
            }
            if (numL2Levels > numL2CacheLevels) {
                numL2Levels -= numL2CacheLevels;
            }
            if (numL3Levels > numL3CacheLevels) {
                numL3Levels -= numL3CacheLevels;
            }
            int baseL2Level = 1 << numL1Levels;
            int baseL3Level = 1 << numL1Levels + numL2Levels;
            int externalLevel = 1 << numL1Levels + numL2Levels + numL3Levels;
            for (MemoryTypeDescriptor memType : listOfMemoryTypes) {
                switch (memType.getMemoryLevelIndex()) {
                    case L1: {
                        memType.setMemoryLevelEnableFlags(1);
                        break;
                    }
                    case L1D: {
                        memType.setMemoryLevelEnableFlags(1);
                        break;
                    }
                    case L1P: {
                        memType.setMemoryLevelEnableFlags(2);
                        break;
                    }
                    case L2: {
                        memType.setMemoryLevelEnableFlags(baseL2Level);
                        break;
                    }
                    case L2_SHARED: {
                        if (numL2Levels == 1) {
                            memType.setMemoryLevelEnableFlags(baseL2Level);
                            break;
                        }
                        memType.setMemoryLevelEnableFlags(baseL2Level << 1);
                        break;
                    }
                    case L3: {
                        memType.setMemoryLevelEnableFlags(baseL3Level);
                        break;
                    }
                    case L3_SHARED: {
                        if (numL3Levels == 1) {
                            memType.setMemoryLevelEnableFlags(baseL3Level);
                            break;
                        }
                        memType.setMemoryLevelEnableFlags(baseL3Level << 1);
                        break;
                    }
                    case EXTERNAL: {
                        memType.setMemoryLevelEnableFlags(externalLevel);
                        break;
                    }
                    case PHYSICAL: {
                        memType.setMemoryLevelEnableFlags(externalLevel);
                    }
                }
            }
        }
        return result;
    }

    public int getGtiMemHierarchyReadEnableFlags(ArrayList<MemLevelInfoBit> listOfMemLevelInfoBits) {
        int result = 0;
        for (MemLevelInfoBit bit : listOfMemLevelInfoBits) {
            result |= 1 << bit.getBitPosition();
        }
        return result;
    }

    public ArrayList<MemLevelInfoBit> getMemLevelInfoBitsForMemoryLevel(EnumMemoryLevelIndex memoryLevelIndex) {
        ArrayList<MemLevelInfoBit> result = new ArrayList<MemLevelInfoBit>();
        for (MemLevelInfoBit bit : this.listOfMemLevelInfoBits) {
            if (bit.getMemoryLevelIndex() != memoryLevelIndex) continue;
            result.add(bit);
        }
        return result;
    }

    public MemLevelInfoBit getMemLevelInfoBitForMmuBypass() {
        MemLevelInfoBit result = null;
        for (MemLevelInfoBit bit : this.listOfMemLevelInfoBits) {
            if (!bit.getIsMmuBypass()) continue;
            result = bit;
            break;
        }
        return result;
    }

    public int calculateMemAccessIdFlags(EnumMemoryViews view, int memoryHierarchyFlags) {
        int flags = -1;
        switch (view) {
            case PHYSICAL_MEMORY_VIEW: {
                flags = 0;
                flags |= this.gtiPhysicalMemAccessIdFlags;
                break;
            }
            case STAGE2_PHYSICAL_MEMORY_VIEW: {
                flags = 0;
                flags |= this.gtiStage2PhysicalMemAccessIdFlags;
                break;
            }
            default: {
                if (memoryHierarchyFlags == 0) break;
                flags = memoryHierarchyFlags;
                flags |= this.gtiCpuViewMemAccessIdFlags;
            }
        }
        return flags;
    }

    public int getGtiMemAccessIdFlags_AllLevels() {
        return this.gtiMemAccessIdFlags_AllLevels;
    }

    public void setGtiMemAccessIdFlags_AllLevels(int value) {
        this.gtiMemAccessIdFlags_AllLevels = value;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfMemoryTypes() {
        return this.listOfMemoryTypes;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.listOfMemLevelInfoBits != null) {
                for (MemLevelInfoBit bit : this.listOfMemLevelInfoBits) {
                    if (bit == null || bit.isDisposed()) continue;
                    bit.dispose();
                }
                this.listOfMemLevelInfoBits.clear();
            }
        }
    }
}

