/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryhierarchy;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryCapabilityFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.ICacheTagRamHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.CacheTagRamHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;

public class MemoryHierarchyHandler
implements IDisposable {
    private TargetHandler target;
    private short memoryPageNum;
    private String xmlFileName = "";
    private ArrayList<MemoryTypeDescriptor> listOfMemoryLevels;
    private ArrayList<MemoryTypeDescriptor> listOfMemoryTypes;
    private ArrayList<MemoryTypeDescriptor> listOfMemoryTypesFromDriver;
    private ArrayList<MemoryTypeDescriptor> listOfTargetCaches;
    private RegisterList listOfRegHandlers;
    private ArrayList<MemoryTypeDescriptor> listOfMemoryViews;
    private int gtiHierarchyReadEnableFlags_AllLevels = 0;
    private int gtiHierarchyReadEnableFlags_DefaultLevels = 0;
    private int memoryLevelEnableFlags_DefaultLevels = 0;
    private int memoryLevelEnableFlags_AllLevels = 0;
    private int gtiHitCodeForExternalMemory = 0;
    private volatile boolean disposed = false;

    public MemoryHierarchyHandler(TargetHandler targetDevice, short memoryPageNum, RegisterList listOfRegisterHandlers) {
        this.memoryPageNum = memoryPageNum;
        this.target = targetDevice;
        this.xmlFileName = this.target.info.getXmlDeviceDescriptionFileName();
        this.listOfMemoryTypes = new ArrayList();
        this.listOfMemoryLevels = new ArrayList();
        this.listOfTargetCaches = new ArrayList();
        this.listOfMemoryViews = new ArrayList();
        this.listOfMemoryTypesFromDriver = new ArrayList();
        this.init(listOfRegisterHandlers);
    }

    public short getMemoryPageNum() {
        return this.memoryPageNum;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfMemoryLevels() {
        return this.listOfMemoryLevels;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfMemoryTypes() {
        return this.listOfMemoryTypes;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfMemoryTypesFromDriver() {
        return this.listOfMemoryTypesFromDriver;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfTargetCaches() {
        return this.listOfTargetCaches;
    }

    public RegisterList getListOfRegHandlers() {
        return this.listOfRegHandlers;
    }

    public void setListOfRegHandlers(RegisterList value) {
        this.listOfRegHandlers = value;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfMemoryViews() {
        return this.listOfMemoryViews;
    }

    public int getGtiHierarchyReadEnableFlags_AllLevels() {
        return this.gtiHierarchyReadEnableFlags_AllLevels;
    }

    public int getGtiHierarchyReadEnableFlags_DefaultLevels() {
        return this.gtiHierarchyReadEnableFlags_DefaultLevels;
    }

    public int getMemoryLevelEnableFlags_DefaultLevels() {
        return this.memoryLevelEnableFlags_DefaultLevels;
    }

    public int getMemoryLevelEnableFlags_AllLevels() {
        return this.memoryLevelEnableFlags_AllLevels;
    }

    public int getGtiHitCodeForExternalMemory() {
        return this.gtiHitCodeForExternalMemory;
    }

    public boolean isVirtualMemorySupported() {
        return this.target.getInfo().getXmlDeviceInfoHandler().isVirtualMemorySupported();
    }

    public synchronized void init(RegisterList registerHdlrList) {
        block44: {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("init called [...", "MemoryHierarchyHandler.init", this.target.info);
            }
            try {
                this.listOfRegHandlers = registerHdlrList;
                for (MemoryTypeDescriptor memType : this.listOfMemoryTypes) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
                this.listOfMemoryTypes.clear();
                for (MemoryTypeDescriptor memType : this.listOfMemoryLevels) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
                this.listOfMemoryLevels.clear();
                for (MemoryTypeDescriptor memType : this.listOfTargetCaches) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
                this.listOfTargetCaches.clear();
                for (MemoryTypeDescriptor memType : this.listOfMemoryViews) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
                this.listOfMemoryViews.clear();
                if (!this.target.getInfo().getXmlDeviceInfoHandler().readMemTypesFromXmlFile(this.listOfMemoryTypes, this.memoryPageNum, this.listOfRegHandlers)) {
                    this.defaultInit();
                }
                Collections.sort(this.listOfMemoryTypes);
                ArrayList<MemoryTypeDescriptor> notFoundList = new ArrayList<MemoryTypeDescriptor>();
                this.listOfMemoryTypesFromDriver.clear();
                MemLevelInfoHdlr memLevelInfoHdlr = this.target.getMemLevelInfoHdlr();
                if (memLevelInfoHdlr != null) {
                    memLevelInfoHdlr.getMemTypesFromDriver(this.listOfMemoryTypesFromDriver, this.memoryPageNum, this.listOfRegHandlers);
                    if (this.listOfMemoryTypesFromDriver.size() > 0) {
                        for (int i = 0; i < this.listOfMemoryTypesFromDriver.size(); ++i) {
                            MemoryTypeDescriptor driverMemType = this.listOfMemoryTypesFromDriver.get(i);
                            boolean found = false;
                            for (int j = 0; j < this.listOfMemoryTypes.size(); ++j) {
                                MemoryTypeDescriptor memType = this.listOfMemoryTypes.get(j);
                                if (!memType.isSameMemoryTypeAs(driverMemType)) continue;
                                found = true;
                                memType.importDriverParamInfo(driverMemType);
                                break;
                            }
                            if (found) continue;
                            notFoundList.add(driverMemType);
                        }
                    }
                }
                boolean isSortingNeeded = false;
                if (notFoundList.size() > 0) {
                    for (int i = 0; i < notFoundList.size(); ++i) {
                        this.listOfMemoryTypes.add((MemoryTypeDescriptor)notFoundList.get(i));
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) continue;
                        MemoryServerTrace.logInfo("Adding memType to listOfMemoryTypes: " + ((MemoryTypeDescriptor)notFoundList.get(i)).toString(), "MemoryHierarchyHandler.Init", this.target.getInfo());
                    }
                    notFoundList.clear();
                    isSortingNeeded = true;
                }
                if (this.listOfMemoryTypesFromDriver.size() > 0 && this.listOfMemoryTypes.size() > this.listOfMemoryTypesFromDriver.size()) {
                    int i = 0;
                    while (i < this.listOfMemoryTypes.size()) {
                        MemoryTypeDescriptor xmlMemType = this.listOfMemoryTypes.get(i);
                        boolean found = false;
                        for (int j = 0; j < this.listOfMemoryTypesFromDriver.size(); ++j) {
                            MemoryTypeDescriptor driverMemType = this.listOfMemoryTypesFromDriver.get(j);
                            if (!xmlMemType.isSameMemoryTypeAs(driverMemType)) continue;
                            found = true;
                            break;
                        }
                        if (!found && !xmlMemType.getLevelName().contains("Physical")) {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                                MemoryServerTrace.logInfo("Removing memType for " + (Object)((Object)xmlMemType.getMemoryLevelIndex()) + " from listOfMemoryTypes (not in list provided by driver): " + xmlMemType.toString(), "MemoryHierarchyHandler.Init", this.target.getInfo());
                            }
                            this.listOfMemoryTypes.remove(i);
                            isSortingNeeded = true;
                            continue;
                        }
                        ++i;
                    }
                }
                if (isSortingNeeded) {
                    Collections.sort(this.listOfMemoryTypes);
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    String traceInfo = "";
                    for (int i = 0; i < this.listOfMemoryTypes.size(); ++i) {
                        MemoryTypeDescriptor memType = this.listOfMemoryTypes.get(i);
                        traceInfo = memType.getName() + " [" + memType.getLevelName() + "] : memoryLevelIndex = " + (Object)((Object)memType.getMemoryLevelIndex()) + ", getMemoryLevelEnableFlags = " + Integer.toHexString(memType.getMemoryLevelEnableFlags());
                        MemoryServerTrace.logInfo(traceInfo, "MemoryHierarchyHandler.init", this.target.getInfo());
                    }
                }
                MemoryTypeDescriptor memLevelObj = null;
                this.memoryLevelEnableFlags_AllLevels = 0;
                this.memoryLevelEnableFlags_DefaultLevels = 0;
                int gtiFlagsForAllMemoryLevels = 0;
                int gtiFlagsForDefaultMemoryLevels = 0;
                for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryTypes) {
                    if (memTypeObj.isCache()) {
                        this.listOfTargetCaches.add(memTypeObj);
                    }
                    if (!memTypeObj.isExternalMemory()) continue;
                    this.gtiHitCodeForExternalMemory = memTypeObj.getGtiMemHierarchyReadEnableFlags();
                }
                for (MemoryTypeDescriptor cacheTypeObj : this.listOfTargetCaches) {
                    memLevelObj = new MemoryTypeDescriptor(cacheTypeObj);
                    memLevelObj.setName(memLevelObj.getLevelName());
                    for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryTypes) {
                        if (memTypeObj.getMemoryLevelEnableFlags() != memLevelObj.getMemoryLevelEnableFlags()) continue;
                        memLevelObj.setGtiMemHierarchyReadEnableFlags(memLevelObj.getGtiMemHierarchyReadEnableFlags() | memTypeObj.getGtiMemHierarchyReadEnableFlags());
                        memLevelObj.addCapabilityFlags(memTypeObj.getCapabilityFlags());
                        if (memTypeObj.isCache()) {
                            memLevelObj.setIsCache(true);
                        }
                        if (memTypeObj.isDataMemory()) {
                            memLevelObj.setIsDataMemory(true);
                        }
                        if (memTypeObj.isProgramMemory()) {
                            memLevelObj.setIsProgramMemory(true);
                        }
                        if (memTypeObj.canBeProtected()) {
                            memLevelObj.setCanBeProtected(true);
                            memLevelObj.setMemoryProtectionHandler(memTypeObj.getMemoryProtectionHandler());
                        }
                        if (memTypeObj.canBeSecured()) {
                            memLevelObj.setCanBeSecured(true);
                            memLevelObj.setMemorySecurityHandler(memTypeObj.getMemorySecurityHandler());
                        }
                        memLevelObj.getListOfAssociatedMemTypes().add(memTypeObj);
                    }
                    if ((this.memoryLevelEnableFlags_AllLevels & memLevelObj.getMemoryLevelEnableFlags()) == 0) {
                        this.memoryLevelEnableFlags_AllLevels |= memLevelObj.getMemoryLevelEnableFlags();
                        this.listOfMemoryLevels.add(memLevelObj);
                        if (memLevelObj.isBypassedByDefault()) continue;
                        this.memoryLevelEnableFlags_DefaultLevels |= memLevelObj.getMemoryLevelEnableFlags();
                        continue;
                    }
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) continue;
                    MemoryServerTrace.logInfo("NOT ADDING THE FOLLOWING MEMORY LEVEL OBJECT TO ListOfMemoryLevels: " + memLevelObj.toString(), "MemoryHierarchyHandler.init", this.target.getInfo());
                }
                int gtiFlagsForAllNonCacheMemoryLevels = 0;
                for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryTypes) {
                    if (!memTypeObj.isCache()) {
                        gtiFlagsForAllNonCacheMemoryLevels |= memTypeObj.getGtiMemHierarchyReadEnableFlags();
                    }
                    gtiFlagsForAllMemoryLevels |= memTypeObj.getGtiMemHierarchyReadEnableFlags();
                    if (!memTypeObj.isBypassedByDefault()) {
                        gtiFlagsForDefaultMemoryLevels |= memTypeObj.getGtiMemHierarchyReadEnableFlags();
                    }
                    if ((memTypeObj.getMemoryLevelEnableFlags() & this.memoryLevelEnableFlags_AllLevels) != 0) continue;
                    this.memoryLevelEnableFlags_AllLevels |= memTypeObj.getMemoryLevelEnableFlags();
                    if (!memTypeObj.isBypassedByDefault()) {
                        this.memoryLevelEnableFlags_DefaultLevels |= memTypeObj.getMemoryLevelEnableFlags();
                    }
                    if (memTypeObj.isCache() || this.isLevelNameInListOfLevels(memTypeObj)) continue;
                    memLevelObj = new MemoryTypeDescriptor(memTypeObj);
                    memLevelObj.setName(memLevelObj.getLevelName());
                    this.listOfMemoryLevels.add(memLevelObj);
                    memLevelObj.getListOfAssociatedMemTypes().add(memTypeObj);
                    for (MemoryTypeDescriptor memTypeTestObj : this.listOfMemoryTypes) {
                        if (memTypeTestObj.getMemoryLevelEnableFlags() != memLevelObj.getMemoryLevelEnableFlags()) continue;
                        memLevelObj.setGtiMemHierarchyReadEnableFlags(memLevelObj.getGtiMemHierarchyReadEnableFlags() | memTypeTestObj.getGtiMemHierarchyReadEnableFlags());
                        memLevelObj.getListOfAssociatedMemTypes().add(memTypeObj);
                    }
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("listOfMemoryTypes.size()=" + this.listOfMemoryTypes.size() + ", listOfMemoryLevels.size()=" + this.listOfMemoryLevels.size() + ", listOfTargetCaches.size()=" + this.listOfTargetCaches.size(), "MemoryHierarchyHandler.init", this.target.getInfo());
                }
                MemoryTypeDescriptor view0 = new MemoryTypeDescriptor(this.listOfMemoryLevels.get(0));
                view0.setMemoryLevelEnableFlags(this.memoryLevelEnableFlags_DefaultLevels);
                view0.setName("CPU View");
                view0.setLevelName("CPU View");
                view0.setHierarchyDepth(0);
                view0.setGtiMemHierarchyReadEnableFlags(0);
                view0.setIsCacheTagRamDecodingSupported(false);
                view0.setCacheTagRamHandler(null);
                this.listOfMemoryViews.add(view0);
                int viewNum = 1;
                if (this.target.getInfo().getXmlDeviceInfoHandler().isReadyToUse() && this.listOfMemoryLevels.size() > 1) {
                    for (MemoryTypeDescriptor memLevelDescriptor : this.listOfMemoryLevels) {
                        MemoryTypeDescriptor view = new MemoryTypeDescriptor(memLevelDescriptor);
                        if (view.getGtiMemHierarchyReadEnableFlags() == 0) continue;
                        ++viewNum;
                        this.listOfMemoryViews.add(view);
                    }
                }
                for (MemoryTypeDescriptor view : this.listOfMemoryViews) {
                    if (view.canBeBypassed()) continue;
                    view.setGtiMemHierarchyReadEnableFlags(gtiFlagsForAllNonCacheMemoryLevels);
                }
                this.gtiHierarchyReadEnableFlags_AllLevels = gtiFlagsForAllMemoryLevels;
                this.gtiHierarchyReadEnableFlags_DefaultLevels = gtiFlagsForDefaultMemoryLevels;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    viewNum = 0;
                    for (MemoryTypeDescriptor view : this.listOfMemoryViews) {
                        MemoryServerTrace.logInfo("View " + viewNum + ":  " + view.toString(), "MemoryHierarchyHandler.Init", this.target.getInfo());
                        ++viewNum;
                    }
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block44;
                MemoryServerTrace.logException("Error initializing memory hierarchy levels (" + this.target.getInfo().getXmlDeviceDescriptionFileName() + ")", "MemoryHierarchyHandler.Init", ex, this.target.getInfo());
            }
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("init complete ...]", "MemoryHierarchyHandler.init", this.target.info);
        }
    }

    public synchronized void initOnConnect() {
        ICacheTagRamHandler ctrHdlr = null;
        for (MemoryTypeDescriptor memTypeObj : this.listOfTargetCaches) {
            if (memTypeObj == null || memTypeObj.registerHdlrList == null) continue;
            ctrHdlr = new CacheTagRamHandler(this.target, memTypeObj, memTypeObj.saved_cacheTagInfo, memTypeObj.registerHdlrList.getListOfDecoders());
            memTypeObj.initOnConnect(ctrHdlr);
        }
        for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryTypes) {
            ctrHdlr = null;
            if (memTypeObj.isCache()) {
                for (MemoryTypeDescriptor cacheType : this.listOfTargetCaches) {
                    if (!cacheType.isSameMemoryTypeAs(memTypeObj)) continue;
                    ctrHdlr = cacheType.getCacheTagRamHandler();
                    break;
                }
            }
            memTypeObj.initOnConnect(ctrHdlr);
        }
        for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryLevels) {
            ctrHdlr = null;
            if (memTypeObj.isCache()) {
                for (MemoryTypeDescriptor cacheType : this.listOfTargetCaches) {
                    if (!cacheType.isSameMemoryTypeAs(memTypeObj)) continue;
                    ctrHdlr = cacheType.getCacheTagRamHandler();
                    break;
                }
            }
            memTypeObj.initOnConnect(ctrHdlr);
        }
        for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryViews) {
            ctrHdlr = null;
            if (memTypeObj.isCache()) {
                for (MemoryTypeDescriptor cacheType : this.listOfTargetCaches) {
                    if (!cacheType.isSameMemoryTypeAs(memTypeObj)) continue;
                    ctrHdlr = cacheType.getCacheTagRamHandler();
                    break;
                }
            }
            memTypeObj.initOnConnect(ctrHdlr);
        }
        for (MemoryTypeDescriptor memTypeObj : this.listOfMemoryTypesFromDriver) {
            ctrHdlr = null;
            if (memTypeObj.isCache()) {
                for (MemoryTypeDescriptor cacheType : this.listOfTargetCaches) {
                    if (!cacheType.isSameMemoryTypeAs(memTypeObj)) continue;
                    ctrHdlr = cacheType.getCacheTagRamHandler();
                    break;
                }
            }
            memTypeObj.initOnConnect(ctrHdlr);
        }
    }

    private boolean isLevelNameInListOfLevels(MemoryTypeDescriptor value) {
        boolean result = false;
        for (MemoryTypeDescriptor memLevelObj : this.listOfMemoryLevels) {
            if (!memLevelObj.getLevelName().equals(value.getLevelName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void defaultInit() {
        block11: {
            int defaultLineSize = 32;
            this.memoryLevelEnableFlags_AllLevels = 0;
            String memName = "";
            int memLevelDataWidth = 32;
            boolean isProgram = false;
            boolean isData = false;
            boolean isIO = false;
            if (this.target != null) {
                try {
                    memName = this.target.getInfo().getMemoryPageNames().get(this.getMemoryPageNum());
                    if (this.target.getInfo().getNumMemoryPages() > 1) {
                        switch (this.getMemoryPageNum()) {
                            case 0: {
                                isProgram = true;
                                break;
                            }
                            case 1: {
                                isData = true;
                                break;
                            }
                            case 2: {
                                isIO = true;
                                break;
                            }
                            case 3: {
                                isData = true;
                            }
                        }
                    } else {
                        isProgram = true;
                        isData = true;
                        isIO = true;
                    }
                    memLevelDataWidth = this.target.getInfo().getMemoryPageDataWidth(this.getMemoryPageNum());
                    MemoryTypeDescriptor memType = new MemoryTypeDescriptor(1, memName, memName, 1, 1, 0, false, EnumSet.noneOf(EnumMemoryCapabilityFlags.class), isProgram, isData, isIO, false, false, false, "SP", memLevelDataWidth, false, false, false, this.isVirtualMemorySupported(), defaultLineSize, 0, false, this.getMemoryPageNum());
                    memType.setMemoryLevelIndex(EnumMemoryLevelIndex.NONE);
                    this.listOfMemoryTypes.add(memType);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block11;
                    MemoryServerTrace.logException("Exception for memory page " + this.getMemoryPageNum(), "MemoryHierarchyHandler.DefaultInit", ex, this.target.getInfo());
                }
            }
        }
    }

    public int getMemoryHierarchyReadEnableFlags(int memoryLevelEnableFlags, boolean getFlagsForFirstNonBypassedLevelOnly, boolean getRawFlags) {
        int flags = 0;
        for (MemoryTypeDescriptor memLevelObj : this.listOfMemoryTypes) {
            if ((memLevelObj.getMemoryLevelEnableFlags() & memoryLevelEnableFlags) == 0) continue;
            flags |= memLevelObj.getGtiMemHierarchyReadEnableFlags();
            if (!getFlagsForFirstNonBypassedLevelOnly) continue;
            break;
        }
        if (flags == this.memoryLevelEnableFlags_DefaultLevels && !getRawFlags) {
            flags = 0;
        }
        return flags;
    }

    public int getMemoryViewIndex(int memoryLevelEnableFlags) {
        int index = 0;
        for (MemoryTypeDescriptor memLevelObj : this.listOfMemoryViews) {
            if (memLevelObj.getMemoryLevelEnableFlags() != memoryLevelEnableFlags) continue;
            index = this.listOfMemoryViews.indexOf(memLevelObj);
            break;
        }
        return index;
    }

    public boolean isMemoryLevelCacheEnabled(int memoryLevelEnableFlags, int viewIndex) {
        boolean result;
        block3: {
            MemoryTypeDescriptor memLevelObj;
            block2: {
                result = false;
                memLevelObj = null;
                if (memoryLevelEnableFlags != 0) break block2;
                if (viewIndex != 0) break block3;
                result = true;
                break block3;
            }
            if (viewIndex < this.listOfMemoryViews.size()) {
                memLevelObj = this.listOfMemoryViews.get(viewIndex);
                for (MemoryTypeDescriptor memType : memLevelObj.getListOfAssociatedMemTypes()) {
                    if (!memType.isCache() || (memType.getMemoryLevelEnableFlags() & memoryLevelEnableFlags) == 0) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public int getMemoryViewIndexFromGtiHitCode(int gtiHitCode) {
        int index = 0;
        for (MemoryTypeDescriptor memLevelObj : this.listOfMemoryViews) {
            if ((memLevelObj.getGtiMemHierarchyReadEnableFlags() & gtiHitCode) == 0) continue;
            index = this.listOfMemoryViews.indexOf(memLevelObj);
            break;
        }
        return index;
    }

    public MemoryTypeDescriptor getListOfMemoryTypesForGtiHitCode(long adrs, boolean includeAllNonCacheMemoryTypes, int gtiHitCode, int gtiEnabledMemLevelBits, ArrayList<MemoryTypeDescriptor> sortedListOfMemTypes) {
        MemoryTypeDescriptor cpuViewMemType = null;
        sortedListOfMemTypes.clear();
        for (MemoryTypeDescriptor memType : this.listOfMemoryTypes) {
            if (includeAllNonCacheMemoryTypes) {
                if ((memType.getGtiMemHierarchyReadEnableFlags() & gtiHitCode) == 0 || (memType.isCache() || !memType.isAdrsInThisMemoryType(adrs)) && ((memType.getGtiMemHierarchyReadEnableFlags() & gtiEnabledMemLevelBits & gtiHitCode) == 0 || !memType.isCache())) continue;
                sortedListOfMemTypes.add(memType);
                continue;
            }
            if ((memType.getGtiMemHierarchyReadEnableFlags() & gtiEnabledMemLevelBits & gtiHitCode) == 0 || !memType.isCache() && !memType.isAdrsInThisMemoryType(adrs)) continue;
            sortedListOfMemTypes.add(memType);
        }
        if (sortedListOfMemTypes.size() == 0) {
            for (MemoryTypeDescriptor memType : this.listOfMemoryTypes) {
                if ((memType.getGtiMemHierarchyReadEnableFlags() & gtiEnabledMemLevelBits & gtiHitCode) == 0) continue;
                sortedListOfMemTypes.add(memType);
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) || adrs < MemoryServerTrace.verboseTraceMinAdrs || adrs > MemoryServerTrace.verboseTraceMaxAdrs) break;
                MemoryServerTrace.logVerbose("Incorrect XML address range definition: GtiHitCode = 0x" + Long.toHexString(gtiHitCode) + ", adrs = 0x" + Long.toHexString(adrs) + ", adrs not found in memory type " + memType.getName() + ": " + "StartAdrs = 0x" + Long.toHexString(memType.getStartAddress()) + ", EndAdrs = 0x" + Long.toHexString(memType.getEndAddress()) + ", " + memType.toString(), "MemoryHierarchyHandler.GetListOfMemoryTypesForGtiHitCode", this.target.getInfo());
                break;
            }
        }
        if (sortedListOfMemTypes.size() > 0) {
            Collections.sort(sortedListOfMemTypes);
            cpuViewMemType = sortedListOfMemTypes.get(0);
        }
        return cpuViewMemType;
    }

    public MemoryTypeDescriptor getMemoryTypeDescriptorForMemoryLevel(EnumMemoryLevelIndex memoryLevelIndex) {
        MemoryTypeDescriptor result = null;
        for (MemoryTypeDescriptor memType : this.listOfMemoryLevels) {
            if (memType.getMemoryLevelIndex().compareTo(memoryLevelIndex) != 0) continue;
            result = memType;
            break;
        }
        return result;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            if (this.listOfRegHandlers != null && !this.listOfRegHandlers.isDisposed()) {
                this.listOfRegHandlers.dispose();
            }
            this.listOfRegHandlers = null;
            if (this.listOfMemoryLevels != null) {
                for (MemoryTypeDescriptor memType : this.listOfMemoryLevels) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
            }
            this.listOfMemoryLevels.clear();
            this.listOfMemoryLevels = null;
            if (this.listOfMemoryTypes != null) {
                for (MemoryTypeDescriptor memType : this.listOfMemoryTypes) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
            }
            this.listOfMemoryTypes.clear();
            this.listOfMemoryTypes = null;
            if (this.listOfMemoryViews != null) {
                for (MemoryTypeDescriptor memType : this.listOfMemoryViews) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
            }
            this.listOfMemoryViews.clear();
            this.listOfMemoryViews = null;
            if (this.listOfTargetCaches != null) {
                for (MemoryTypeDescriptor memType : this.listOfTargetCaches) {
                    if (memType.isDisposed()) continue;
                    memType.dispose();
                }
            }
            this.listOfTargetCaches.clear();
            this.listOfTargetCaches = null;
        }
        this.disposed = true;
    }

    public void acquire() {
    }
}

