/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryhierarchy;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryCapabilityFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryLevelIndex;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.ICacheTagRamHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.AddressMappedAttributeHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoBit;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.target.CacheTagRamHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import java.util.ArrayList;
import java.util.EnumSet;

public class MemoryTypeDescriptor
implements Comparable<MemoryTypeDescriptor>,
IDisposable {
    private String name = "External";
    private String levelName = "External";
    private int hierarchyDepth = 0;
    private int memoryLevelEnableFlags = 0;
    private int id;
    private int physicalSize;
    private boolean isStartAddressFixed = false;
    private boolean saved_isStartAddressFixed = false;
    private long fixedStartAddress = 0L;
    private long saved_fixedStartAddress = 0L;
    private RegisterDecoder decoder_StartAddress = null;
    private RegisterDecoder saved_decoder_StartAddress = null;
    private TargetHandler target = null;
    public RegisterList registerHdlrList = null;
    private boolean isLengthFixed = false;
    private boolean saved_isLengthFixed = false;
    private long fixedLength = 0L;
    private long saved_fixedLength = 0L;
    private RegisterDecoder decoder_Length = null;
    private RegisterDecoder saved_decoder_Length = null;
    public DeviceXMLReader.CacheTagInfo saved_cacheTagInfo = null;
    private int gtiMemHierarchyReadEnableFlags = 0;
    private int gtiPhysicalMemAccessIdFlags = 0;
    private boolean isMemoryTypeDeterminedByAddress = false;
    private EnumMemoryLevelIndex memoryLevelIndex = EnumMemoryLevelIndex.EXTERNAL;
    private boolean cacheLineBorderMarkerEnabled = false;
    private boolean isCache = false;
    private boolean isVirtualWayConversionEnabled = false;
    private short memoryPageNumber = 0;
    private boolean isBypassedByDefault = false;
    private EnumSet<EnumMemoryCapabilityFlags> capabilityFlags = EnumSet.noneOf(EnumMemoryCapabilityFlags.class);
    private String checkBoxToolTipText = "";
    private String checkBoxToolTipText_NoMemoryLevelVisibility = "";
    private String memoryLevelToolTipText = "";
    private boolean isProgramMemory = false;
    private boolean isDataMemory = false;
    private boolean isIOSpace = false;
    private boolean isExternalMemory = false;
    private boolean isSharedMemory = false;
    private boolean isReserved = false;
    private boolean isROM = false;
    private boolean isPaged = false;
    private boolean isDefaultPage = false;
    private int dataWidth = 32;
    private String defaultDisplayAddressString = "SP";
    private boolean isVirtualMemorySupported = false;
    private boolean canBeProtected = false;
    private boolean hasMemoryAccessIDs = false;
    private boolean canBeSecured = false;
    private boolean isCacheTagRamDecodingSupported = false;
    private int cacheLineSize = 128;
    private int numBitsToRightShiftAdrsToGetSetId = 0;
    private int maxNumCacheLines = 0;
    private RegisterDecoder decoder_NumCacheLines = null;
    private RegisterDecoder saved_decoder_NumCacheLines = null;
    private RegisterDecoder decoder_CacheSize = null;
    private RegisterDecoder saved_decoder_CacheSize = null;
    private RegisterDecoder decoder_IsCacheEnabled = null;
    private RegisterDecoder saved_decoder_IsCacheEnabled = null;
    private ICacheTagRamHandler cacheTagRamHandler = null;
    private AddressMappedAttributeHandler memoryProtectionHandler;
    private AddressMappedAttributeHandler memoryAccessIDHandler;
    private AddressMappedAttributeHandler memorySecurityHandler;
    private ArrayList<MemoryTypeDescriptor> listOfAssociatedMemTypes = null;
    private volatile boolean disposed = false;

    public MemoryTypeDescriptor(int memId, String memTypeName, String memLevelName, int memLevelHierarchyDepth, int memLevelBitFlag, int GTIMemHierarchyReadEnableFlags, boolean memLevelIsCache, EnumSet<EnumMemoryCapabilityFlags> memLevelCapabilityFlags, boolean memLevelIsProgramMemory, boolean memLevelIsDataMemory, boolean memLevelIsIOSpace, boolean memLevelIsExternalMemory, boolean memLevelIsSharedMemory, boolean memLevelIsDefaultPage, String memLevelDefaultDisplayAddressString, int memLevelDataWidth, boolean memTypeIsReserved, boolean memLevelIsROM, boolean memLevelIsPaged, boolean memLevelIsVirtualMemorySupported, int cacheLineSize, int maxNumCacheLines, boolean isCacheTagRamDecodingSupported, short memoryPageNumber) {
        this.listOfAssociatedMemTypes = new ArrayList();
        this.id = memId;
        this.levelName = memLevelName;
        this.name = memTypeName;
        this.hierarchyDepth = memLevelHierarchyDepth;
        this.setGtiMemHierarchyReadEnableFlags(GTIMemHierarchyReadEnableFlags);
        this.setMemoryLevelEnableFlags(memLevelBitFlag);
        this.setIsCache(memLevelIsCache);
        this.setCapabilityFlags(memLevelCapabilityFlags);
        this.setIsProgramMemory(memLevelIsProgramMemory);
        this.setIsDataMemory(memLevelIsDataMemory);
        this.setIsIOSpace(memLevelIsIOSpace);
        this.setIsExternalMemory(memLevelIsExternalMemory);
        this.setIsDefaultPage(memLevelIsDefaultPage);
        this.setDataWidth(memLevelDataWidth);
        this.setDefaultDisplayAddressString(memLevelDefaultDisplayAddressString);
        this.setIsSharedMemory(memLevelIsSharedMemory);
        this.setIsReserved(memTypeIsReserved);
        this.setIsROM(memLevelIsROM);
        this.setIsPaged(memLevelIsPaged);
        this.setIsVirtualMemorySupported(memLevelIsVirtualMemorySupported);
        this.setCacheLineSize(cacheLineSize);
        this.maxNumCacheLines = maxNumCacheLines;
        this.isCacheTagRamDecodingSupported = isCacheTagRamDecodingSupported;
        this.memoryPageNumber = memoryPageNumber;
        this.setMemoryLevelIndex(this.calculateMemoryLevelIndex());
        this.isBypassedByDefault = this.getMemoryLevelIndex() == EnumMemoryLevelIndex.L1P ? this.isCache : false;
    }

    public MemoryTypeDescriptor(MemoryTypeDescriptor memTypeObj) {
        this.target = memTypeObj.target;
        this.registerHdlrList = memTypeObj.registerHdlrList;
        this.listOfAssociatedMemTypes = new ArrayList();
        for (MemoryTypeDescriptor associatedMemType : memTypeObj.getListOfAssociatedMemTypes()) {
            this.listOfAssociatedMemTypes.add(associatedMemType);
        }
        this.id = memTypeObj.getId();
        this.name = memTypeObj.getName();
        this.levelName = memTypeObj.getLevelName();
        this.setMemoryLevelIndex(memTypeObj.getMemoryLevelIndex());
        this.setCacheLineBorderMarkerEnabled(memTypeObj.getCacheLineBorderMarkerEnabled());
        this.hierarchyDepth = memTypeObj.getHierarchyDepth();
        this.setGtiMemHierarchyReadEnableFlags(memTypeObj.getGtiMemHierarchyReadEnableFlags());
        this.setMemoryLevelEnableFlags(memTypeObj.getMemoryLevelEnableFlags());
        this.setIsCache(memTypeObj.isCache());
        this.setCapabilityFlags(memTypeObj.getCapabilityFlags());
        this.isBypassedByDefault = memTypeObj.isBypassedByDefault();
        this.setCheckBoxToolTipText(memTypeObj.getCheckBoxToolTipText());
        this.setCheckBoxToolTipText_NoMemoryLevelVisibility(memTypeObj.getCheckBoxToolTipText_NoMemoryLevelVisibility());
        this.setMemoryLevelToolTipText(memTypeObj.getMemoryLevelToolTipText());
        this.setIsProgramMemory(memTypeObj.isProgramMemory());
        this.setIsDataMemory(memTypeObj.isDataMemory());
        this.setIsIOSpace(memTypeObj.isIOSpace());
        this.setIsExternalMemory(memTypeObj.isExternalMemory());
        this.setIsSharedMemory(memTypeObj.isSharedMemory());
        this.setIsReserved(memTypeObj.isReserved());
        this.setIsROM(memTypeObj.isROM());
        this.setIsPaged(memTypeObj.isPaged());
        this.setIsVirtualMemorySupported(memTypeObj.isVirtualMemorySupported());
        this.setCacheLineSize(memTypeObj.getCacheLineSize());
        this.decoder_CacheSize = memTypeObj.getDecoder_CacheSize();
        this.decoder_IsCacheEnabled = memTypeObj.getDecoder_IsCacheEnabled();
        this.decoder_NumCacheLines = memTypeObj.getDecoder_NumCacheLines();
        if (memTypeObj.getCacheTagRamHandler() != null) {
            this.setCacheTagRamHandler(memTypeObj.getCacheTagRamHandler());
        }
        this.setIsCacheTagRamDecodingSupported(memTypeObj.isCacheTagRamDecodingSupported());
        this.maxNumCacheLines = memTypeObj.getMaxNumCacheLines();
        this.setMemoryPageNumber(memTypeObj.getMemoryPageNumber());
        this.setIsVirtualWayConversionEnabled(memTypeObj.isVirtualWayConversionEnabled());
        this.setIsDefaultPage(memTypeObj.isDefaultPage());
        this.setDataWidth(memTypeObj.getDataWidth());
        this.defaultDisplayAddressString = memTypeObj.getDefaultDisplayAddressString();
        this.canBeProtected = memTypeObj.canBeProtected();
        if (this.canBeProtected) {
            this.memoryProtectionHandler = memTypeObj.getMemoryProtectionHandler();
        }
        this.hasMemoryAccessIDs = memTypeObj.hasMemoryAccessIDs();
        if (this.hasMemoryAccessIDs) {
            this.memoryAccessIDHandler = memTypeObj.getMemoryAccessIDHandler();
        }
        this.canBeSecured = memTypeObj.canBeSecured();
        if (this.canBeSecured) {
            this.memorySecurityHandler = memTypeObj.getMemorySecurityHandler();
        }
        this.saved_decoder_NumCacheLines = memTypeObj.saved_decoder_NumCacheLines;
        this.saved_decoder_CacheSize = memTypeObj.saved_decoder_CacheSize;
        this.saved_decoder_IsCacheEnabled = memTypeObj.saved_decoder_IsCacheEnabled;
        this.saved_isStartAddressFixed = memTypeObj.saved_isStartAddressFixed;
        this.saved_fixedStartAddress = memTypeObj.saved_fixedStartAddress;
        this.saved_decoder_StartAddress = memTypeObj.saved_decoder_StartAddress;
        this.saved_isLengthFixed = memTypeObj.saved_isLengthFixed;
        this.saved_fixedLength = memTypeObj.saved_fixedLength;
        this.saved_decoder_Length = memTypeObj.saved_decoder_Length;
        this.saved_cacheTagInfo = memTypeObj.saved_cacheTagInfo;
    }

    public MemoryTypeDescriptor(int memId, short memoryPageNumber, TargetHandler target, XmlElement memoryTypeNode, RegisterList listOfRegHandlers) {
        MyXPathNodeIterator securityNodeIterator;
        XmlElement mpNode;
        MyXPathNodeIterator mpNodeIterator;
        XmlHelper xmlHelper = new XmlHelper();
        this.target = target;
        this.registerHdlrList = listOfRegHandlers;
        this.listOfAssociatedMemTypes = new ArrayList();
        this.id = memId;
        this.setMemoryPageNumber(memoryPageNumber);
        this.name = xmlHelper.getString(memoryTypeNode, "Name", "L" + this.id, 0);
        this.levelName = xmlHelper.getString(memoryTypeNode, "MemoryLevelName", "External", 0);
        this.hierarchyDepth = xmlHelper.getInt(memoryTypeNode, "HierarchyDepth", this.hierarchyDepth, 0);
        this.cacheLineBorderMarkerEnabled = false;
        this.setGtiMemHierarchyReadEnableFlags(xmlHelper.getInt(memoryTypeNode, "GTIMemHierarchyReadEnableFlags", this.getGtiMemHierarchyReadEnableFlags(), 0));
        this.isMemoryTypeDeterminedByAddress = xmlHelper.getBoolean(memoryTypeNode, "IsMemoryTypeDeterminedByAddress", this.isMemoryTypeDeterminedByAddress(), 0);
        this.setMemoryLevelEnableFlags(xmlHelper.getInt(memoryTypeNode, "MemLevelBitFlag", this.gtiMemHierarchyReadEnableFlags, 0));
        this.isCache = xmlHelper.getBoolean(memoryTypeNode, "IsCache", false, 0);
        if (xmlHelper.getBoolean(memoryTypeNode, "CanBeBypassed", false, 0)) {
            this.capabilityFlags = EnumSet.of(EnumMemoryCapabilityFlags.CAN_BE_BYPASSED);
        }
        this.isBypassedByDefault = xmlHelper.getBoolean(memoryTypeNode, "IsBypassedByDefault", false, 0);
        if (xmlHelper.getBoolean(memoryTypeNode, "SimulatorSupportsConsistencyChecking", false, 0)) {
            this.capabilityFlags.add(EnumMemoryCapabilityFlags.SIMULATOR_SUPPORTS_CONSISTENCY_CHECKING);
        }
        this.isProgramMemory = xmlHelper.getBoolean(memoryTypeNode, "IsProgram", true, 0);
        this.isDataMemory = xmlHelper.getBoolean(memoryTypeNode, "IsData", true, 0);
        this.isIOSpace = xmlHelper.getBoolean(memoryTypeNode, "IsIOSpace", true, 0);
        this.isExternalMemory = xmlHelper.getBoolean(memoryTypeNode, "IsExternal", true, 0);
        this.isSharedMemory = xmlHelper.getBoolean(memoryTypeNode, "IsShared", false, 0);
        this.isReserved = xmlHelper.getBoolean(memoryTypeNode, "IsReserved", false, 0);
        this.isROM = xmlHelper.getBoolean(memoryTypeNode, "IsROM", false, 0);
        this.isPaged = xmlHelper.getBoolean(memoryTypeNode, "IsPaged", false, 0);
        this.isVirtualMemorySupported = xmlHelper.getBoolean(memoryTypeNode, "IsVirtualMemorySupported", false, 0);
        this.cacheLineSize = xmlHelper.getInt(memoryTypeNode, "Linesize", this.cacheLineSize, 0);
        this.isVirtualWayConversionEnabled = xmlHelper.getBoolean(memoryTypeNode, "IsVirtualWayConversionEnabled", false, 0);
        this.isDefaultPage = xmlHelper.getBoolean(memoryTypeNode, "IsDefaultPage", false, 0);
        this.dataWidth = target.info.getMemoryPageDataWidth(memoryPageNumber);
        this.defaultDisplayAddressString = xmlHelper.getString(memoryTypeNode, "DefaultDisplayAddressString", "SP", 0);
        this.isCacheTagRamDecodingSupported = xmlHelper.getBoolean(memoryTypeNode, "Cache/IsCacheTagRamDecodingSupported", false, 0);
        this.maxNumCacheLines = xmlHelper.getInt(memoryTypeNode, "Cache/MaxNumCacheLines", 0, 0);
        if (this.isCache && (target.getInfo().getTargetTypeId() == EnumTargetType.SIMULATOR || !target.isDisconnected())) {
            try {
                this.setCacheTagRamHandler(new CacheTagRamHandler(target, this, memoryTypeNode, listOfRegHandlers.getListOfDecoders()));
                if (!this.cacheTagRamHandler.isCacheTagRamReadable()) {
                    this.isCacheTagRamDecodingSupported = false;
                    this.cacheTagRamHandler = null;
                } else {
                    this.isCacheTagRamDecodingSupported = true;
                }
            }
            catch (Exception e) {
                this.isCacheTagRamDecodingSupported = false;
                this.cacheTagRamHandler = null;
            }
            this.decoder_NumCacheLines = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/NumCacheLines/", listOfRegHandlers, 0);
            this.decoder_CacheSize = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/CacheSize/", listOfRegHandlers, 0);
            this.decoder_IsCacheEnabled = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/IsCacheEnabled/", listOfRegHandlers, 0);
        } else {
            this.isCacheTagRamDecodingSupported = false;
            this.isStartAddressFixed = xmlHelper.getBoolean(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/IsFixed", false, 0);
            this.fixedStartAddress = xmlHelper.getLong(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/FixedValue", 0L, 0);
            this.decoder_StartAddress = xmlHelper.getRegDecoder(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/", listOfRegHandlers, 0);
            this.isLengthFixed = xmlHelper.getBoolean(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/IsFixed", false, 0);
            this.fixedLength = xmlHelper.getLong(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/FixedValue", 0L, 0);
            this.decoder_Length = xmlHelper.getRegDecoder(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/", listOfRegHandlers, 0);
        }
        this.canBeProtected = xmlHelper.getBoolean(memoryTypeNode, "CanBeProtected", false, 0);
        if (this.canBeProtected && (mpNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemoryProtection']", true)) != null && mpNodeIterator.size() > 0) {
            mpNode = mpNodeIterator.get(0);
            this.memoryProtectionHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", mpNode, listOfRegHandlers);
        }
        this.hasMemoryAccessIDs = xmlHelper.getBoolean(memoryTypeNode, "HasMemoryAccessIDs", false, 0);
        if (this.hasMemoryAccessIDs && (mpNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemoryAccessIDs']", true)) != null && mpNodeIterator.size() > 0) {
            mpNode = mpNodeIterator.get(0);
            this.memoryAccessIDHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", mpNode, listOfRegHandlers);
        }
        this.canBeSecured = xmlHelper.getBoolean(memoryTypeNode, "CanBeSecured", false, 0);
        if (this.canBeSecured && (securityNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemorySecurity']", true)) != null && securityNodeIterator.size() > 0) {
            XmlElement securityNode = securityNodeIterator.get(0);
            this.memorySecurityHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", securityNode, listOfRegHandlers);
        }
        this.memoryLevelIndex = this.calculateMemoryLevelIndex();
    }

    public MemoryTypeDescriptor(int memId, short memoryPageNumber, TargetHandler target, DeviceXMLReader.MemoryTypeItem memoryTypeNode, RegisterList listOfRegHandlers) {
        this.target = target;
        this.registerHdlrList = listOfRegHandlers;
        this.listOfAssociatedMemTypes = new ArrayList();
        this.id = memId;
        this.setMemoryPageNumber(memoryPageNumber);
        this.name = memoryTypeNode.name.length() > 0 ? memoryTypeNode.name : "L" + this.id;
        this.levelName = memoryTypeNode.levelName;
        if (memoryTypeNode.hierarchyDepth >= 0) {
            this.hierarchyDepth = memoryTypeNode.hierarchyDepth;
        }
        this.cacheLineBorderMarkerEnabled = false;
        int gtiMemHierarchyReadEnableFlags = this.gtiMemHierarchyReadEnableFlags;
        if (memoryTypeNode.gtiMemHierarchyReadEnableFlags >= 0) {
            gtiMemHierarchyReadEnableFlags = memoryTypeNode.gtiMemHierarchyReadEnableFlags;
        }
        this.setGtiMemHierarchyReadEnableFlags(gtiMemHierarchyReadEnableFlags);
        if (memoryTypeNode.isMemoryTypeDeterminedByAddress.length() > 0) {
            boolean bl = this.isMemoryTypeDeterminedByAddress = memoryTypeNode.isMemoryTypeDeterminedByAddress.compareToIgnoreCase("true") == 0;
        }
        if (memoryTypeNode.memoryLevelEnableFlags >= 0) {
            this.setMemoryLevelEnableFlags(memoryTypeNode.memoryLevelEnableFlags);
        }
        this.isCache = memoryTypeNode.isCache;
        if (memoryTypeNode.canBeBypassed) {
            this.capabilityFlags = EnumSet.of(EnumMemoryCapabilityFlags.CAN_BE_BYPASSED);
        }
        this.isBypassedByDefault = memoryTypeNode.isBypassedByDefault;
        if (memoryTypeNode.isSimulatorSupportsConsistencyChecking) {
            this.capabilityFlags.add(EnumMemoryCapabilityFlags.SIMULATOR_SUPPORTS_CONSISTENCY_CHECKING);
        }
        this.isProgramMemory = memoryTypeNode.isProgramMemory;
        this.isDataMemory = memoryTypeNode.isDataMemory;
        this.isIOSpace = memoryTypeNode.isIOSpace;
        this.isExternalMemory = memoryTypeNode.isExternalMemory;
        this.isSharedMemory = memoryTypeNode.isSharedMemory;
        this.isReserved = memoryTypeNode.isReserved;
        this.isROM = memoryTypeNode.isROM;
        this.isPaged = memoryTypeNode.isPaged;
        this.isVirtualMemorySupported = memoryTypeNode.isVirtualWayConversionEnabled;
        if (memoryTypeNode.cacheLineSize >= 0) {
            this.cacheLineSize = memoryTypeNode.cacheLineSize;
        }
        this.isVirtualWayConversionEnabled = memoryTypeNode.isVirtualWayConversionEnabled;
        this.isDefaultPage = memoryTypeNode.isDefaultPage;
        this.dataWidth = target.info.getMemoryPageDataWidth(memoryPageNumber);
        this.defaultDisplayAddressString = memoryTypeNode.defaultDisplayAddressString;
        this.isCacheTagRamDecodingSupported = memoryTypeNode.isCacheTagRamDecodingSupported;
        this.maxNumCacheLines = memoryTypeNode.maxNumCacheLines;
        this.saved_decoder_NumCacheLines = this.getRegDecoder(memoryTypeNode.decoder_NumCacheLines, listOfRegHandlers);
        this.saved_decoder_CacheSize = this.getRegDecoder(memoryTypeNode.decoder_CacheSize, listOfRegHandlers);
        this.saved_decoder_IsCacheEnabled = this.getRegDecoder(memoryTypeNode.decoder_IsCacheEnabled, listOfRegHandlers);
        this.saved_isStartAddressFixed = memoryTypeNode.isStartAddressFixed;
        this.saved_fixedStartAddress = memoryTypeNode.fixedStartAddress;
        this.saved_decoder_StartAddress = this.getRegDecoder(memoryTypeNode.decoder_StartAddress, listOfRegHandlers);
        this.saved_isLengthFixed = memoryTypeNode.isLengthFixed;
        this.saved_fixedLength = memoryTypeNode.fixedLength;
        this.saved_decoder_Length = this.getRegDecoder(memoryTypeNode.decoder_Length, listOfRegHandlers);
        this.saved_cacheTagInfo = memoryTypeNode.cacheTagInfo;
        if (this.isCache && (target.getInfo().getTargetTypeId() == EnumTargetType.SIMULATOR || !target.isDisconnected())) {
            try {
                this.setCacheTagRamHandler(new CacheTagRamHandler(target, this, this.saved_cacheTagInfo, listOfRegHandlers.getListOfDecoders()));
                if (!this.cacheTagRamHandler.isCacheTagRamReadable()) {
                    this.isCacheTagRamDecodingSupported = false;
                    this.cacheTagRamHandler = null;
                }
            }
            catch (Exception e) {
                this.isCacheTagRamDecodingSupported = false;
                this.cacheTagRamHandler = null;
            }
            this.decoder_NumCacheLines = this.saved_decoder_NumCacheLines;
            this.decoder_CacheSize = this.saved_decoder_CacheSize;
            this.decoder_IsCacheEnabled = this.saved_decoder_IsCacheEnabled;
        } else {
            this.isCacheTagRamDecodingSupported = false;
            this.isStartAddressFixed = this.saved_isStartAddressFixed;
            this.fixedStartAddress = this.saved_fixedStartAddress;
            this.decoder_StartAddress = this.saved_decoder_StartAddress;
            this.isLengthFixed = this.saved_isLengthFixed;
            this.fixedLength = this.saved_fixedLength;
            this.decoder_Length = this.saved_decoder_Length;
        }
        this.canBeProtected = memoryTypeNode.canBeProtected;
        if (this.canBeProtected && memoryTypeNode.memoryProtectionHandler != null) {
            this.memoryProtectionHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", memoryTypeNode.memoryProtectionHandler, listOfRegHandlers);
        }
        this.hasMemoryAccessIDs = memoryTypeNode.hasMemoryAccessIDs;
        if (this.hasMemoryAccessIDs && memoryTypeNode.memoryAccessIDHandler != null) {
            this.memoryAccessIDHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", memoryTypeNode.memoryAccessIDHandler, listOfRegHandlers);
        }
        this.canBeSecured = memoryTypeNode.canBeSecured;
        if (this.canBeSecured && memoryTypeNode.memorySecurityHandler != null) {
            this.memorySecurityHandler = new AddressMappedAttributeHandler(this, "Address 0x", "", memoryTypeNode.memorySecurityHandler, listOfRegHandlers);
        }
        this.memoryLevelIndex = this.calculateMemoryLevelIndex();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String value) {
        this.levelName = value;
    }

    public int getHierarchyDepth() {
        return this.hierarchyDepth;
    }

    public void setHierarchyDepth(int value) {
        this.hierarchyDepth = value;
    }

    public int getMemoryLevelEnableFlags() {
        return this.memoryLevelEnableFlags;
    }

    public void setMemoryLevelEnableFlags(int value) {
        this.memoryLevelEnableFlags = value;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public int getPhysicalSize() {
        return this.physicalSize;
    }

    public void setPhysicalSize(int value) {
        this.physicalSize = value;
    }

    public long getStartAddress() {
        return this.getLongProperty(this.isStartAddressFixed, this.fixedStartAddress, this.decoder_StartAddress);
    }

    public long getLengthInMAUs() {
        return this.getLongProperty(this.isLengthFixed, this.fixedLength, this.decoder_Length);
    }

    public long getEndAddress() {
        return this.getStartAddress() + this.getLengthInMAUs() - 1L;
    }

    public int getGtiMemHierarchyReadEnableFlags() {
        return this.gtiMemHierarchyReadEnableFlags;
    }

    public void setGtiMemHierarchyReadEnableFlags(int value) {
        this.gtiMemHierarchyReadEnableFlags = value;
    }

    public int getGtiPhysicalMemAccessIdFlags() {
        return this.gtiPhysicalMemAccessIdFlags;
    }

    public void setGtiPhysicalMemAccessIdFlags(int value) {
        this.gtiPhysicalMemAccessIdFlags = value;
    }

    public boolean isMemoryTypeDeterminedByAddress() {
        return this.isMemoryTypeDeterminedByAddress;
    }

    public void setIsMemoryTypeDeterminedByAddress(boolean value) {
        this.isMemoryTypeDeterminedByAddress = value;
    }

    public EnumMemoryLevelIndex getMemoryLevelIndex() {
        return this.memoryLevelIndex;
    }

    public void setMemoryLevelIndex(EnumMemoryLevelIndex value) {
        this.memoryLevelIndex = value;
    }

    public boolean getCacheLineBorderMarkerEnabled() {
        return this.cacheLineBorderMarkerEnabled;
    }

    public void setCacheLineBorderMarkerEnabled(boolean value) {
        this.cacheLineBorderMarkerEnabled = value;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setIsCache(boolean value) {
        this.isCache = value;
    }

    public boolean isVirtualWayConversionEnabled() {
        return this.isVirtualWayConversionEnabled;
    }

    public void setIsVirtualWayConversionEnabled(boolean value) {
        this.isVirtualWayConversionEnabled = value;
    }

    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    public void setMemoryPageNumber(short value) {
        this.memoryPageNumber = value;
    }

    public boolean canBeBypassed() {
        boolean result = this.capabilityFlags.contains((Object)EnumMemoryCapabilityFlags.CAN_BE_BYPASSED);
        return result;
    }

    public boolean isBypassedByDefault() {
        return this.isBypassedByDefault;
    }

    public EnumSet<EnumMemoryCapabilityFlags> getCapabilityFlags() {
        return this.capabilityFlags;
    }

    public void setCapabilityFlags(EnumSet<EnumMemoryCapabilityFlags> value) {
        this.capabilityFlags.clear();
        this.capabilityFlags.addAll(value);
    }

    public void addCapabilityFlags(EnumSet<EnumMemoryCapabilityFlags> value) {
        this.capabilityFlags.addAll(value);
    }

    public String getCheckBoxToolTipText() {
        return this.checkBoxToolTipText;
    }

    public void setCheckBoxToolTipText(String value) {
        this.checkBoxToolTipText = value;
    }

    public String getCheckBoxToolTipText_NoMemoryLevelVisibility() {
        return this.checkBoxToolTipText_NoMemoryLevelVisibility;
    }

    public void setCheckBoxToolTipText_NoMemoryLevelVisibility(String value) {
        this.checkBoxToolTipText_NoMemoryLevelVisibility = value;
    }

    public String getMemoryLevelToolTipText() {
        return this.memoryLevelToolTipText;
    }

    public void setMemoryLevelToolTipText(String value) {
        this.memoryLevelToolTipText = value;
    }

    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    public void setIsProgramMemory(boolean value) {
        this.isProgramMemory = value;
    }

    public boolean isDataMemory() {
        return this.isDataMemory;
    }

    public void setIsDataMemory(boolean value) {
        this.isDataMemory = value;
    }

    public boolean isIOSpace() {
        return this.isIOSpace;
    }

    public void setIsIOSpace(boolean value) {
        this.isIOSpace = value;
    }

    public boolean isExternalMemory() {
        return this.isExternalMemory;
    }

    public void setIsExternalMemory(boolean value) {
        this.isExternalMemory = value;
    }

    public boolean isSharedMemory() {
        return this.isSharedMemory;
    }

    public void setIsSharedMemory(boolean value) {
        this.isSharedMemory = value;
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public void setIsReserved(boolean value) {
        this.isReserved = value;
    }

    public boolean isROM() {
        return this.isROM;
    }

    public void setIsROM(boolean value) {
        this.isROM = value;
    }

    public boolean isPaged() {
        return this.isPaged;
    }

    public void setIsPaged(boolean value) {
        this.isPaged = value;
    }

    public boolean isDefaultPage() {
        return this.isDefaultPage;
    }

    public void setIsDefaultPage(boolean value) {
        this.isDefaultPage = value;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public void setDataWidth(int value) {
        this.dataWidth = value;
    }

    public String getDefaultDisplayAddressString() {
        return this.defaultDisplayAddressString;
    }

    public void setDefaultDisplayAddressString(String value) {
        this.defaultDisplayAddressString = value;
    }

    public boolean isVirtualMemorySupported() {
        return this.isVirtualMemorySupported;
    }

    public void setIsVirtualMemorySupported(boolean value) {
        this.isVirtualMemorySupported = value;
    }

    public boolean canBeProtected() {
        return this.canBeProtected;
    }

    public void setCanBeProtected(boolean value) {
        this.canBeProtected = value;
    }

    public boolean hasMemoryAccessIDs() {
        return this.hasMemoryAccessIDs;
    }

    public void setHasMemoryAccessIDs(boolean value) {
        this.hasMemoryAccessIDs = value;
    }

    public boolean canBeSecured() {
        return this.canBeSecured;
    }

    public void setCanBeSecured(boolean value) {
        this.canBeSecured = value;
    }

    public boolean isCacheTagRamDecodingSupported() {
        return this.isCacheTagRamDecodingSupported;
    }

    public void setIsCacheTagRamDecodingSupported(boolean value) {
        this.isCacheTagRamDecodingSupported = value;
    }

    public int getCacheLineSize() {
        return this.cacheLineSize;
    }

    public void setCacheLineSize(int value) {
        this.cacheLineSize = value;
        this.numBitsToRightShiftAdrsToGetSetId = 0;
    }

    public int getNumBitsToRightShiftAdrsToGetSetId() {
        if (this.numBitsToRightShiftAdrsToGetSetId == 0) {
            int bitTest = 1;
            ++this.numBitsToRightShiftAdrsToGetSetId;
            while ((bitTest & this.cacheLineSize) == 0) {
                ++this.numBitsToRightShiftAdrsToGetSetId;
                bitTest <<= 1;
            }
        }
        return this.numBitsToRightShiftAdrsToGetSetId;
    }

    public int getMaxNumCacheLines() {
        return this.maxNumCacheLines;
    }

    public int getNumCacheLines() {
        int result = 0;
        if (this.decoder_NumCacheLines != null) {
            result = (int)this.decoder_NumCacheLines.decode();
        }
        return result;
    }

    public RegisterDecoder getDecoder_NumCacheLines() {
        return this.decoder_NumCacheLines;
    }

    public long getCacheSizeInMAUs() {
        long result = 0L;
        if (this.decoder_CacheSize != null) {
            result = this.decoder_CacheSize.decode();
        }
        return result;
    }

    public RegisterDecoder getDecoder_CacheSize() {
        return this.decoder_CacheSize;
    }

    public boolean isCacheEnabled() {
        boolean result = false;
        if (this.decoder_IsCacheEnabled != null) {
            result = this.decoder_IsCacheEnabled.decode_Boolean();
        }
        return result;
    }

    public RegisterDecoder getDecoder_IsCacheEnabled() {
        return this.decoder_IsCacheEnabled;
    }

    public ICacheTagRamHandler getCacheTagRamHandler() {
        return this.cacheTagRamHandler;
    }

    public void setCacheTagRamHandler(ICacheTagRamHandler value) {
        this.cacheTagRamHandler = value;
    }

    public AddressMappedAttributeHandler getMemoryProtectionHandler() {
        return this.memoryProtectionHandler;
    }

    public void setMemoryProtectionHandler(AddressMappedAttributeHandler value) {
        this.memoryProtectionHandler = value;
    }

    public AddressMappedAttributeHandler getMemoryAccessIDHandler() {
        return this.memoryAccessIDHandler;
    }

    public void setMemoryAccessIDHandler(AddressMappedAttributeHandler value) {
        this.memoryAccessIDHandler = value;
    }

    public AddressMappedAttributeHandler getMemorySecurityHandler() {
        return this.memorySecurityHandler;
    }

    public void setMemorySecurityHandler(AddressMappedAttributeHandler value) {
        this.memorySecurityHandler = value;
    }

    public ArrayList<MemoryTypeDescriptor> getListOfAssociatedMemTypes() {
        return this.listOfAssociatedMemTypes;
    }

    private RegisterDecoder getRegDecoder(DeviceXMLReader.RegDecoderInfo decoderInfo, RegisterList listOfRegHandlers) {
        RegisterDecoder result = null;
        String regName = decoderInfo.regName;
        RegisterHandler regHandler = listOfRegHandlers.getRegisterHandler(regName);
        if (regHandler != null) {
            String decoderName = decoderInfo.decoderName;
            result = regHandler.getDecoder(decoderName);
        }
        return result;
    }

    public void setMmuBypassGtiInfo(MemLevelInfoHdlr memLevelInfoHdlr) {
        this.setIsVirtualMemorySupported(memLevelInfoHdlr.isMmuBypassSupported());
        if (memLevelInfoHdlr.isMmuBypassSupported()) {
            MemLevelInfoBit bit = memLevelInfoHdlr.getMemLevelInfoBitForMmuBypass();
            if (bit != null) {
                this.setGtiPhysicalMemAccessIdFlags(bit.getMemAccessIdParamBits());
            } else {
                this.setGtiPhysicalMemAccessIdFlags(0);
            }
        }
    }

    public String InitListOfVirtualMemoryViewStrings(ArrayList<String> listOfStrings) {
        if (listOfStrings != null) {
            listOfStrings.clear();
            listOfStrings.add("CPU View");
            if (this.isVirtualMemorySupported()) {
                listOfStrings.add("Physical Memory View");
                listOfStrings.add("CPU Memory View - Ignore Memory AdrsMap");
            }
        }
        return listOfStrings.get(0);
    }

    public long getStartAddressOfLineContainingAdrs(long adrs) {
        long mask = (long)this.getCacheLineSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return adrs & mask;
    }

    public long getEndAddressOfLineContainingAdrs(long adrs) {
        long lineSize = this.getCacheLineSize();
        long mask = lineSize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return (adrs & mask) + (lineSize - 1L);
    }

    public boolean isAdrsInThisMemoryType(long adrs) {
        boolean result = false;
        if (adrs >= this.getStartAddress() && adrs <= this.getEndAddress()) {
            result = true;
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && MemoryServerTrace.verboseTraceMinAdrs <= adrs && MemoryServerTrace.verboseTraceMaxAdrs >= adrs) {
            MemoryServerTrace.logVerbose("Memory Type: " + this.getName() + ", start adrs = 0x" + Long.toHexString(this.getStartAddress()) + ", end adrs = 0x" + Long.toHexString(this.getEndAddress()) + ", isCache = " + Boolean.toString(this.isCache) + ", Is " + Long.toHexString(adrs) + " in this memory = " + result, "MemoryTypeDescriptor.IsAdrsInThisMemoryType", null);
        }
        return result;
    }

    public boolean getBoolProperty(boolean isFixed, boolean fixedValue, RegisterDecoder decoder) {
        boolean result = fixedValue;
        long decoderResult = 0L;
        if (!isFixed && decoder != null) {
            decoderResult = decoder.decode();
            result = decoderResult != 0L;
        }
        return result;
    }

    public long getLongProperty(boolean isFixed, long fixedValue, RegisterDecoder decoder) {
        long result = fixedValue;
        if (!isFixed && decoder != null) {
            result = decoder.decode();
        }
        return result;
    }

    public EnumMemoryLevelIndex calculateMemoryLevelIndex() {
        EnumMemoryLevelIndex result = EnumMemoryLevelIndex.EXTERNAL;
        if (this.isReserved) {
            result = EnumMemoryLevelIndex.INACCESSIBLE;
        }
        if (this.isExternalMemory) {
            result = EnumMemoryLevelIndex.EXTERNAL;
        } else {
            switch (this.getHierarchyDepth()) {
                case 1: {
                    if (this.isProgramMemory && this.isDataMemory) {
                        result = EnumMemoryLevelIndex.L1;
                        break;
                    }
                    if (this.levelName.toUpperCase().equals("L1P") || this.isProgramMemory) {
                        result = EnumMemoryLevelIndex.L1P;
                        break;
                    }
                    result = EnumMemoryLevelIndex.L1D;
                    break;
                }
                case 2: {
                    result = EnumMemoryLevelIndex.L2;
                    if (!this.isSharedMemory()) break;
                    result = EnumMemoryLevelIndex.L2_SHARED;
                    break;
                }
                case 3: {
                    result = EnumMemoryLevelIndex.L3;
                    if (!this.isSharedMemory) break;
                    result = EnumMemoryLevelIndex.L3_SHARED;
                    break;
                }
                case 4: {
                    result = EnumMemoryLevelIndex.PHYSICAL;
                }
            }
        }
        return result;
    }

    public boolean isSameMemoryTypeAs(MemoryTypeDescriptor otherMemType) {
        boolean result = false;
        if (otherMemType != null && otherMemType.getHierarchyDepth() == this.hierarchyDepth && otherMemType.isCache() == this.isCache && otherMemType.isProgramMemory() == this.isProgramMemory && otherMemType.isDataMemory() == this.isDataMemory && otherMemType.isExternalMemory() == this.isExternalMemory && otherMemType.isSharedMemory() == this.isSharedMemory) {
            result = true;
        }
        return result;
    }

    public void importDriverParamInfo(MemoryTypeDescriptor otherMemType) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("Updating memType info with driver info: memType.memoryLevelIndex was " + (Object)((Object)this.memoryLevelIndex) + "->" + (Object)((Object)otherMemType.memoryLevelIndex) + ", cacheLineSize was " + this.cacheLineSize + "->" + otherMemType.cacheLineSize + ", capabilityFlags were " + this.getCapabilityFlags() + "->" + otherMemType.getCapabilityFlags() + ", gti mem_access_id param was " + this.getGtiMemHierarchyReadEnableFlags() + "->" + otherMemType.getGtiMemHierarchyReadEnableFlags(), "MemoryTypeDescriptor.importDriverParamInfo", null);
        }
        if (otherMemType.getCacheLineSize() > 0) {
            this.cacheLineSize = otherMemType.getCacheLineSize();
        }
        this.gtiPhysicalMemAccessIdFlags = otherMemType.getGtiPhysicalMemAccessIdFlags();
        this.gtiMemHierarchyReadEnableFlags = otherMemType.getGtiMemHierarchyReadEnableFlags();
        this.memoryLevelIndex = otherMemType.getMemoryLevelIndex();
        this.cacheLineSize = otherMemType.cacheLineSize;
        this.isSharedMemory = otherMemType.isSharedMemory;
        this.capabilityFlags.clear();
        this.capabilityFlags = otherMemType.getCapabilityFlags().clone();
    }

    public String toString() {
        String result = "MemType: " + this.getName() + "(LevelName = " + this.getLevelName() + "):" + " BackColorIndex=" + Integer.toString(this.getMemoryLevelIndex().getIndex()) + ", GTI Flags=0x" + Long.toHexString(this.getGtiMemHierarchyReadEnableFlags()) + ", memLevelEnableFlags = " + Integer.toHexString(this.getMemoryLevelEnableFlags()) + ", memLevelIndex = " + (Object)((Object)this.getMemoryLevelIndex()) + ", IsCache=" + Boolean.toString(this.isCache()) + ", IsCacheTagRamSupported=" + Boolean.toString(this.isCacheTagRamDecodingSupported()) + ", CanBeBypassed=" + Boolean.toString(this.canBeBypassed()) + ", IsExternal=" + Boolean.toString(this.isExternalMemory()) + ", IsData=" + Boolean.toString(this.isDataMemory()) + ", IsProgram=" + Boolean.toString(this.isProgramMemory()) + ", IsPaged=" + Boolean.toString(this.isPaged());
        return result;
    }

    @Override
    public int compareTo(MemoryTypeDescriptor memType) {
        int retval = 0;
        if (this.getHierarchyDepth() > memType.getHierarchyDepth()) {
            retval = 1;
        } else if (this.getHierarchyDepth() < memType.getHierarchyDepth()) {
            retval = -1;
        } else if (this.isCache() && !memType.isCache()) {
            retval = -1;
        } else if (this.id > memType.getId()) {
            retval = 1;
        } else if (this.id < memType.getId()) {
            retval = -1;
        }
        return retval;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            try {
                if (this.cacheTagRamHandler != null && !this.cacheTagRamHandler.isDisposed()) {
                    this.cacheTagRamHandler.dispose();
                }
                this.cacheTagRamHandler = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
    }

    public synchronized void initOnConnect(ICacheTagRamHandler ctrHdlr) {
        if (this.isCache && this.target != null && this.registerHdlrList != null && this.target.getInfo().getTargetTypeId() == EnumTargetType.EMULATOR && !this.target.isDisconnected()) {
            try {
                this.setCacheTagRamHandler(ctrHdlr);
                if (ctrHdlr == null || !this.cacheTagRamHandler.isCacheTagRamReadable()) {
                    this.isCacheTagRamDecodingSupported = false;
                    this.cacheTagRamHandler = null;
                } else {
                    this.isCacheTagRamDecodingSupported = true;
                }
            }
            catch (Exception e) {
                this.isCacheTagRamDecodingSupported = false;
                this.cacheTagRamHandler = null;
            }
            this.decoder_NumCacheLines = this.saved_decoder_NumCacheLines;
            this.decoder_CacheSize = this.saved_decoder_CacheSize;
            this.decoder_IsCacheEnabled = this.saved_decoder_IsCacheEnabled;
        }
    }
}

