/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.memoryinfoitems;

import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.AddressMappedAttributeHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.IListOfMemoryInfoItems;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.IMemoryInfoItem;
import com.ti.ccstudio.debug.memoryserver.memoryinfoitems.MemoryInfoItem;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.CacheLineDescriptor;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import java.util.Iterator;
import java.util.Vector;

public class ListOfMemoryInfoItems
implements Iterator<IMemoryInfoItem>,
Iterable<IMemoryInfoItem>,
IListOfMemoryInfoItems {
    private final Vector<IMemoryInfoItem> list = new Vector();
    private int currentIndex = -1;
    private long adrs;

    @Override
    public long getAdrs() {
        return this.adrs;
    }

    @Override
    public void setAdrs(long targetAdrs) {
        long unsignedAdrs = targetAdrs;
        if (targetAdrs < 0L) {
            unsignedAdrs = UInt63.getFromSignedLong(targetAdrs);
        }
        this.adrs = unsignedAdrs;
        this.list.clear();
    }

    public void storeMemAccessErrorInformation(MemoryTypeDescriptor memType, String errorMessage, long targetAdrs, MemoryRequestDescriptor req) {
        String errorDescription = "";
        String infoItemName = "Error";
        if (memType.getGtiMemHierarchyReadEnableFlags() != 0 && memType.getName().length() > 0) {
            infoItemName = "  " + memType.getName();
        }
        String infoItemValue = errorDescription = errorMessage;
        this.createInfoItem(infoItemName, infoItemValue, errorDescription);
    }

    public void storeMemLevelInfo(MemoryTypeDescriptor memType, String dataValue, boolean isTagRamDecodingEnabled, boolean cacheValidBit, boolean cacheLruBit, boolean cacheDirtyBit, long targetAdrs, EnumMemoryViews memoryView) {
        boolean isCache = memType.isCache();
        byte rank = (byte)memType.getHierarchyDepth();
        String memTypeName = memType.getName();
        if (memoryView == EnumMemoryViews.PHYSICAL_MEMORY_VIEW) {
            memTypeName = memType.getName().equalsIgnoreCase("CPU View") ? "Physical Memory View" : memTypeName + " (Physical Memory View)";
        }
        String description = "Value at address 0x" + Long.toHexString(this.getAdrs()) + " in " + memTypeName;
        this.createInfoItem(memTypeName, dataValue, description);
        if (isCache && isTagRamDecodingEnabled) {
            CacheLineDescriptor cacheLine = null;
            boolean isAdrsInCache = memType.getCacheTagRamHandler().isAdrsInCache(this.getAdrs());
            if (isAdrsInCache && memType.getCacheTagRamHandler().isLruSupported()) {
                cacheLine = memType.getCacheTagRamHandler().getCacheLineContainingAdrs(this.getAdrs(), false);
                boolean flagLruValue = false;
                String strLruText = "LRU (Least recently Used) is true if this cache line is the next to be evicted from cache.";
                String strLruValue = "";
                if (isAdrsInCache) {
                    strLruValue = "[LRU bits = " + Integer.toString(cacheLine.getLruValue().byteValue()) + "] ";
                    flagLruValue = memType.getCacheTagRamHandler().isCachedAdrsLeastRecentlyUsed(this.getAdrs());
                }
                rank = (byte)(rank + 128);
                this.createInfoItem(memType.getName() + " LRU", Boolean.toString(flagLruValue), strLruValue + strLruText);
            }
            if (isAdrsInCache && memType.getCacheTagRamHandler().isCacheDirtyBitAccessible()) {
                boolean flagDirtyBitValue = false;
                String strDirtyBitText = "Dirty bit is true if this cache line has been written into but external memory has not yet been updated.";
                String strDirtyBitValue = "";
                if (isAdrsInCache) {
                    strDirtyBitValue = "[Dirty bits =" + memType.getCacheTagRamHandler().getCacheLineContainingAdrs(this.getAdrs(), false).getDirtyBit().toString() + "] ";
                    flagDirtyBitValue = memType.getCacheTagRamHandler().isCacheLineDirty(this.getAdrs());
                }
                rank = (byte)(rank + 192);
                this.createInfoItem(memType.getName() + " Dirty bit", Boolean.toString(flagDirtyBitValue), strDirtyBitValue + strDirtyBitText);
            }
        }
    }

    public void storeAddressMappedAttrInfo(long adrs, MemoryTypeDescriptor memType, AddressMappedAttributeHandler attrHdlr) {
        String attrValue = attrHdlr.getSummaryText(adrs);
        if (attrValue.length() > 0) {
            this.createInfoItem(attrHdlr.getNameOfAttribute(), attrValue, attrHdlr.getDescription());
        }
    }

    public void createInfoItem(String itemName, String info, String strDescription) {
        MemoryInfoItem item = new MemoryInfoItem(itemName, info, strDescription);
        this.list.add(item);
    }

    @Override
    public void add(IMemoryInfoItem item) {
        this.list.add(item);
    }

    @Override
    public IMemoryInfoItem get(int index) {
        IMemoryInfoItem result = null;
        if (index < 0 || index >= this.list.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        result = this.list.get(index);
        return result;
    }

    @Override
    public Iterator<IMemoryInfoItem> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex < this.list.size() - 1) {
            result = true;
        }
        return result;
    }

    @Override
    public IMemoryInfoItem next() {
        IMemoryInfoItem result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.list.get(this.currentIndex);
        }
        return result;
    }

    @Override
    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.list.size()) {
            this.list.remove(this.currentIndex);
            if (this.currentIndex >= this.list.size()) {
                this.currentIndex = this.list.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public synchronized String toString() {
        String result = "";
        for (IMemoryInfoItem item : this.list) {
            result = result + String.format("%n%s: %s", item.getName(), item.getInfo());
        }
        return result;
    }
}

