/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.DataValueFormatter;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.TimeStamp;
import com.ti.debug.engine.IDspValue;

public class CExprRequestDescriptor
extends RequestDescriptorBaseClass {
    private long numTimesNotifyCalled = 0L;
    private Object owner;
    protected DataValueFormatter dataValueFormatter = null;
    private Object clientTagObject = null;
    private IMemoryRequestClient clientToNotifyOnRequestComplete = null;
    private long adrs = 0L;
    private String strCExpression;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private String requestQueueName;
    private RequestDescriptorQueue requestQueue = null;
    private long requestId = -1L;
    private short targetMemoryPageNumber = 0;
    private int targetMemoryLevelEnableFlags = 0;
    private EnumStringFormatStyle formatStyle = EnumStringFormatStyle.C_STYLE_HEX;
    private EnumDspValueType formatDataType = EnumDspValueType.DSP_INT;
    private short floatingPointQ = (short)15;
    private EnumMemoryRequestStates requestStatus = EnumMemoryRequestStates.CREATED;
    private TimeStamp timeStamp;
    public MemoryServerEvent onRelease;
    private DataValueFormatter resultHandler = null;
    private boolean discard = false;
    private IRecyclingFactory factory = null;
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private Object tagObject = null;
    private volatile boolean disposed = false;

    public CExprRequestDescriptor(TargetHandler targetHdlr) {
        this.dataValueFormatter = new DataValueFormatter(targetHdlr);
        this.timeStamp = new TimeStamp();
    }

    public Object getOwner() {
        return this.owner;
    }

    protected DataValueFormatter getDataValueFormatter() {
        return this.dataValueFormatter;
    }

    protected void setDataValueFormatter(DataValueFormatter value) {
        this.dataValueFormatter = value;
    }

    @Override
    public Object getClientTagObject() {
        return this.clientTagObject;
    }

    @Override
    public void setClientTagObject(Object value) {
        this.clientTagObject = value;
    }

    @Override
    public String getErrorInfoString() {
        return this.dataValueFormatter.getErrorString();
    }

    @Override
    public void setErrorInfoString(String value) {
        this.dataValueFormatter.setErrorString(value);
    }

    public IMemoryRequestClient getClientToNotifyOnRequestComplete() {
        return this.clientToNotifyOnRequestComplete;
    }

    public void setClientToNotifyOnRequestComplete(IMemoryRequestClient value) {
        this.clientToNotifyOnRequestComplete = value;
    }

    @Override
    public short getErrorCode() {
        short result = -1;
        if (this.dataValueFormatter != null) {
            result = this.dataValueFormatter.getErrorCode();
        }
        return result;
    }

    @Override
    public void setErrorCode(short value) {
        this.dataValueFormatter.setErrorCode(value);
    }

    @Override
    public void setErrorCode(EnumMemoryServerErrorCodes value) {
        this.dataValueFormatter.setErrorCode((short)value.getInt());
    }

    public long getAdrs() {
        return this.adrs;
    }

    public void setAdrs(long value) {
        this.adrs = value;
    }

    public String getStrCExpression() {
        return this.strCExpression;
    }

    public void setStrCExpression(String value) {
        this.strCExpression = value;
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    @Override
    public String getRequestQueueName() {
        return this.requestQueueName;
    }

    @Override
    public void setRequestQueueName(String value) {
        this.requestQueueName = value;
    }

    @Override
    public RequestDescriptorQueue getRequestQueue() {
        return this.requestQueue;
    }

    @Override
    public void setRequestQueue(RequestDescriptorQueue value) {
        this.requestQueue = value;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(long value) {
        this.requestId = value;
    }

    @Override
    public short getTargetMemoryPageNumber() {
        return this.targetMemoryPageNumber;
    }

    @Override
    public void setTargetMemoryPageNumber(short value) {
        this.targetMemoryPageNumber = value;
    }

    @Override
    public int getTargetMemoryLevelEnableFlags() {
        return this.targetMemoryLevelEnableFlags;
    }

    @Override
    public void setTargetMemoryLevelEnableFlags(int value) {
        this.targetMemoryLevelEnableFlags = value;
    }

    @Override
    public EnumMemoryRequestTypes getRequestType() {
        return EnumMemoryRequestTypes.C_EXPRESSION_EVALUATION;
    }

    @Override
    public void setRequestType(EnumMemoryRequestTypes value) {
        throw new Error(this.getRequestQueueName() + "[CExprRequest] configuration error - tried to change the RequestType to " + (Object)((Object)value));
    }

    public EnumStringFormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public void setFormatStyle(EnumStringFormatStyle value) {
        this.formatStyle = value;
    }

    public EnumDspValueType getFormatDataType() {
        return this.formatDataType;
    }

    public void setFormatDataType(EnumDspValueType value) {
        this.formatDataType = value;
    }

    @Override
    public boolean isFloatingPointDataType() {
        boolean result = false;
        switch (this.formatDataType) {
            case DSP_IEEE_FLOAT: 
            case DSP_IEEE_DOUBLE: 
            case DSP_FLOAT: {
                result = true;
            }
        }
        return result;
    }

    public short getFloatingPointQ() {
        return this.floatingPointQ;
    }

    public void setFloatingPointQ(short value) {
        this.floatingPointQ = value;
    }

    @Override
    public EnumMemoryRequestStates getRequestStatus() {
        return this.requestStatus;
    }

    @Override
    public void setRequestStatus(EnumMemoryRequestStates value) {
        this.requestStatus = value;
        if (this.requestStatus == EnumMemoryRequestStates.REQUEST_PENDING) {
            this.timeStamp.reset();
        } else if (EnumMemoryRequestStates.RECYCLED.compareTo(this.requestStatus) < 0) {
            this.timeStamp.completed();
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(this.toString(), "CExprEvalRequestDescriptor.RequestStatus", null);
        }
    }

    @Override
    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    protected void onReleased(EventArgs e) {
        if (this.onRelease != null) {
            this.onRelease.raise(e);
        }
    }

    public DataValueFormatter getResultHandler() {
        return this.resultHandler;
    }

    public void setResultHandler(DataValueFormatter value) {
        this.resultHandler = value;
    }

    public void config(Object ownerObj, IMemoryRequestClient clientToNotifyOnRequestComplete, CExprRequestDescriptor clientRequest) {
        if (this.getRequestId() == -1L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Not in queue when Config called - Config implements the target access request,\nso the descriptor must already be added to a queue to handle the response from the target reliably", "MemoryServer.CExprRequestDescriptor", null);
            }
            throw new Error("MemoryServer.CExprEvalRequestDescriptor - not in queue when config method called.\nFailing to add to queue will cause target access requests to lose sync with the target");
        }
        this.owner = ownerObj;
        this.strCExpression = clientRequest.strCExpression;
        this.setFormatStyle(clientRequest.getFormatStyle());
        this.setFormatDataType(clientRequest.getFormatDataType());
        this.adrs = clientRequest.getAdrs();
        this.memoryView = clientRequest.getMemoryView();
        this.floatingPointQ = clientRequest.getFloatingPointQ();
        this.targetMemoryPageNumber = clientRequest.getTargetMemoryPageNumber();
        this.setTargetMemoryLevelEnableFlags(clientRequest.getTargetMemoryLevelEnableFlags());
        this.requestStatus = EnumMemoryRequestStates.REQUEST_PENDING;
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = clientRequest;
        this.timeStamp.reset();
    }

    public void config(Object ownerObj, long address, String expressionToEvaluate, EnumMemoryViews memoryView, EnumStringFormatStyle StringFormat, EnumDspValueType dataType, short memoryPageNumber, short floatingPointQ, int memoryLevelEnableFlags, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObj) {
        if (this.getRequestId() == -1L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Not in queue when Config called - Config implements the target access request,\nso the descriptor must already be added to a queue to handle the response from the target reliably", "MemoryServer.CExprRequestDescriptor", null);
            }
            throw new Error("MemoryRequestDescriptor - not in queue when Config called - Config implements the target access request, so the descriptor must already be added to a queue to handle the response from the target reliably");
        }
        this.owner = ownerObj;
        this.adrs = address;
        this.strCExpression = expressionToEvaluate;
        this.formatStyle = StringFormat;
        this.formatDataType = dataType;
        this.floatingPointQ = floatingPointQ;
        this.memoryView = memoryView;
        this.targetMemoryPageNumber = memoryPageNumber;
        this.targetMemoryLevelEnableFlags = memoryLevelEnableFlags;
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = clientTagObj;
        if (this.resultHandler != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("MemoryServer: Possible memory leak detected - CExprEvalRequestDescriptor re-used with a non-null result handler Object, - dspValue not released", "MemoryServer.CExprRequestDescriptor", null);
        }
        this.timeStamp.reset();
        this.requestStatus = EnumMemoryRequestStates.REQUEST_PENDING;
    }

    public String getElapsedTimeInSeconds() {
        return this.timeStamp.getElapsedTime();
    }

    @Override
    public boolean getDiscard() {
        return this.discard;
    }

    @Override
    public void setDiscard(boolean value) {
        this.discard = value;
    }

    @Override
    public String getRequestIdStr() {
        String reqIdStr = "";
        if (this.requestQueue != null) {
            if (this.requestQueue.name.startsWith("Target")) {
                reqIdStr = "Server_";
            } else if (this.requestQueue.name.startsWith("Client")) {
                reqIdStr = "Client_";
            }
        }
        if (this.requestId < 0L) {
            long posReqId = -1L * this.requestId;
            reqIdStr = reqIdStr + "-" + Long.toHexString(posReqId);
        } else {
            reqIdStr = reqIdStr + Long.toHexString(this.requestId);
        }
        return reqIdStr;
    }

    public String toString() {
        String ownerStr = "null";
        String clientStr = "null";
        String reqIdStr = "-1";
        if (this.owner != null) {
            ownerStr = this.owner.toString();
        }
        if (this.clientToNotifyOnRequestComplete != null) {
            clientStr = this.clientToNotifyOnRequestComplete.toString();
        }
        if (this.requestId != -1L) {
            reqIdStr = "";
            if (this.requestQueue != null) {
                if (this.requestQueue.name.startsWith("Target")) {
                    reqIdStr = "Server";
                } else if (this.requestQueue.name.startsWith("Client")) {
                    reqIdStr = "Client";
                }
            }
            reqIdStr = reqIdStr + Long.toHexString(this.requestId);
        }
        String result = "CExprRequest:  RequestID " + this.getRequestIdStr() + " Status: " + this.requestStatus.toString() + " Queue: " + this.requestQueueName + "[MemRequest]" + " Owner: " + ownerStr + " ClientToNotify: " + clientStr;
        return result;
    }

    @Override
    public void release() {
        this.requestStatus = EnumMemoryRequestStates.REQUEST_OBJECT_RELEASED;
        if (this.resultHandler != null) {
            this.resultHandler.release();
        }
        this.resultHandler = null;
        this.strCExpression = "";
        this.adrs = 0L;
        this.discard = false;
        this.memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
        this.numTimesNotifyCalled = 0L;
        this.requestId = this.requestId > 0L ? -1L * this.requestId : -1L;
        this.clientToNotifyOnRequestComplete = null;
        this.requestQueueName = "NotInQueue";
        this.onReleased(EventArgs.Empty);
    }

    @Override
    public void releaseAndDequeue() {
        if (this.requestQueue != null) {
            this.requestQueue.deleteRequest(this, false);
        }
        this.release();
    }

    public void storeEvaluationResult(short errorCode, IDspValue dspValueObj) {
        this.setErrorCode(errorCode);
        this.dataValueFormatter.storeEvaluationResult(errorCode, dspValueObj);
    }

    public void moveEvaluationResult(CExprRequestDescriptor destinationRequest) {
        destinationRequest.setRequestStatus(this.requestStatus);
        destinationRequest.setErrorInfoString(this.getErrorInfoString());
        destinationRequest.storeEvaluationResult(this.getErrorCode(), this.dataValueFormatter.getDspValue());
        this.dataValueFormatter.setDspValue(null);
    }

    public void requestInfoFromTarget() {
        this.dataValueFormatter.requestInfoFromTarget(this.strCExpression);
    }

    public long getLong() {
        return this.dataValueFormatter.getLong(this.formatDataType, this.getFloatingPointQ());
    }

    public double getFloat() {
        return this.dataValueFormatter.getFloat();
    }

    public String getString() {
        return this.dataValueFormatter.getString(this.formatStyle, this.formatDataType, this.getFloatingPointQ());
    }

    public IDspValue getDspValue() {
        return this.dataValueFormatter.getDspValue();
    }

    @Override
    public void disableNotification() {
        this.clientToNotifyOnRequestComplete = null;
    }

    @Override
    public void notifyClient() {
        block7: {
            if (this.clientToNotifyOnRequestComplete != null) {
                ++this.numTimesNotifyCalled;
                if (this.numTimesNotifyCalled > 1L) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("CExprEval RequestDescriptor.NotifyClient called more than once. " + this.toString(), "CExprEvalRequestDescriptor.NotifyClient", null);
                    }
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("numTimesNotifyCalled = " + Long.toString(this.numTimesNotifyCalled), "CExprEvalRequestDescriptor.NotifyClient", null);
                }
                try {
                    this.clientToNotifyOnRequestComplete.onCExpressionEvaluationCompleteHandler(this);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block7;
                    MemoryServerTrace.logException(ex.getMessage(), "CExprEvalRequestDescriptor.NotifyClient", ex, null);
                }
            }
        }
    }

    public long getLongAdrs() {
        return this.dataValueFormatter.getLongAdrs();
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.requestId = Long.parseLong(value, 16);
    }

    @Override
    public String getFactoryObjectId() {
        return Long.toHexString(this.requestId);
    }

    @Override
    public String getFactoryObjectStatus() {
        return "ID: " + this.getFactoryObjectId() + " : " + this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    public Object getTagObject() {
        return this.tagObject;
    }

    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "MemoryRWHandler.dispose [" + this.factory.getName() + "]", null);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                this.release();
                this.dataValueFormatter.release();
                this.dataValueFormatter = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

