/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.MemoryRead;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.configoptions.IClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.enums.EnumAttributeTypeFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.util.TimeStamp;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import java.util.Date;
import java.util.EnumSet;

public class MemoryRequestDescriptor
extends RequestDescriptorBaseClass {
    private ITargetDeviceInfo targetInfo = null;
    private Object owner;
    private IDspMemory dspMemoryObj = null;
    private EnumStringFormatStyle formatStyle = EnumStringFormatStyle.C_STYLE_HEX;
    private EnumDspValueType formatDataType = EnumDspValueType.DSP_INT;
    private short floatingPointQ = (short)15;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private MemoryUpdateArgs memoryUpdateInfo;
    private int numTimesNotifyCalled = 0;
    private IMemoryRequestClient clientToNotifyOnRequestComplete = null;
    private long startAdrs = 0L;
    private long endAdrs;
    private short targetMemoryPageNumber = 0;
    private int targetMemoryLevelEnableFlags = 0;
    private EnumSet<EnumAttributeTypeFlags> targetMemoryAttributeFlags = EnumSet.noneOf(EnumAttributeTypeFlags.class);
    private EnumMemoryRequestTypes requestType = EnumMemoryRequestTypes.NONE;
    public long pendingWriteData = 0L;
    public String pendingWriteString = "";
    public double pendingWriteFloatingPointData = 0.0;
    private String requestQueueName;
    private RequestDescriptorQueue requestQueue = null;
    private long requestId = -1L;
    private EnumMemoryRequestStates requestStatus = EnumMemoryRequestStates.CREATED;
    private TimeStamp timeStamp;
    private Object clientTagObject = null;
    private String errorInfoString = null;
    private short errorCode = 0;
    private boolean discard = false;
    private IClientConfigOptions listOfClientConfigOptions = null;
    private Object tagObject = null;
    private IRecyclingFactory factory = null;
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;
    private MemoryRead readRequest;

    public MemoryRequestDescriptor(ITargetDeviceInfo targetDeviceInfo) {
        this.targetInfo = targetDeviceInfo;
        this.timeStamp = new TimeStamp();
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public IDspMemory getDspMemoryObj() {
        return this.dspMemoryObj;
    }

    public void setDspMemoryObj(IDspMemory value) {
        this.dspMemoryObj = value;
    }

    public EnumStringFormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public void setFormatStyle(EnumStringFormatStyle formatStyle) {
        this.formatStyle = formatStyle;
    }

    public EnumDspValueType getFormatDataType() {
        return this.formatDataType;
    }

    public void setFormatDataType(EnumDspValueType formatDataType) {
        this.formatDataType = formatDataType;
    }

    @Override
    public boolean isFloatingPointDataType() {
        boolean result = false;
        switch (this.getFormatDataType()) {
            case DSP_IEEE_FLOAT: 
            case DSP_IEEE_DOUBLE: 
            case DSP_FLOAT: {
                result = true;
            }
        }
        return result;
    }

    public short getFloatingPointQ() {
        return this.floatingPointQ;
    }

    public void setFloatingPointQ(short floatingPointQ) {
        this.floatingPointQ = floatingPointQ;
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    public void setMemoryUpdateInfo(MemoryUpdateArgs memoryUpdateInfo) {
        this.memoryUpdateInfo = memoryUpdateInfo;
    }

    public MemoryUpdateArgs getMemoryUpdateInfo() {
        return this.memoryUpdateInfo;
    }

    public int getNumTimesNotifyCalled() {
        return this.numTimesNotifyCalled;
    }

    public IMemoryRequestClient getClientToNotifyOnRequestComplete() {
        return this.clientToNotifyOnRequestComplete;
    }

    public void setClientToNotifyOnRequestComplete(IMemoryRequestClient value) {
        if (this.clientToNotifyOnRequestComplete != null && value == null && this.numTimesNotifyCalled == 0 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("***ClientToNotifyOnRequestComplete set to NULL (numTimesNotifyCalled == 0): " + this.toString(), "MemoryRequestDescriptor.ClientToNotifyOnRequestComplete", null);
        }
        if (value != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("ClientToNotifyOnRequestComplete set to " + value.toString(), "MemoryRequestDescriptor.ClientToNotifyOnRequestComplete", null);
        }
        this.clientToNotifyOnRequestComplete = value;
    }

    @Override
    public void disableNotification() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("***DisableNotification: " + this.toString(), "MemoryRequestDescriptor.DisableNotification", null);
        }
        this.clientToNotifyOnRequestComplete = null;
    }

    @Override
    public void notifyClient() {
        block6: {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                String traceMsg = "Id " + this.getRequestIdStr() + " NotifyClient() ";
                traceMsg = this.clientToNotifyOnRequestComplete != null ? traceMsg + " calling " + this.clientToNotifyOnRequestComplete.toString() : traceMsg + " onNotifyCallback == null";
                traceMsg = traceMsg + ": " + this.getRequestQueueName() + "[MemRequest]" + (Object)((Object)this.getRequestType()) + " " + this.requestStatus.toString() + " Id " + Long.toHexString(this.getRequestId());
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle(traceMsg, "MemoryRequestDescriptor.NotifyClient", null);
                }
            }
            if (this.clientToNotifyOnRequestComplete != null) {
                ++this.numTimesNotifyCalled;
                if (this.numTimesNotifyCalled > 1 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Error: Memory RequestDescriptor.NotifyClient called more than once (" + Long.toString(this.numTimesNotifyCalled) + " times). " + this.toString(), "MemoryRequestDescriptor.NotifyClient", null);
                }
                try {
                    this.clientToNotifyOnRequestComplete.onMemoryRequestCompleteHandler(this, this.getStartAdrs(), this.getLengthInMAUs());
                }
                catch (Exception exc) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block6;
                    MemoryServerTrace.logException("EXCEPTION: MemoryRequestDescriptor.notifyClient() within ClientToNotifyOnRequestComplete method\n" + this.toString(), "MemoryRequestDescriptor.notifyClient", exc, null);
                }
            }
        }
    }

    public long getStartAdrs() {
        return this.startAdrs;
    }

    public void setStartAdrs(long value) {
        this.startAdrs = value;
        if (this.startAdrs < 0L) {
            this.startAdrs = UInt63.getFromSignedLong(this.startAdrs);
        }
        if (this.endAdrs < this.startAdrs) {
            this.endAdrs = this.startAdrs;
        }
    }

    public long getEndAdrs() {
        return this.endAdrs;
    }

    public void setEndAdrs(long value) {
        this.endAdrs = value;
        if (this.endAdrs < 0L) {
            this.endAdrs = UInt63.getFromSignedLong(this.endAdrs);
        }
        if (this.startAdrs > this.endAdrs) {
            this.startAdrs = this.endAdrs;
        }
    }

    public long getLengthInMAUs() {
        return this.targetInfo.getNumMausInAddressRange(this.startAdrs, this.endAdrs, this.targetMemoryPageNumber);
    }

    public void setLengthInMAUs(long value) {
        this.endAdrs = this.targetInfo.getEndAdrsInRange(this.startAdrs, value, this.targetMemoryPageNumber);
    }

    @Override
    public short getTargetMemoryPageNumber() {
        return this.targetMemoryPageNumber;
    }

    @Override
    public void setTargetMemoryPageNumber(short value) {
        this.targetMemoryPageNumber = value;
    }

    @Override
    public int getTargetMemoryLevelEnableFlags() {
        return this.targetMemoryLevelEnableFlags;
    }

    @Override
    public void setTargetMemoryLevelEnableFlags(int value) {
        this.targetMemoryLevelEnableFlags = value;
    }

    public EnumSet<EnumAttributeTypeFlags> getTargetMemoryAttributeFlags() {
        this.targetMemoryAttributeFlags = this.listOfClientConfigOptions != null ? this.listOfClientConfigOptions.getAttributeFlags() : EnumSet.of(EnumAttributeTypeFlags.LOCATION_IN_MEMORY_HIERARCHY);
        return this.targetMemoryAttributeFlags;
    }

    @Override
    public EnumMemoryRequestTypes getRequestType() {
        return this.requestType;
    }

    @Override
    public void setRequestType(EnumMemoryRequestTypes value) {
        this.requestType = value;
    }

    @Override
    public String getRequestQueueName() {
        return this.requestQueueName;
    }

    @Override
    public void setRequestQueueName(String value) {
        this.requestQueueName = value;
    }

    @Override
    public RequestDescriptorQueue getRequestQueue() {
        return this.requestQueue;
    }

    @Override
    public void setRequestQueue(RequestDescriptorQueue value) {
        this.requestQueue = value;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(long value) {
        this.requestId = value;
    }

    @Override
    public EnumMemoryRequestStates getRequestStatus() {
        return this.requestStatus;
    }

    @Override
    public void setRequestStatus(EnumMemoryRequestStates value) {
        this.requestStatus = value;
        if (this.requestStatus == EnumMemoryRequestStates.REQUEST_PENDING) {
            this.timeStamp.reset();
        } else if (this.requestStatus.compareTo(EnumMemoryRequestStates.RECYCLED) > 0) {
            this.timeStamp.completed();
        }
        if (this.getRequestId() >= 0L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle(this.toString(), "MemoryRequestDescriptor.RequestStatus", null);
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE) && this.getStartAdrs() <= MemoryServerTrace.verboseTraceMaxAdrs && this.getEndAdrs() >= MemoryServerTrace.verboseTraceMinAdrs) {
            MemoryServerTrace.logLifecycle(this.toString(), "MemoryRequestDescriptor.RequestStatus", null);
        }
    }

    @Override
    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Object getClientTagObject() {
        return this.clientTagObject;
    }

    @Override
    public void setClientTagObject(Object value) {
        this.clientTagObject = value;
    }

    @Override
    public String getErrorInfoString() {
        return this.errorInfoString;
    }

    @Override
    public void setErrorInfoString(String value) {
        this.errorInfoString = value;
    }

    @Override
    public short getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(short value) {
        this.errorCode = value;
    }

    @Override
    public void setErrorCode(EnumMemoryServerErrorCodes value) {
        this.errorCode = (short)value.getInt();
    }

    @Override
    public boolean getDiscard() {
        return this.discard;
    }

    @Override
    public void setDiscard(boolean value) {
        this.discard = value;
    }

    public IClientConfigOptions getClientConfigOptions() {
        return this.listOfClientConfigOptions;
    }

    public void setClientConfigOptions(IClientConfigOptions value) {
        this.listOfClientConfigOptions = value;
    }

    public void config(Object ownerObj, IMemoryRequestClient clientToNotifyOnRequestComplete, MemoryRequestDescriptor clientRequest) {
        this.setOwner(ownerObj);
        this.setRequestType(clientRequest.getRequestType());
        this.setFormatStyle(clientRequest.getFormatStyle());
        this.setFormatDataType(clientRequest.getFormatDataType());
        this.setStartAdrs(clientRequest.getStartAdrs());
        this.setLengthInMAUs(clientRequest.getLengthInMAUs());
        this.setMemoryView(clientRequest.getMemoryView());
        this.setTargetMemoryPageNumber(clientRequest.getTargetMemoryPageNumber());
        this.setTargetMemoryLevelEnableFlags(clientRequest.getTargetMemoryLevelEnableFlags());
        this.setClientConfigOptions(clientRequest.getClientConfigOptions());
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = clientRequest;
        this.timeStamp.reset();
        this.setRequestStatus(EnumMemoryRequestStates.REQUEST_PENDING);
    }

    public void config(Object ownerObj, EnumMemoryRequestTypes typeOfRequest, EnumStringFormatStyle StringFormat, EnumDspValueType dataType, short memoryPageNumber, int memoryLevelEnableFlags, short floatingPointQFactor, IClientConfigOptions listOfClientConfigOptions, long startAdrs, long numMAUsToRead, EnumMemoryViews memoryView, IMemoryRequestClient clientToNotifyOnRequestComplete, Object clientTagObj) {
        this.setOwner(ownerObj);
        this.requestType = typeOfRequest;
        this.setFormatStyle(StringFormat);
        this.setFormatDataType(dataType);
        this.setStartAdrs(startAdrs);
        this.setLengthInMAUs(numMAUsToRead);
        this.setMemoryView(memoryView);
        this.targetMemoryPageNumber = memoryPageNumber;
        this.targetMemoryLevelEnableFlags = memoryLevelEnableFlags;
        this.setFloatingPointQ(floatingPointQFactor);
        this.requestStatus = EnumMemoryRequestStates.REQUEST_PENDING;
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = clientTagObj;
        this.listOfClientConfigOptions = listOfClientConfigOptions;
        this.setErrorInfoString("OK");
        this.setErrorCode((short)0);
        this.timeStamp.reset();
    }

    public String getElapsedTimeInSeconds() {
        return this.timeStamp.getElapsedTime();
    }

    @Override
    public String getRequestIdStr() {
        String reqIdStr = "";
        if (this.requestQueue != null) {
            if (this.getRequestQueue().name.startsWith("Target")) {
                reqIdStr = "Server_";
            } else if (this.getRequestQueue().name.startsWith("Client")) {
                reqIdStr = "Client_";
            }
        }
        if (this.requestId < 0L) {
            long posReqId = -1L * this.requestId;
            reqIdStr = reqIdStr + "-" + Long.toHexString(posReqId);
        } else {
            reqIdStr = reqIdStr + Long.toHexString(this.getRequestId());
        }
        return reqIdStr;
    }

    public String toString() {
        String ownerStr = "null";
        String clientStr = "null";
        if (this.getOwner() != null) {
            ownerStr = this.getOwner().toString();
        }
        if (this.clientToNotifyOnRequestComplete != null) {
            clientStr = this.clientToNotifyOnRequestComplete.toString();
        }
        String strRequestType = "null request Type!";
        if (this.requestType != null) {
            strRequestType = this.requestType.toString();
        }
        String result = "MemRequest(" + strRequestType + "): Id " + this.getRequestIdStr() + " Adrs: 0x" + Long.toHexString(this.getStartAdrs()) + " Page: " + Integer.toString(this.targetMemoryPageNumber) + " MemoryView: " + this.getMemoryView().toString() + " #MAUs: 0x" + Long.toHexString(this.getLengthInMAUs()) + " Status: " + this.requestStatus.toString() + " Queue: " + this.requestQueueName + "[MemRequest]" + " Owner: " + ownerStr + " ClientToNotify: " + clientStr;
        result = this.requestStatus.ordinal() <= EnumMemoryRequestStates.RECYCLED.ordinal() ? result + ", Time = " + new Date().getTime() : result + ", DataType=" + this.getFormatDataType().toString() + ", FormatStyle=" + this.getFormatStyle().toString() + ", MemoryLevelEnableFlags=0x" + Long.toHexString(this.targetMemoryLevelEnableFlags) + ", ElapsedTime=" + this.getElapsedTimeInSeconds() + "s";
        return result;
    }

    public String getAdrsRangeSummary() {
        long endAdrs = this.getStartAdrs() + this.getLengthInMAUs() - 1L;
        String result = "Adrs: 0x" + Long.toHexString(this.getStartAdrs()) + " to 0x" + Long.toHexString(endAdrs);
        return result;
    }

    public void StoreEvaluationResult(EnumMemoryRequestStates reqStatus, short errorCode, String strErrorInfo) {
        this.setRequestStatus(reqStatus);
        this.setErrorCode(errorCode);
        this.setErrorInfoString(strErrorInfo);
    }

    public void MoveEvaluationResult(MemoryRequestDescriptor destinationRequest) {
        destinationRequest.StoreEvaluationResult(this.getRequestStatus(), this.getErrorCode(), this.getErrorInfoString());
    }

    public boolean compare(Object dspMemoryObj, MemoryUpdateArgs args) {
        boolean result = false;
        if (this.getStartAdrs() == args.getAddress() && this.getLengthInMAUs() == (long)args.getNumMAUs()) {
            if (dspMemoryObj instanceof IDspRegister || dspMemoryObj instanceof IDspRegister) {
                result = true;
            } else if (this.getTargetMemoryPageNumber() == args.getPage()) {
                result = true;
            }
        }
        return result;
    }

    public Object getTagObject() {
        return this.tagObject;
    }

    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.requestId = Long.parseLong(value, 16);
    }

    @Override
    public String getFactoryObjectId() {
        return Long.toHexString(this.requestId);
    }

    @Override
    public String getFactoryObjectStatus() {
        return "ID: " + this.getFactoryObjectId() + " : " + this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void release() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("Releasing " + this.toString(), "MemoryRequestDescriptor.Release", null);
        }
        if (this.dspMemoryObj != null && !this.dspMemoryObj.isDisposed()) {
            this.dspMemoryObj.dispose();
        }
        if (this.requestQueue != null) {
            this.requestQueue.deleteRequest(this, false);
        }
        this.setRequestStatus(EnumMemoryRequestStates.REQUEST_OBJECT_RELEASED);
        if (this.numTimesNotifyCalled == 0) {
            this.notifyClient();
        }
        this.numTimesNotifyCalled = 0;
        if (this.getRequestId() > 0L) {
            this.requestId = -1L * this.requestId;
        } else {
            this.setRequestId(-1L);
        }
        this.clientToNotifyOnRequestComplete = null;
        this.listOfClientConfigOptions = null;
        this.setOwner(null);
        this.errorCode = 0;
        this.discard = false;
        this.setMemoryView(EnumMemoryViews.CPU_MEMORY_VIEW);
        this.pendingWriteData = 0L;
        this.pendingWriteString = "";
        this.setErrorInfoString("Memory Server Request not configured.");
        this.requestQueueName = "NotInQueue";
        this.clientTagObject = null;
        this.setStartAdrs(0L);
        this.setLengthInMAUs(0L);
        if (this.dspMemoryObj != null) {
            if (this.requestType == EnumMemoryRequestTypes.WRITE && !this.dspMemoryObj.isDisposed()) {
                this.dspMemoryObj.dispose();
            }
            this.dspMemoryObj = null;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle(this.toString() + ": released DspMemory COM Object", "MemoryRequestDescriptor.Release", null);
            }
        }
        this.onReleased();
    }

    @Override
    public void releaseAndDequeue() {
        this.release();
    }

    protected void onReleased() {
        if (this.factory != null) {
            this.factory.onRelease(this);
        }
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            String factoryName = "null";
            if (factory != null) {
                factoryName = factory.getName();
            }
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller  that was not the factory that created it [should be " + this.factory.getName() + ", was " + factoryName + "]", "MemoryRequestDescriptor.dispose", null);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (this.disposed || disposing) {
            // empty if block
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public MemoryRead getReadRequest() {
        return this.readRequest;
    }

    public void setReadRequest(MemoryRead readRequest) {
        this.readRequest = readRequest;
    }
}

