/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.debug.engine.IDspMemory;

public class MemoryUpdateArgs
extends EventArgs
implements IDisposable {
    private long address = 0L;
    private int numMAUs = 0;
    private short page = 0;
    private boolean isSelf = false;
    private boolean aborted = false;
    private Object dspMemoryObj;
    private volatile boolean isDisposed = false;

    public long getAddress() {
        return UInt63.getFromSignedLong(this.address);
    }

    public int getNumMAUs() {
        return this.numMAUs;
    }

    public short getPage() {
        return this.page;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Object getDspMemoryObj() {
        return this.dspMemoryObj;
    }

    public void setDspMemoryObj(Object value) {
        this.dspMemoryObj = value;
    }

    public MemoryUpdateArgs(short page, long address, int lengthInMAUs, boolean isSelf, boolean aborted, Object memObj) {
        this.page = page;
        this.address = address < 0L ? UInt63.getFromSignedLong(address) : address;
        this.numMAUs = lengthInMAUs;
        this.isSelf = isSelf;
        this.aborted = aborted;
        this.dspMemoryObj = memObj;
    }

    public String toString() {
        String result = "Adrs=0x" + Long.toHexString(this.address) + ", numMAUs=0x" + Long.toHexString(this.numMAUs) + ", page=" + Integer.toString(this.page) + ", aborted=" + Boolean.toString(this.aborted) + ", isSelf=" + Boolean.toString(this.isSelf);
        if (this.dspMemoryObj == null) {
            result = result + ", dspMemoryObj == null";
        }
        return result;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!((IDspMemory)this.dspMemoryObj).isDisposed()) {
            ((IDspMemory)this.dspMemoryObj).dispose();
        }
        this.dspMemoryObj = null;
        this.isDisposed = true;
    }
}

