/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.configoptions.IClientConfigOptions;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryServerErrorCodes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumRegisterRequestType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.RegisterUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRegisterRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.util.TimeStamp;
import com.ti.debug.engine.IDspRegister;
import java.util.Date;
import java.util.EventObject;

public class RegisterRequestDescriptor
extends RequestDescriptorBaseClass {
    private Object owner;
    private IDspRegister dspRegisterObj = null;
    private EnumStringFormatStyle formatStyle = EnumStringFormatStyle.C_STYLE_HEX;
    private EnumDspValueType formatDataType = EnumDspValueType.DSP_INT;
    private RegisterUpdateArgs registerUpdateInfo;
    private int numTimesNotifyCalled = 0;
    private IRegisterRequestClient clientToNotifyOnRequestComplete = null;
    private int lengthInMAUs = 0;
    private long startAdrs = 0L;
    private long idOfRegister = 0L;
    private String nameOfRegister = "unkonwn";
    private short targetMemoryPageNumber = 0;
    private int targetMemoryLevelEnableFlags = 0;
    private EnumRegisterRequestType registerRequestType = EnumRegisterRequestType.READ_REGISTER;
    public long pendingWriteData = 0L;
    public String pendingWriteString = "";
    public double pendingWriteFloatingPointData = 0.0;
    private String requestQueueName;
    private RequestDescriptorQueue requestQueue = null;
    private long requestId = -1L;
    private EnumMemoryRequestStates requestStatus = EnumMemoryRequestStates.CREATED;
    private TimeStamp timeStamp;
    private Object clientTagObject = null;
    private String errorInfoString = null;
    private short errorCode = 0;
    private boolean discard = false;
    private IClientConfigOptions listOfClientConfigOptions = null;
    private Object tagObject = null;
    private IRecyclingFactory factory = null;
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;

    public RegisterRequestDescriptor(ITargetDeviceInfo targetDeviceInfo) {
        this.timeStamp = new TimeStamp();
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public IDspRegister getDspRegisterObj() {
        return this.dspRegisterObj;
    }

    public void setDspRegisterObj(IDspRegister value) {
        this.dspRegisterObj = value;
    }

    public EnumStringFormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public void setFormatStyle(EnumStringFormatStyle formatStyle) {
        this.formatStyle = formatStyle;
    }

    public EnumDspValueType getFormatDataType() {
        return this.formatDataType;
    }

    public void setFormatDataType(EnumDspValueType formatDataType) {
        this.formatDataType = formatDataType;
    }

    @Override
    public boolean isFloatingPointDataType() {
        boolean result = false;
        switch (this.getFormatDataType()) {
            case DSP_IEEE_FLOAT: 
            case DSP_IEEE_DOUBLE: 
            case DSP_FLOAT: {
                result = true;
            }
        }
        return result;
    }

    public void setRegisterUpdateInfo(RegisterUpdateArgs value) {
        this.registerUpdateInfo = value;
    }

    public RegisterUpdateArgs getRegisterUpdateInfo() {
        return this.registerUpdateInfo;
    }

    public int getNumTimesNotifyCalled() {
        return this.numTimesNotifyCalled;
    }

    public IRegisterRequestClient getClientToNotifyOnRequestComplete() {
        return this.clientToNotifyOnRequestComplete;
    }

    public void setClientToNotifyOnRequestComplete(IRegisterRequestClient value) {
        if (this.clientToNotifyOnRequestComplete != null && value == null && this.numTimesNotifyCalled == 0 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("***ClientToNotifyOnRequestComplete set to NULL (numTimesNotifyCalled == 0): " + this.toString(), "RegisterRequestDescriptor.ClientToNotifyOnRequestComplete", null);
        }
        if (value != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("ClientToNotifyOnRequestComplete set to " + value.toString(), "RegisterRequestDescriptor.ClientToNotifyOnRequestComplete", null);
        }
        this.clientToNotifyOnRequestComplete = value;
    }

    @Override
    public void disableNotification() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("***DisableNotification: " + this.toString(), "RegisterRequestDescriptor.DisableNotification", null);
        }
        this.clientToNotifyOnRequestComplete = null;
    }

    @Override
    public void notifyClient() {
        block6: {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                String traceMsg = "Id " + this.getRequestIdStr() + " NotifyClient() ";
                traceMsg = this.clientToNotifyOnRequestComplete != null ? traceMsg + " calling " + this.clientToNotifyOnRequestComplete.toString() : traceMsg + " onNotifyCallback == null";
                traceMsg = traceMsg + ": " + this.getRequestQueueName() + "[RegisterRequest]" + (Object)((Object)this.getRequestType()) + " " + this.requestStatus.toString() + " Id " + Long.toHexString(this.getRequestId());
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle(traceMsg, "RegisterRequestDescriptor.NotifyClient", null);
                }
            }
            if (this.clientToNotifyOnRequestComplete != null) {
                ++this.numTimesNotifyCalled;
                if (this.numTimesNotifyCalled > 1 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Error: Memory RequestDescriptor.NotifyClient called more than once (" + Long.toString(this.numTimesNotifyCalled) + " times). " + this.toString(), "RegisterRequestDescriptor.NotifyClient", null);
                }
                try {
                    this.clientToNotifyOnRequestComplete.onRegisterRequestCompleteHandler(this);
                }
                catch (Exception exc) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block6;
                    MemoryServerTrace.logException("EXCEPTION: RegisterRequestDescriptor.notifyClient() within ClientToNotifyOnRequestComplete method\n" + this.toString(), "RegisterRequestDescriptor.notifyClient", exc, null);
                }
            }
        }
    }

    public int getLengthInMAUs() {
        return this.lengthInMAUs;
    }

    public void setLengthInMAUs(int value) {
        this.lengthInMAUs = value;
    }

    public long getStartAdrs() {
        return this.startAdrs;
    }

    public void setStartAdrs(long value) {
        this.startAdrs = value;
    }

    public long getIdOfRegister() {
        return this.idOfRegister;
    }

    public void setIdOfRegister(long value) {
        this.idOfRegister = value;
    }

    public String getNameOfRegister() {
        return this.nameOfRegister;
    }

    public void setNameOfRegister(String value) {
        this.nameOfRegister = value;
    }

    @Override
    public short getTargetMemoryPageNumber() {
        return this.targetMemoryPageNumber;
    }

    @Override
    public void setTargetMemoryPageNumber(short value) {
        this.targetMemoryPageNumber = value;
    }

    @Override
    public int getTargetMemoryLevelEnableFlags() {
        return this.targetMemoryLevelEnableFlags;
    }

    @Override
    public void setTargetMemoryLevelEnableFlags(int value) {
        this.targetMemoryLevelEnableFlags = value;
    }

    @Override
    public EnumMemoryRequestTypes getRequestType() {
        EnumMemoryRequestTypes result = EnumMemoryRequestTypes.NONE;
        switch (this.registerRequestType) {
            case READ_REGISTER: {
                result = EnumMemoryRequestTypes.READ;
                break;
            }
            case WRITE_REGISTER: {
                result = EnumMemoryRequestTypes.WRITE;
            }
        }
        return result;
    }

    @Override
    public void setRequestType(EnumMemoryRequestTypes value) {
        switch (value) {
            case READ: {
                this.registerRequestType = EnumRegisterRequestType.READ_REGISTER;
            }
            case WRITE: {
                this.registerRequestType = EnumRegisterRequestType.WRITE_REGISTER;
            }
        }
    }

    public EnumRegisterRequestType getRegisterRequestType() {
        return this.registerRequestType;
    }

    public void setRegisterRequestType(EnumRegisterRequestType value) {
        this.registerRequestType = value;
    }

    @Override
    public String getRequestQueueName() {
        return this.requestQueueName;
    }

    @Override
    public void setRequestQueueName(String value) {
        this.requestQueueName = value;
    }

    @Override
    public RequestDescriptorQueue getRequestQueue() {
        return this.requestQueue;
    }

    @Override
    public void setRequestQueue(RequestDescriptorQueue value) {
        this.requestQueue = value;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(long value) {
        this.requestId = value;
    }

    @Override
    public EnumMemoryRequestStates getRequestStatus() {
        return this.requestStatus;
    }

    @Override
    public void setRequestStatus(EnumMemoryRequestStates value) {
        this.requestStatus = value;
        if (this.requestStatus == EnumMemoryRequestStates.REQUEST_PENDING) {
            this.timeStamp.reset();
        } else if (this.requestStatus.compareTo(EnumMemoryRequestStates.RECYCLED) > 0) {
            this.timeStamp.completed();
        }
        if (this.getRequestId() >= 0L && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle(this.toString(), "RegisterRequestDescriptor.RequestStatus", null);
        }
    }

    @Override
    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Object getClientTagObject() {
        return this.clientTagObject;
    }

    @Override
    public void setClientTagObject(Object value) {
        this.clientTagObject = value;
    }

    @Override
    public String getErrorInfoString() {
        return this.errorInfoString;
    }

    @Override
    public void setErrorInfoString(String value) {
        this.errorInfoString = value;
    }

    @Override
    public short getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(EnumMemoryServerErrorCodes value) {
        this.errorCode = (short)value.getInt();
    }

    @Override
    public void setErrorCode(short value) {
        this.errorCode = value;
    }

    @Override
    public boolean getDiscard() {
        return this.discard;
    }

    @Override
    public void setDiscard(boolean value) {
        this.discard = value;
    }

    public IClientConfigOptions getClientConfigOptions() {
        return this.listOfClientConfigOptions;
    }

    public void setClientConfigOptions(IClientConfigOptions value) {
        this.listOfClientConfigOptions = value;
    }

    public void config(Object ownerObj, IRegisterRequestClient clientToNotifyOnRequestComplete, RegisterRequestDescriptor requestToCopy) {
        this.setOwner(ownerObj);
        this.setRequestType(requestToCopy.getRequestType());
        this.setFormatStyle(requestToCopy.getFormatStyle());
        this.setFormatDataType(requestToCopy.getFormatDataType());
        this.setDspRegisterObj(requestToCopy.getDspRegisterObj());
        this.setNameOfRegister(requestToCopy.getNameOfRegister());
        this.setStartAdrs(requestToCopy.getStartAdrs());
        this.setIdOfRegister(requestToCopy.getIdOfRegister());
        this.setLengthInMAUs(requestToCopy.getLengthInMAUs());
        this.setMemoryView(requestToCopy.getMemoryView());
        this.setTargetMemoryPageNumber(requestToCopy.getTargetMemoryPageNumber());
        this.setTargetMemoryLevelEnableFlags(requestToCopy.getTargetMemoryLevelEnableFlags());
        this.setClientConfigOptions(requestToCopy.getClientConfigOptions());
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = requestToCopy;
        this.timeStamp.reset();
        this.setRequestStatus(EnumMemoryRequestStates.REQUEST_PENDING);
    }

    public void config(Object ownerObj, IDspRegister dspRegisterObj, long addressOfRegister, int numMAUs, int idOfRegister, EnumRegisterRequestType typeOfRequest, EnumStringFormatStyle StringFormat, EnumDspValueType dataType, short memoryPageNumber, int memoryLevelEnableFlags, short floatingPointQFactor, IClientConfigOptions listOfClientConfigOptions, String registerName, EnumMemoryViews memoryView, IRegisterRequestClient clientToNotifyOnRequestComplete, Object clientTagObj) {
        if (this.getRequestId() == -1L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Not in queue when Config called - Config implements the target access request,\nso the descriptor must already be added to a queue to handle the response from the target reliably", "RegisterRequestDescriptor.config", null);
            }
            throw new Error("MemoryServer.RegisterRequestDescriptor - not in queue when config method called.\nThe config method implements the target access request, so the descriptor must already be added to a queue to handle the response from the target reliably");
        }
        this.setOwner(ownerObj);
        this.setRegisterRequestType(typeOfRequest);
        this.setFormatStyle(StringFormat);
        this.setFormatDataType(dataType);
        this.setNameOfRegister(registerName);
        this.setIdOfRegister(idOfRegister);
        this.setLengthInMAUs(numMAUs);
        this.setStartAdrs(addressOfRegister);
        this.setDspRegisterObj(dspRegisterObj);
        this.setMemoryView(memoryView);
        this.targetMemoryPageNumber = memoryPageNumber;
        this.targetMemoryLevelEnableFlags = memoryLevelEnableFlags;
        this.requestStatus = EnumMemoryRequestStates.REQUEST_PENDING;
        this.clientToNotifyOnRequestComplete = clientToNotifyOnRequestComplete;
        this.clientTagObject = clientTagObj;
        this.listOfClientConfigOptions = listOfClientConfigOptions;
        this.setErrorInfoString("OK");
        this.setErrorCode((short)0);
        this.timeStamp.reset();
    }

    public String getElapsedTimeInSeconds() {
        return this.timeStamp.getElapsedTime();
    }

    @Override
    public String getRequestIdStr() {
        String reqIdStr = "";
        if (this.requestQueue != null) {
            if (this.getRequestQueue().name.startsWith("Target")) {
                reqIdStr = "Server_";
            } else if (this.getRequestQueue().name.startsWith("Client")) {
                reqIdStr = "Client_";
            }
        }
        if (this.requestId < 0L) {
            long posReqId = -1L * this.requestId;
            reqIdStr = reqIdStr + "-" + Long.toHexString(posReqId);
        } else {
            reqIdStr = reqIdStr + Long.toHexString(this.getRequestId());
        }
        return reqIdStr;
    }

    public String toString() {
        String ownerStr = "null";
        String clientStr = "null";
        if (this.getOwner() != null) {
            ownerStr = this.getOwner().toString();
        }
        if (this.clientToNotifyOnRequestComplete != null) {
            clientStr = this.clientToNotifyOnRequestComplete.toString();
        }
        String strRequestType = "null request Type!";
        if (this.registerRequestType != null) {
            strRequestType = this.registerRequestType.toString();
        }
        String result = "MemRequest(" + strRequestType + "): Id " + this.getRequestIdStr() + " RegisterName: " + this.getNameOfRegister() + " RegisterID: " + Long.toString(this.getIdOfRegister()) + " RegisterAddress: 0x" + Long.toHexString(this.getStartAdrs()) + " NumMAUs: " + Integer.toString(this.getLengthInMAUs()) + " Status: " + this.requestStatus.toString() + " Queue: " + this.requestQueueName + "[MemRequest]" + " Owner: " + ownerStr + " ClientToNotify: " + clientStr;
        result = this.requestStatus.ordinal() <= EnumMemoryRequestStates.RECYCLED.ordinal() ? result + ", Time = " + new Date().getTime() : result + ", DataType=" + this.getFormatDataType().toString() + ", FormatStyle=" + this.getFormatStyle().toString() + ", MemoryLevelEnableFlags=0x" + Long.toHexString(this.targetMemoryLevelEnableFlags) + ", ElapsedTime=" + this.getElapsedTimeInSeconds() + "s";
        return result;
    }

    public void StoreEvaluationResult(EnumMemoryRequestStates reqStatus, short errorCode, String strErrorInfo) {
        this.setRequestStatus(reqStatus);
        this.setErrorCode(errorCode);
        this.setErrorInfoString(strErrorInfo);
    }

    public void MoveEvaluationResult(RegisterRequestDescriptor destinationRequest) {
        destinationRequest.StoreEvaluationResult(this.getRequestStatus(), this.getErrorCode(), this.getErrorInfoString());
    }

    public boolean compare(EventObject sender, RegisterUpdateArgs args) {
        boolean result = false;
        if (this.getIdOfRegister() == (long)args.getID()) {
            result = true;
        }
        return result;
    }

    public Object getTagObject() {
        return this.tagObject;
    }

    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.requestId = Long.parseLong(value, 16);
    }

    @Override
    public String getFactoryObjectId() {
        return Long.toHexString(this.requestId);
    }

    @Override
    public String getFactoryObjectStatus() {
        return "ID: " + this.getFactoryObjectId() + " : " + this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void release() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle("Releasing " + this.toString(), "RegisterRequestDescriptor.Release", null);
        }
        if (this.requestQueue != null) {
            this.requestQueue.deleteRequest(this, false);
        }
        this.setRequestStatus(EnumMemoryRequestStates.REQUEST_OBJECT_RELEASED);
        if (this.getRequestId() > 0L) {
            this.requestId = -1L * this.requestId;
        } else {
            this.setRequestId(-1L);
        }
        this.numTimesNotifyCalled = 0;
        this.clientToNotifyOnRequestComplete = null;
        this.listOfClientConfigOptions = null;
        this.setOwner(null);
        this.errorCode = 0;
        this.discard = false;
        this.setMemoryView(EnumMemoryViews.CPU_MEMORY_VIEW);
        this.pendingWriteData = 0L;
        this.pendingWriteString = "";
        this.setErrorInfoString("Memory Server Request not configured.");
        this.requestQueueName = "NotInQueue";
        this.clientTagObject = null;
        this.setStartAdrs(0L);
        this.setLengthInMAUs(0);
        if (this.dspRegisterObj != null) {
            if (this.registerRequestType == EnumRegisterRequestType.WRITE_REGISTER && !this.dspRegisterObj.isDisposed()) {
                this.dspRegisterObj.dispose();
            }
            this.dspRegisterObj = null;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle(this.toString() + ": released DspMemory COM Object", "RegisterRequestDescriptor.Release", null);
            }
        }
        this.onReleased();
    }

    @Override
    public void releaseAndDequeue() {
        this.release();
    }

    protected void onReleased() {
        if (this.factory != null) {
            this.factory.onRelease(this);
        }
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller  that was not the factory that created it [" + this.factory.getName() + "]", "RegisterRequestDescriptor.dispose", null);
        }
    }

    protected synchronized void dispose(boolean disposing) {
        if (this.disposed || disposing) {
            // empty if block
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return null;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
    }
}

