/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorFactory;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class RequestDescriptorQueue
implements Iterable<RequestDescriptorBaseClass> {
    private Vector<RequestDescriptorBaseClass> queue = new Vector();
    public String name;
    private long nextRequestId = 1L;
    private RequestDescriptorFactory requestDescriptorFactory = null;
    private int currentIndex = -1;

    public RequestDescriptorQueue(String nameOfQueue, RequestDescriptorFactory factoryObj) {
        long seed = 127 * nameOfQueue.charAt(0);
        Random randomNumGen = new Random(seed);
        this.nextRequestId = randomNumGen.nextInt(Short.MAX_VALUE);
        if (this.getNextRequestId() == 0L) {
            this.setNextRequestId(1L);
        }
        this.name = nameOfQueue;
        this.requestDescriptorFactory = factoryObj;
    }

    public int size() {
        return this.queue.size();
    }

    public long getNextRequestId() {
        return this.nextRequestId;
    }

    public void setNextRequestId(long value) {
        this.nextRequestId = value;
    }

    public RequestDescriptorFactory getRequestDescriptorFactory() {
        return this.requestDescriptorFactory;
    }

    public void setRequestDescriptorFactory(RequestDescriptorFactory value) {
        this.requestDescriptorFactory = value;
    }

    public void clear() {
        RequestDescriptorBaseClass request = null;
        int numRequests = 0;
        while (this.queue.size() > 0) {
            numRequests = this.queue.size();
            request = this.queue.get(0);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle("Clearing RequestDescriptorQueue " + this.name + ", releasing req " + request.getRequestQueueName() + Long.toHexString(request.getRequestId()) + "[req status = " + (Object)((Object)request.getRequestStatus()) + "]", "RequestDescriptorQueue.Clear", null);
            }
            request.release();
            if (numRequests != this.queue.size()) continue;
            this.queue.remove(0);
        }
        this.queue.clear();
    }

    public void addRequest(RequestDescriptorBaseClass request) {
        this.addRequest(request, false);
    }

    public void addRequest(RequestDescriptorBaseClass request, boolean isBlocking) {
        request.setRequestId(this.getNextRequestId());
        this.setNextRequestId(this.getNextRequestId() + 1L);
        if (this.getNextRequestId() == 0L) {
            this.setNextRequestId(1L);
        }
        request.setRequestQueueName(this.name);
        request.setRequestQueue(this);
        RequestDescriptorBaseClass reqInQueueWithSameId = this.findRequestWithId(request.getRequestId());
        if (reqInQueueWithSameId != null) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("[" + this.name + "]: Attempt to add request with same Id as pending request:" + "\nNew request: " + request.toString() + "\nPending request: " + reqInQueueWithSameId.toString(), "RequestDescriptorQueue.AddRequest", null);
            }
        } else if (!isBlocking) {
            this.queue.add(request);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle("new request added to " + request.getRequestQueueName() + ": " + request.toString(), "RequestDescriptorQueue.AddRequest", null);
            }
        } else {
            this.queue.add(0, request);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle("new blocking request inserted at the beginning of  " + request.getRequestQueueName() + ": " + request.toString(), "RequestDescriptorQueue.AddRequest", null);
            }
        }
    }

    public void deleteFirstRequest(boolean releaseRequest) {
        if (this.queue.size() > 0) {
            RequestDescriptorBaseClass request = this.queue.get(0);
            if (request != null) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle("delete first request = " + request.getRequestQueueName() + "_" + Long.toHexString(request.getRequestId()) + ", release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteRequest", null);
                }
                this.queue.remove(0);
                request.setRequestQueueName("Deleted from " + this.name + " (was req.ID 0x" + Long.toHexString(request.getRequestId()) + ")");
                request.setRequestQueue(null);
                if (releaseRequest) {
                    request.release();
                }
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(this.name + ": Could not delete first request in queue, queue is empty. release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteFirstRequest", null);
        }
    }

    public void deleteRequest(RequestDescriptorBaseClass request, boolean releaseRequest) {
        if (this.queue.contains(request)) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle(this.name + ".DeleteRequest = " + request.getRequestQueueName() + "_" + Long.toHexString(request.getRequestId()) + ", release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteRequest", null);
            }
            this.queue.remove(request);
            request.setRequestQueueName("Deleted from " + this.name + " (was req.ID 0x" + Long.toHexString(request.getRequestId()) + ")");
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(this.name + " Could not delete = " + request.getRequestIdStr() + ", not in queue. release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteRequest_request", null);
        }
        request.setRequestQueue(null);
        if (releaseRequest) {
            request.release();
        }
    }

    public void deleteRequest(long id, boolean releaseRequest) {
        RequestDescriptorBaseClass foundRequest = this.findRequestWithId(id);
        if (foundRequest != null) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle(this.name + ".delete id = " + foundRequest.getRequestQueueName() + "_" + Long.toHexString(id) + ", release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteRequest", null);
            }
            this.queue.remove(foundRequest);
            foundRequest.setRequestQueueName("Deleted from " + this.name);
            foundRequest.setRequestQueue(null);
            if (releaseRequest) {
                foundRequest.release();
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(this.name + ": Could not delete request ID " + Long.toHexString(id) + ", NOT IN QUEUE", "RequestDescriptorQueue.DeleteRequest_id", null);
        }
    }

    public void deleteRequestAtIndex(int index, boolean releaseRequest) {
        if (index < this.queue.size()) {
            RequestDescriptorBaseClass foundRequest = this.queue.get(index);
            if (foundRequest != null) {
                this.queue.remove(index);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle(this.name + ".Delete id = " + foundRequest.getRequestQueueName() + "_" + Long.toHexString(foundRequest.getRequestId()) + ", release request = " + Boolean.toString(releaseRequest), "RequestDescriptorQueue.DeleteRequestAtIndex(" + Integer.toString(index) + ")", null);
                }
                this.queue.remove(foundRequest);
                foundRequest.setRequestQueueName("Deleted from " + this.name);
                foundRequest.setRequestQueue(null);
                if (releaseRequest) {
                    foundRequest.release();
                }
            }
        } else {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo(this.name + ": Could not delete request at index " + String.valueOf(index) + ", queue.size() = " + Integer.toString(this.queue.size()), "RequestDescriptorQueue.DeleteRequestAtIndex", null);
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean containsRequest(RequestDescriptorBaseClass request) {
        return this.queue.contains(request);
    }

    public RequestDescriptorBaseClass findRequestWithId(long id) {
        RequestDescriptorBaseClass foundRequest = null;
        int i = 0;
        while (i < this.queue.size()) {
            RequestDescriptorBaseClass request;
            if ((request = this.queue.get(i++)).getRequestId() != id) continue;
            foundRequest = request;
            break;
        }
        return foundRequest;
    }

    public RequestDescriptorBaseClass peekAtFirstRequest() {
        RequestDescriptorBaseClass firstRequestInQueue = null;
        if (this.queue.size() > 0) {
            firstRequestInQueue = this.queue.get(0);
        }
        return firstRequestInQueue;
    }

    public RequestDescriptorBaseClass peekAtRequestAtIndex(int index) {
        RequestDescriptorBaseClass requestAtIndex = null;
        if (this.queue.size() > index) {
            requestAtIndex = this.queue.get(index);
        }
        return requestAtIndex;
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public Object next() {
        if (this.currentIndex + 1 < this.queue.size()) {
            ++this.currentIndex;
        }
        return this.queue.get(this.currentIndex);
    }

    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.queue.size()) {
            ++this.currentIndex;
            result = true;
        }
        return result;
    }

    public Object getCurrent() {
        RequestDescriptorBaseClass result = null;
        if (this.queue.size() > this.currentIndex) {
            result = this.queue.get(this.currentIndex);
        }
        return result;
    }

    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.queue.size()) {
            this.queue.remove(this.currentIndex);
            if (this.currentIndex >= this.queue.size()) {
                this.currentIndex = this.queue.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public Iterator<RequestDescriptorBaseClass> iterator() {
        this.reset();
        return this.queue.iterator();
    }
}

