/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.requestdescriptors;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorBaseClass;
import java.util.ArrayList;
import java.util.Iterator;

public class RequestList
implements Iterable<RequestDescriptorBaseClass> {
    private ArrayList<RequestDescriptorBaseClass> requestList = new ArrayList();
    private int currentIndex = -1;

    public RequestDescriptorBaseClass get(int index) {
        if (index > this.requestList.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.requestList.get(index);
    }

    public int size() {
        return this.requestList.size();
    }

    public void add(RequestDescriptorBaseClass requestObj) {
        if (!this.requestList.contains(requestObj)) {
            this.requestList.add(requestObj);
        }
    }

    public void remove(RequestDescriptorBaseClass requestObj) {
        this.requestList.remove(requestObj);
    }

    public boolean contains(RequestDescriptorBaseClass requestObj) {
        return this.requestList.contains(requestObj);
    }

    public RequestDescriptorBaseClass getRequest(long requestId) {
        RequestDescriptorBaseClass result = null;
        for (RequestDescriptorBaseClass requestObj : this.requestList) {
            if (requestObj.getRequestId() != requestId) continue;
            result = requestObj;
            break;
        }
        return result;
    }

    public void clear() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle(Long.toString(this.size()) + " requests being cleared", "RequestList.clear", null);
        }
        this.requestList.clear();
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public RequestDescriptorBaseClass getCurrent() {
        RequestDescriptorBaseClass result = null;
        if (this.requestList.size() > this.currentIndex) {
            result = this.requestList.get(this.currentIndex);
        }
        return result;
    }

    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.requestList.size()) {
            result = true;
        }
        return result;
    }

    public RequestDescriptorBaseClass next() {
        RequestDescriptorBaseClass result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.requestList.get(this.currentIndex);
        }
        return result;
    }

    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.requestList.size()) {
            this.requestList.remove(this.currentIndex);
            if (this.currentIndex >= this.requestList.size()) {
                this.currentIndex = this.requestList.size() - 1;
            }
        }
    }

    @Override
    public Iterator<RequestDescriptorBaseClass> iterator() {
        this.reset();
        return this.requestList.iterator();
    }
}

