/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.symbols;

import com.ti.ccstudio.debug.memoryserver.enums.EnumSymbolSortOptions;
import com.ti.ccstudio.debug.memoryserver.symbols.SymbolInfo;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ListOfSymbols
implements Iterator<SymbolInfo>,
Iterable<SymbolInfo>,
IDisposable {
    private ArrayList<SymbolInfo> list = null;
    private EnumSymbolSortOptions sortBy = EnumSymbolSortOptions.SORT_BY_ADDRESS;
    private int currentIndex = -1;
    private volatile boolean isDisposed = false;

    public ListOfSymbols() {
        this.list = new ArrayList();
    }

    public SymbolInfo get(int itemIndex) {
        if (itemIndex >= this.list.size() || itemIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get(itemIndex);
    }

    public int size() {
        return this.list.size();
    }

    public EnumSymbolSortOptions sortBy() {
        return this.sortBy;
    }

    public void setSortBy(EnumSymbolSortOptions value) {
        this.sortBy = value;
        Collections.sort(this.list);
    }

    public void add(SymbolInfo symbol) {
        if (symbol.sortBy() != this.sortBy()) {
            symbol.setSortBy(this.sortBy());
        }
        this.list.add(symbol);
    }

    public int getSymbolsForAdrsRange(long startAdrs, long endAdrs, boolean useOnlyStartAdrsForSymbol, ArrayList<SymbolInfo> listOfSymbolsAtAdrs) {
        int result = 0;
        listOfSymbolsAtAdrs.clear();
        for (SymbolInfo symbol : this.list) {
            if (useOnlyStartAdrsForSymbol) {
                if (endAdrs < symbol.getStartAdrs() || startAdrs > symbol.getStartAdrs()) continue;
                listOfSymbolsAtAdrs.add(symbol);
                continue;
            }
            if (endAdrs < symbol.getStartAdrs() || startAdrs > symbol.getEndAdrs()) continue;
            listOfSymbolsAtAdrs.add(symbol);
        }
        return result;
    }

    public void clear() {
        this.list.clear();
    }

    public void sort() {
        Collections.sort(this.list);
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public SymbolInfo getCurrent() {
        SymbolInfo result = null;
        if (this.list.size() > this.currentIndex) {
            result = this.list.get(this.currentIndex);
        }
        return result;
    }

    public boolean moveNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.list.size()) {
            ++this.currentIndex;
            result = true;
        }
        return result;
    }

    @Override
    public Iterator<SymbolInfo> iterator() {
        this.reset();
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex < this.list.size() - 1) {
            result = true;
        }
        return result;
    }

    @Override
    public SymbolInfo next() {
        SymbolInfo result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    @Override
    public void remove() {
        if (this.currentIndex > 0 && this.currentIndex < this.list.size()) {
            this.list.remove(this.currentIndex);
            if (this.currentIndex >= this.list.size()) {
                this.currentIndex = this.list.size() - 1;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void acquire() {
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
        }
    }
}

