/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.symbols;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSymbolSortOptions;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSymbolType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;

public class SymbolInfo
implements Comparable<SymbolInfo> {
    private String name = "";
    private long startAdrs = 0L;
    private long endAdrs = 0L;
    private boolean isData = false;
    private boolean isCode = false;
    private EnumSymbolType symbolType = EnumSymbolType.GLOBAL;
    private EnumSymbolSortOptions sortBy = EnumSymbolSortOptions.SORT_BY_ADDRESS;

    public SymbolInfo(String name, boolean isData, boolean isCode, long startAdrs, long endAdrs, EnumSymbolType symbolType, EnumSymbolSortOptions sortBy) {
        this.name = name;
        this.isData = isData;
        this.isCode = isCode;
        this.setStartAdrs(startAdrs);
        this.setEndAdrs(endAdrs);
        if (this.getEndAdrs() < this.getStartAdrs()) {
            this.setEndAdrs(this.getStartAdrs());
        }
        this.symbolType = symbolType;
        this.sortBy = sortBy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public long getStartAdrs() {
        return this.startAdrs;
    }

    public void setStartAdrs(long value) {
        if (value < 0L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.log(true, EnumTraceLevel.ERRORS, true, "-ve address entered", "SymbolInfo.setStartAdrs", null, "");
            }
            this.startAdrs = Long.MAX_VALUE;
        } else {
            this.startAdrs = value;
        }
    }

    public long getEndAdrs() {
        return this.endAdrs;
    }

    public void setEndAdrs(long value) {
        if (value < 0L) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.log(true, EnumTraceLevel.ERRORS, true, "-ve address entered", "SymbolInfo.setEndAdrs", null, "");
            }
            this.endAdrs = Long.MAX_VALUE;
        } else {
            this.endAdrs = value;
        }
    }

    public boolean iIsData() {
        return this.isData;
    }

    public void setIsData(boolean value) {
        this.isData = value;
    }

    public boolean isCode() {
        return this.isCode;
    }

    public void setIsCode(boolean value) {
        this.isCode = value;
    }

    public EnumSymbolType getSymbolType() {
        return this.symbolType;
    }

    public void setSymbolType(EnumSymbolType value) {
        this.symbolType = value;
    }

    public EnumSymbolSortOptions sortBy() {
        return this.sortBy;
    }

    public void setSortBy(EnumSymbolSortOptions value) {
        this.sortBy = value;
    }

    public long getLengthInMAUs() {
        long result = this.endAdrs - this.startAdrs + 1L;
        return result;
    }

    @Override
    public int compareTo(SymbolInfo symbolInfo) {
        int result = 0;
        switch (this.sortBy) {
            case SORT_BY_ADDRESS: {
                result = new Long(this.startAdrs).compareTo(symbolInfo.getStartAdrs());
                if (result != 0) break;
                result = this.name.compareTo(symbolInfo.getName());
                break;
            }
            case SORT_BY_NAME: {
                result = this.name.compareTo(symbolInfo.getName());
                if (result != 0) break;
                result = new Long(this.startAdrs).compareTo(symbolInfo.getStartAdrs());
            }
        }
        return result;
    }
}

