/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.symbols;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.symbols.ListOfSymbols;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.ISymbolInfo;
import com.ti.debug.engine.ISymbolManager;
import com.ti.debug.engine.ISymbolPackage;

public class SymbolMgr
implements IDisposable {
    private TargetHandler target = null;
    private ISymbolManager symbolMgr = null;
    private ISymbolPackage symbolPkg = null;
    private ListOfSymbols listOfSymbols = null;
    private volatile boolean disposed = false;

    public SymbolMgr(TargetHandler target) {
        this.target = target;
        this.symbolMgr = this.target.getDspUser().getSymbolManager();
        this.listOfSymbols = new ListOfSymbols();
    }

    public void getSymbolPkg() {
        try {
            IDspUser dspUser = this.target.getDspUser();
            if (dspUser != null) {
                this.symbolPkg = this.symbolMgr.getSymbolPackage();
            }
        }
        catch (Exception ex) {
            MemoryServerTrace.log(true, EnumTraceLevel.ERRORS, false, "Exception while loading symbols", "com.ti.debug.memoryserver.symbols.getSymbols", ex, this.target.info.getStrTargetDescription());
        }
    }

    public String getSymbolString(long address, short pageNum) {
        IDspUser dspUser;
        String result = "";
        String symbolName = "";
        int maxNumSymbolsPerAdrs = 256;
        int numSymbols = 0;
        if (this.symbolPkg == null) {
            this.getSymbolPkg();
        }
        if (this.symbolPkg != null && (dspUser = this.target.getDspUser()) != null) {
            try {
                numSymbols = 0;
                symbolName = this.getSymbolString(address, pageNum);
                while (symbolName.length() > 0 && numSymbols < maxNumSymbolsPerAdrs) {
                    ++numSymbols;
                    if (result.length() > 0) {
                        result = result + ", ";
                    }
                    result = result + symbolName;
                    symbolName = "";
                }
                if (numSymbols >= maxNumSymbolsPerAdrs) {
                    MemoryServerTrace.log(true, EnumTraceLevel.ERRORS, true, "Symbol Server Error: ccsSymbols.GetNextSymbol returned non-null value " + Integer.toString(numSymbols) + " times.  Aborting while loop. Symbol String = " + symbolName, "CcsSymbolMgr.GetSymbolString", null, this.target.info.getStrTargetDescription());
                }
            }
            catch (Exception ex) {
                MemoryServerTrace.log(true, EnumTraceLevel.ERRORS, true, "Error getting symbols for address 0x" + Long.toHexString(address) + ", page " + Integer.toString(pageNum), "com.ti.debug.memoryserver.symbols.getSymbolString", ex, this.target.info.getStrTargetDescription());
            }
        }
        return result;
    }

    public String getSymbolString(long adrs, int memPage) {
        String symbolString = null;
        ISymbolInfo symInfo = this.symbolPkg.lookupSymbol((int)adrs, memPage, true);
        if (symInfo != null) {
            symbolString = symInfo.getName();
        }
        symInfo.dispose();
        return symbolString;
    }

    public void updateSymbols() {
        if (this.symbolPkg != null && !this.symbolPkg.isDisposed()) {
            this.symbolPkg.dispose();
        }
        this.symbolPkg = this.symbolMgr != null ? this.symbolMgr.getSymbolPackage() : null;
    }

    public void clearSymbols() {
        if (this.symbolPkg != null && !this.symbolPkg.isDisposed()) {
            this.symbolPkg.dispose();
        }
        this.symbolPkg = null;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            if (this.listOfSymbols != null && !this.listOfSymbols.isDisposed()) {
                this.listOfSymbols.dispose();
            }
            this.listOfSymbols = null;
            if (this.symbolMgr != null && !this.symbolMgr.isDisposed()) {
                this.symbolMgr.dispose();
            }
            this.symbolMgr = null;
            if (this.symbolPkg != null && !this.symbolPkg.isDisposed()) {
                this.symbolPkg.dispose();
            }
            this.symbolPkg = null;
            this.disposed = true;
        }
        this.disposed = true;
    }
}

