/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.enums.EnumCacheLineDescriptorChanges;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import java.util.EnumSet;

public class CacheLineDescriptor
implements Comparable<CacheLineDescriptor> {
    private EnumSet<EnumCacheLineDescriptorChanges> changes = EnumSet.noneOf(EnumCacheLineDescriptorChanges.class);
    private long lineAdrs = 0L;
    private long previousLineAdrs = 0L;
    private int cacheSetId = 0;
    private Byte validBit = 0;
    private Byte dirtyBit = 0;
    private Byte lruValue = 0;
    private short lruWay = 0;
    private long wayNumber = 0L;
    private int tagRamError = 0;

    public CacheLineDescriptor() {
    }

    public CacheLineDescriptor(CacheLineDescriptor objToCopyFrom) {
        this.setLineAdrs(objToCopyFrom.getLineAdrs());
        this.setCacheSetId(objToCopyFrom.getCacheSetId());
        this.setValidBit(objToCopyFrom.getValidBit());
        this.setDirtyBit(objToCopyFrom.getDirtyBit());
        this.setLruWay(objToCopyFrom.getLruWay());
        this.setLruValue(objToCopyFrom.getLruValue());
        this.setWayNumber(objToCopyFrom.getWayNumber());
        this.setTagRamError(objToCopyFrom.getTagRamError());
    }

    public EnumSet<EnumCacheLineDescriptorChanges> getChanges() {
        return this.changes;
    }

    public void setChanges(EnumSet<EnumCacheLineDescriptorChanges> value) {
        this.changes.clear();
        this.changes.addAll(value);
    }

    public long getLineAdrs() {
        return this.lineAdrs;
    }

    public void setLineAdrs(long value) {
        UInt63 uValue = new UInt63(value);
        this.previousLineAdrs = this.lineAdrs;
        if (this.lineAdrs != uValue.getValue()) {
            this.changes.add(EnumCacheLineDescriptorChanges.LINE_ADRS);
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.LINE_ADRS);
        }
        this.lineAdrs = uValue.getValue();
    }

    public long getPreviousLineAdrs() {
        return this.previousLineAdrs;
    }

    public void setPreviousLineAdrs(long value) {
        this.previousLineAdrs = value;
    }

    public int getCacheSetId() {
        return this.cacheSetId;
    }

    public void setCacheSetId(int value) {
        if (this.cacheSetId != value) {
            this.changes.add(EnumCacheLineDescriptorChanges.CACHE_SET_ID);
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.CACHE_SET_ID);
        }
        this.cacheSetId = value;
    }

    public Byte getValidBit() {
        return this.validBit;
    }

    public void setValidBit(Byte value) {
        if (this.validBit != value) {
            this.changes.add(EnumCacheLineDescriptorChanges.VALID_BIT);
            if (this.validBit == 0) {
                this.previousLineAdrs = this.lineAdrs;
            }
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.VALID_BIT);
        }
        this.validBit = value;
    }

    public Byte getDirtyBit() {
        return this.dirtyBit;
    }

    public void setDirtyBit(Byte value) {
        if (this.dirtyBit != value) {
            this.changes.add(EnumCacheLineDescriptorChanges.DIRTY_BIT);
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.DIRTY_BIT);
        }
        this.dirtyBit = value;
    }

    public Byte getLruValue() {
        return this.lruValue;
    }

    public void setLruValue(Byte value) {
        this.lruValue = value;
    }

    public short getLruWay() {
        return this.lruWay;
    }

    public void setLruWay(short value) {
        if (this.wayNumber != (long)value && (long)this.lruWay == this.wayNumber || this.wayNumber == (long)value && (long)this.lruWay != this.wayNumber) {
            this.changes.add(EnumCacheLineDescriptorChanges.LRU_WAY);
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.LRU_WAY);
        }
        this.lruWay = value;
    }

    public long getWayNumber() {
        return this.wayNumber;
    }

    public void setWayNumber(long value) {
        if (this.wayNumber != value) {
            this.changes.add(EnumCacheLineDescriptorChanges.WAY_NUMBER);
        } else {
            this.changes.remove((Object)EnumCacheLineDescriptorChanges.WAY_NUMBER);
        }
        this.wayNumber = value;
    }

    public int getTagRamError() {
        return this.tagRamError;
    }

    public void setTagRamError(int value) {
        this.tagRamError = value;
    }

    public String toString() {
        return "Line Adrs: 0x" + Long.toHexString(this.lineAdrs) + " CacheSetId: " + Long.toString(this.cacheSetId) + " ValidBit: " + this.validBit.toString() + " LRU value: " + this.lruValue.toString() + " TagRamError: 0x" + Integer.toHexString(this.tagRamError);
    }

    @Override
    public int compareTo(CacheLineDescriptor cacheLine) {
        int result = 0;
        int compareToSetIdResult = 0;
        int compareToWayNumberResult = 0;
        if (cacheLine == null) {
            throw new NullPointerException(this.getClass().getName() + ".compareTo(null)");
        }
        Long thisCacheSetId = this.getCacheSetId();
        Long otherCacheSetId = cacheLine.getCacheSetId();
        compareToSetIdResult = thisCacheSetId.compareTo(otherCacheSetId);
        Long thisWayNumber = this.getWayNumber();
        Long otherWayNumber = cacheLine.getWayNumber();
        compareToWayNumberResult = thisWayNumber.compareTo(otherWayNumber);
        result = compareToSetIdResult;
        if (result == 0) {
            result = compareToWayNumberResult;
        }
        return result;
    }
}

