/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumCacheLevel;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.ICacheTagRamHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.CacheLineDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import com.ti.debug.engine.ICacheTagRamData;
import com.ti.debug.engine.ICacheTagRamDatas;
import com.ti.debug.engine.ICacheTagRamReader;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class CacheTagRamHandler
implements ICacheTagRamHandler,
IDisposable {
    private TargetHandler target;
    private ICacheTagRamReader cacheTagRamReader;
    protected ArrayList<CacheLineDescriptor> listCacheLineDescriptors;
    protected long numCacheLinesRead;
    protected long numMAUsInCache;
    private MemoryTypeDescriptor memTypeObj;
    private boolean isCacheDirtyBitAccessible;
    private int numWaysInCache;
    private boolean isLruSupported;
    private RegisterDecoder lruBitToWayDecoder;
    private ArrayList<ArrayList<CacheLineDescriptor>> listOfSets;
    private EnumCacheLevel enumCacheLevel;
    private volatile boolean disposed;

    public CacheTagRamHandler(TargetHandler targetHdlr, MemoryTypeDescriptor memType, XmlElement memoryTypeNode, ArrayList<RegisterDecoder> listOfDecoders) {
        MyXPathNodeIterator cacheInfoNodeIterator;
        XmlElement cacheInfoNode;
        XmlHelper xmlHelper;
        String decoderName;
        block17: {
            this.target = null;
            this.cacheTagRamReader = null;
            this.listCacheLineDescriptors = null;
            this.numCacheLinesRead = 0L;
            this.numMAUsInCache = 0L;
            this.isCacheDirtyBitAccessible = false;
            this.numWaysInCache = 0;
            this.isLruSupported = false;
            this.lruBitToWayDecoder = null;
            this.listOfSets = null;
            this.enumCacheLevel = EnumCacheLevel.L1D_CACHE;
            this.disposed = false;
            decoderName = "";
            xmlHelper = new XmlHelper();
            MyXPathNodeIterator nodeIterator = memoryTypeNode.select("Cache", true);
            cacheInfoNode = nodeIterator.moveToFirst();
            cacheInfoNodeIterator = null;
            if (cacheInfoNode != null) {
                cacheInfoNodeIterator = cacheInfoNode.getIteratorForChildNodes();
            }
            this.memTypeObj = memType;
            this.target = targetHdlr;
            try {
                if (targetHdlr != null && targetHdlr.getDspTask() != null && !targetHdlr.isDisconnected() && targetHdlr.getDspTask().capableCacheTagRamReader()) {
                    this.cacheTagRamReader = targetHdlr.getDspTask().getCacheTagRamReader();
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    String procId = "";
                    String targetType = "";
                    ITargetDeviceInfo targetInfo = null;
                    if (targetHdlr != null) {
                        targetInfo = targetHdlr.getInfo();
                        procId = targetInfo.getStrTargetProcessorId();
                        targetType = targetInfo.getStrTargetTypeId();
                    }
                    String info = targetType + " Driver returned null - no cache tag RAM info for " + this.getMemTypeObj().getName() + ", procId=" + procId;
                    if (this.cacheTagRamReader != null) {
                        info = targetType + " Driver returned a valid Cache Tag RAM handler for " + this.getMemTypeObj().getName();
                    }
                    MemoryServerTrace.logInfo(info, "CacheTagRamHandler xml constructor", targetInfo);
                }
            }
            catch (Exception exc) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block17;
                ITargetDeviceInfo targetInfo = null;
                if (targetHdlr != null) {
                    targetInfo = targetHdlr.getInfo();
                }
                MemoryServerTrace.logException("Exception calling DspTask.GetCacheTagRamReader", "CacheTagRamHandler xml constructor", exc, targetInfo);
            }
        }
        this.listCacheLineDescriptors = new ArrayList();
        for (int index = 0; index < this.memTypeObj.getMaxNumCacheLines(); ++index) {
            this.listCacheLineDescriptors.add(new CacheLineDescriptor());
        }
        this.enumCacheLevel = this.memTypeObj.getHierarchyDepth() == 1 ? (this.memTypeObj.isDataMemory() ? EnumCacheLevel.L1D_CACHE : EnumCacheLevel.L1P_CACHE) : EnumCacheLevel.L2_CACHE;
        this.isCacheDirtyBitAccessible = false;
        this.numWaysInCache = 1;
        this.isLruSupported = false;
        if (cacheInfoNodeIterator != null) {
            XmlElement element = cacheInfoNodeIterator.findFirstNodeWithName("IsCacheDirtyBitAccessible", false, true);
            if (element != null) {
                this.isCacheDirtyBitAccessible = element.getValueAsBoolean();
            }
            if ((element = cacheInfoNodeIterator.findFirstNodeWithName("NumWaysInCache", false, true)) != null) {
                this.numWaysInCache = element.getValueAsInt();
            }
            if ((element = cacheInfoNodeIterator.findFirstNodeWithName("IsLruSupported", false, true)) != null) {
                this.isLruSupported = element.getValueAsBoolean();
            }
        }
        if (this.isLruSupported && (decoderName = xmlHelper.getString(cacheInfoNode, "DecoderName", "", 1)).length() > 0) {
            for (RegisterDecoder decoder : listOfDecoders) {
                if (!decoder.getName().equals(decoderName)) continue;
                this.lruBitToWayDecoder = decoder;
                break;
            }
            if (this.lruBitToWayDecoder == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError(this.getMemTypeObj().getName() + " cache tag ram decoder - lru to way map decoder [xml:" + decoderName + "] not found in list of decoders", "CacheTagRamHandler constructor", null);
            }
        }
        this.listCacheLineDescriptors = new ArrayList();
        for (int index = 0; index < this.memTypeObj.getMaxNumCacheLines(); ++index) {
            this.listCacheLineDescriptors.add(new CacheLineDescriptor());
        }
        this.listOfSets = new ArrayList();
        this.initListOfSets();
    }

    public CacheTagRamHandler(TargetHandler targetHdlr, MemoryTypeDescriptor memType, DeviceXMLReader.CacheTagInfo cacheTagInfo, ArrayList<RegisterDecoder> listOfDecoders) {
        String decoderName;
        block13: {
            this.target = null;
            this.cacheTagRamReader = null;
            this.listCacheLineDescriptors = null;
            this.numCacheLinesRead = 0L;
            this.numMAUsInCache = 0L;
            this.isCacheDirtyBitAccessible = false;
            this.numWaysInCache = 0;
            this.isLruSupported = false;
            this.lruBitToWayDecoder = null;
            this.listOfSets = null;
            this.enumCacheLevel = EnumCacheLevel.L1D_CACHE;
            this.disposed = false;
            decoderName = "";
            this.memTypeObj = memType;
            this.target = targetHdlr;
            try {
                if (targetHdlr != null && targetHdlr.getDspTask() != null && !targetHdlr.isDisconnected() && targetHdlr.getDspTask().capableCacheTagRamReader()) {
                    this.cacheTagRamReader = targetHdlr.getDspTask().getCacheTagRamReader();
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    String procId = "";
                    String targetType = "";
                    ITargetDeviceInfo targetInfo = null;
                    if (targetHdlr != null) {
                        targetInfo = targetHdlr.getInfo();
                        procId = targetInfo.getStrTargetProcessorId();
                        targetType = targetInfo.getStrTargetTypeId();
                    }
                    String info = targetType + " Driver returned null - no cache tag RAM info for " + this.getMemTypeObj().getName() + ", procId=" + procId;
                    if (this.cacheTagRamReader != null) {
                        info = targetType + " Driver returned a valid Cache Tag RAM handler for " + this.getMemTypeObj().getName();
                    }
                    MemoryServerTrace.logInfo(info, "CacheTagRamHandler xml constructor", targetInfo);
                }
            }
            catch (Exception exc) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block13;
                ITargetDeviceInfo targetInfo = null;
                if (targetHdlr != null) {
                    targetInfo = targetHdlr.getInfo();
                }
                MemoryServerTrace.logException("Exception calling DspTask.GetCacheTagRamReader", "CacheTagRamHandler xml constructor", exc, targetInfo);
            }
        }
        this.listCacheLineDescriptors = new ArrayList();
        for (int index = 0; index < this.memTypeObj.getMaxNumCacheLines(); ++index) {
            this.listCacheLineDescriptors.add(new CacheLineDescriptor());
        }
        this.enumCacheLevel = this.memTypeObj.getHierarchyDepth() == 1 ? (this.memTypeObj.isDataMemory() ? EnumCacheLevel.L1D_CACHE : EnumCacheLevel.L1P_CACHE) : EnumCacheLevel.L2_CACHE;
        this.isCacheDirtyBitAccessible = false;
        this.numWaysInCache = 1;
        this.isLruSupported = false;
        if (cacheTagInfo != null) {
            this.isCacheDirtyBitAccessible = cacheTagInfo.isCacheDirtyBitAccessible;
            this.numWaysInCache = cacheTagInfo.numWaysInCache;
            this.isLruSupported = cacheTagInfo.isLruSupported;
        }
        if (this.isLruSupported && (decoderName = cacheTagInfo.decoderName).length() > 0) {
            for (RegisterDecoder decoder : listOfDecoders) {
                if (!decoder.getName().equals(decoderName)) continue;
                this.lruBitToWayDecoder = decoder;
                break;
            }
            if (this.lruBitToWayDecoder == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError(this.getMemTypeObj().getName() + " cache tag ram decoder - lru to way map decoder [xml:" + decoderName + "] not found in list of decoders", "CacheTagRamHandler constructor", null);
            }
        }
        this.listCacheLineDescriptors = new ArrayList();
        for (int index = 0; index < this.memTypeObj.getMaxNumCacheLines(); ++index) {
            this.listCacheLineDescriptors.add(new CacheLineDescriptor());
        }
        this.listOfSets = new ArrayList();
        this.initListOfSets();
    }

    public CacheTagRamHandler(CacheTagRamHandler objToCopyFrom) {
        block5: {
            this.target = null;
            this.cacheTagRamReader = null;
            this.listCacheLineDescriptors = null;
            this.numCacheLinesRead = 0L;
            this.numMAUsInCache = 0L;
            this.isCacheDirtyBitAccessible = false;
            this.numWaysInCache = 0;
            this.isLruSupported = false;
            this.lruBitToWayDecoder = null;
            this.listOfSets = null;
            this.enumCacheLevel = EnumCacheLevel.L1D_CACHE;
            this.disposed = false;
            this.target = objToCopyFrom.target;
            this.memTypeObj = objToCopyFrom.getMemTypeObj();
            try {
                if (this.target != null && this.target.getDspTask() != null && !this.target.isDisconnected() && this.target.getDspTask().capableCacheTagRamReader()) {
                    this.cacheTagRamReader = this.target.getDspTask().getCacheTagRamReader();
                }
            }
            catch (Exception exc) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block5;
                ITargetDeviceInfo targetInfo = this.target.getInfo();
                if (this.target != null) {
                    targetInfo = this.target.getInfo();
                }
                MemoryServerTrace.logException("Exception calling DspTask.GetCacheTagRamReader", "CacheTagRamHandler copy constructor", exc, targetInfo);
            }
        }
        this.isCacheDirtyBitAccessible = objToCopyFrom.isCacheDirtyBitAccessible;
        this.isLruSupported = objToCopyFrom.isLruSupported();
        this.numWaysInCache = objToCopyFrom.getNumWaysInCache();
        this.enumCacheLevel = objToCopyFrom.getEnumCacheLevel();
        this.lruBitToWayDecoder = objToCopyFrom.getLruBitToWayDecoder();
        this.listCacheLineDescriptors = new ArrayList();
        for (int index = 0; index < objToCopyFrom.getListCacheLineDescriptors().size(); ++index) {
            CacheLineDescriptor line = new CacheLineDescriptor(objToCopyFrom.getListCacheLineDescriptors().get(index));
            this.listCacheLineDescriptors.add(line);
        }
        this.listOfSets = new ArrayList();
        this.initListOfSets();
    }

    @Override
    public boolean isCacheTagRamReadable() {
        boolean result = false;
        if (this.cacheTagRamReader != null) {
            result = true;
        }
        return result;
    }

    @Override
    public ArrayList<CacheLineDescriptor> getListCacheLineDescriptors() {
        return this.listCacheLineDescriptors;
    }

    @Override
    public long getNumCacheLinesRead() {
        return this.numCacheLinesRead;
    }

    public void setNumCacheLinesRead(long value) {
        this.numCacheLinesRead = value;
    }

    public long getNumMAUsInCache() {
        return this.numMAUsInCache;
    }

    public void setNumMAUsInCache(long value) {
        this.numMAUsInCache = value;
    }

    public MemoryTypeDescriptor getMemTypeObj() {
        return this.memTypeObj;
    }

    @Override
    public boolean isCacheDirtyBitAccessible() {
        return this.isCacheDirtyBitAccessible;
    }

    public void setIsCacheDirtyBitAccessible(boolean value) {
        this.isCacheDirtyBitAccessible = value;
    }

    @Override
    public int getNumWaysInCache() {
        return this.numWaysInCache;
    }

    public void setNumWaysInCache(int value) {
        this.numWaysInCache = value;
    }

    @Override
    public boolean isLruSupported() {
        return this.isLruSupported;
    }

    public void setIsLruSupported(boolean value) {
        this.isLruSupported = value;
    }

    public RegisterDecoder getLruBitToWayDecoder() {
        return this.lruBitToWayDecoder;
    }

    public int getMaxNumSetsInCache() {
        int result = 0;
        if (this.numWaysInCache != 0) {
            result = this.memTypeObj.getMaxNumCacheLines() / this.numWaysInCache;
        }
        return result;
    }

    protected ArrayList<ArrayList<CacheLineDescriptor>> getListOfSets() {
        return this.listOfSets;
    }

    public EnumCacheLevel getEnumCacheLevel() {
        return this.enumCacheLevel;
    }

    @Override
    public void getCacheTagInfo() {
        this.numMAUsInCache = this.memTypeObj.getCacheSizeInMAUs();
        int numLinesInCache = this.memTypeObj.getNumCacheLines();
        this.clearListOfSets();
        if (this.numMAUsInCache > 0L && this.cacheTagRamReader != null) {
            ICacheTagRamDatas ctrDatas;
            block9: {
                ctrDatas = null;
                try {
                    ctrDatas = this.cacheTagRamReader.read((long)this.enumCacheLevel.getInt(), (long)numLinesInCache);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block9;
                    MemoryServerTrace.logException("Exception calling cacheTagRamReader.read(" + this.enumCacheLevel.name() + "," + numLinesInCache + ") for " + this.memTypeObj.getName(), "CacheTagRamHandler.getCacheTagInfo", ex, this.target.getInfo());
                }
            }
            long ctrDatas_getCount = 0L;
            if (ctrDatas != null) {
                ctrDatas_getCount = ctrDatas.getCount();
                this.numCacheLinesRead = this.copyTagRamData(ctrDatas, this.listCacheLineDescriptors, numLinesInCache);
                if (this.memTypeObj.isVirtualWayConversionEnabled()) {
                    this.convertToVirtualWayNumbers(this.listCacheLineDescriptors, this.memTypeObj.getCacheTagRamHandler().getNumWaysInCache());
                }
                ((IDisposable)ctrDatas).dispose();
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                if ((long)numLinesInCache != this.numCacheLinesRead) {
                    MemoryServerTrace.logWarning("GetCacheTagInfo for " + this.memTypeObj.getName() + ": " + "NumCacheLinesRead = " + Long.toString(this.getNumCacheLinesRead()) + "[expected " + Integer.toString(numLinesInCache) + "][ctrDatas.getCount() = " + Long.toString(ctrDatas_getCount) + "]", "CacheTagRamHandler.getCacheTagInfo", this.target.getInfo());
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("getCacheTagInfo for " + this.memTypeObj.getName() + ": " + "NumCacheLinesRead = " + Long.toString(this.getNumCacheLinesRead()), "CacheTagRamHandler.getCacheTagInfo", this.target.getInfo());
                }
            }
        }
    }

    private int copyTagRamData(ICacheTagRamDatas ctrDatas, ArrayList<CacheLineDescriptor> dst, long numLines) {
        if (ctrDatas == null || dst == null) {
            throw new NullPointerException();
        }
        if (numLines <= 0L) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".copyTagRamData(... numLinex <= 0");
        }
        ArrayList<CacheLineDescriptor> wayList = null;
        short lruWayInLastSet = -1;
        CacheLineDescriptor line = null;
        CacheLineDescriptor lineInPrevSet = null;
        int result = 0;
        int lineNum = 0;
        boolean badSetId = false;
        int lastSetId = -1;
        boolean isLruUpdateEnabled = this.isLruSupported() && this.lruBitToWayDecoder != null;
        try {
            int i = 0;
            while ((long)i < numLines) {
                lineNum = i;
                line = dst.get(i);
                ICacheTagRamData cacheLineData = ctrDatas.item(i);
                int rawSetIdValue = (int)cacheLineData.getSetId();
                if (rawSetIdValue < 0 || rawSetIdValue > this.getMaxNumSetsInCache()) {
                    rawSetIdValue = this.getMaxNumSetsInCache();
                    badSetId = true;
                }
                line.setCacheSetId(rawSetIdValue);
                if (isLruUpdateEnabled && i >= this.getNumWaysInCache() && i % this.getNumWaysInCache() == 0) {
                    for (int index = i - this.getNumWaysInCache(); index < i; ++index) {
                        lineInPrevSet = dst.get(index);
                        lineInPrevSet.setLruWay(lruWayInLastSet);
                    }
                    lruWayInLastSet = -1;
                }
                lastSetId = (short)line.getCacheSetId();
                if (cacheLineData.getValidBit()) {
                    line.setValidBit((byte)1);
                    line.setLineAdrs(cacheLineData.getTagAddress());
                } else {
                    line.setValidBit((byte)0);
                }
                if (cacheLineData.getDirtyBit()) {
                    line.setDirtyBit((byte)1);
                } else {
                    line.setDirtyBit((byte)0);
                }
                if (cacheLineData.getLRU()) {
                    line.setLruValue((byte)1);
                } else {
                    line.setLruValue((byte)0);
                }
                line.setTagRamError((int)cacheLineData.getError());
                ++result;
                int cacheSetId = line.getCacheSetId();
                if (cacheSetId < this.listOfSets.size()) {
                    if (cacheSetId >= 0 && cacheSetId < this.listOfSets.size()) {
                        wayList = this.listOfSets.get(cacheSetId);
                        line.setWayNumber(wayList.size());
                        wayList.add(line);
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("Error copying tag RAM data into list of cache line descriptors: cacheSetId = 0x" + Integer.toHexString(cacheSetId) + ", listOfSets.size()=0x" + Integer.toHexString(this.listOfSets.size()), "CacheTagRamHandler.CopyTagRamData", null);
                    }
                }
                if (isLruUpdateEnabled && line.getValidBit() != 0 && line.getLruValue() != 0) {
                    lruWayInLastSet = (short)line.getWayNumber();
                }
                ((IDisposable)cacheLineData).dispose();
                ++i;
            }
            if (isLruUpdateEnabled) {
                for (int index = (int)numLines - this.getNumWaysInCache(); index < (int)numLines; ++index) {
                    lineInPrevSet = dst.get(index);
                    lineInPrevSet.setLruWay(lruWayInLastSet);
                }
            }
        }
        catch (Exception e) {
            String info = "[not available]";
            if (line != null) {
                try {
                    info = " cacheName=" + this.getMemTypeObj().getName();
                    info = info + ", cacheSize=0x" + Long.toHexString(this.getMemTypeObj().getCacheSizeInMAUs());
                    info = info + ", maxNumCacheLines=0x" + Long.toHexString(this.getMemTypeObj().getMaxNumCacheLines());
                    info = info + ", cacheLineSize=" + Long.toString(this.getMemTypeObj().getCacheLineSize());
                    info = info + ", last line read: " + line.toString();
                    info = info + "/nXML file = " + this.target.info.getXmlDeviceDescriptionFileName();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            MemoryServerTrace.log(false, EnumTraceLevel.ERRORS, false, "Exception copying tag RAM data into list of cache line descriptors. LineNum = " + Integer.toString(lineNum) + info, "CacheTagRamHandler.CopyTagRamData", e, this.target.getInfo().getStrTargetDescription());
        }
        return result;
    }

    private void initListOfSets() {
        ArrayList wayList = null;
        this.clearListOfSets();
        this.listOfSets.clear();
        for (int setNum = 0; setNum < this.getMaxNumSetsInCache(); ++setNum) {
            wayList = new ArrayList();
            this.listOfSets.add(wayList);
        }
    }

    private void clearListOfSets() {
        for (ArrayList<CacheLineDescriptor> wayList : this.listOfSets) {
            wayList.clear();
        }
    }

    protected void refreshListOfSets() {
        ArrayList<CacheLineDescriptor> wayList = null;
        this.initListOfSets();
        int lineCtr = 0;
        for (CacheLineDescriptor line : this.listCacheLineDescriptors) {
            int index = (int)this.getSetIdFromAdrs(line.getLineAdrs());
            wayList = this.listOfSets.get(index);
            line.setWayNumber(wayList.size());
            wayList.add(line);
            if (++lineCtr < this.memTypeObj.getNumCacheLines()) continue;
            break;
        }
    }

    @Override
    public boolean isCachedAdrsLeastRecentlyUsed(long adrs) {
        boolean result = false;
        CacheLineDescriptor line = this.getCacheLineContainingAdrs(adrs, false);
        if (line != null && this.isLruSupported() && line.getValidBit() != 0 && line.getLruWay() == (short)line.getWayNumber()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isAdrsInCache(long adrs) {
        boolean result = false;
        CacheLineDescriptor line = this.getCacheLineContainingAdrs(adrs, false);
        if (line != null && line.getValidBit() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isCacheLineDirty(long adrs) {
        boolean result = false;
        CacheLineDescriptor line = this.getCacheLineContainingAdrs(adrs, false);
        if (line != null && this.isCacheDirtyBitAccessible && line.getDirtyBit() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    public CacheLineDescriptor getCacheLineContainingAdrs(long adrs, boolean usePreviousLineAdrs) {
        CacheLineDescriptor result = null;
        boolean found = false;
        long setIdIndex = this.getSetIdFromAdrs(adrs);
        ArrayList<CacheLineDescriptor> setOfLines = this.listOfSets.get((int)setIdIndex);
        long lineAdrs = 0L;
        Iterator<CacheLineDescriptor> i$ = setOfLines.iterator();
        while (i$.hasNext()) {
            CacheLineDescriptor line;
            result = line = i$.next();
            lineAdrs = !usePreviousLineAdrs ? line.getLineAdrs() : line.getPreviousLineAdrs();
            if (lineAdrs > adrs || lineAdrs + (long)this.getMemTypeObj().getCacheLineSize() <= adrs) continue;
            found = true;
            break;
        }
        if (!found) {
            result = null;
            result = this.getCacheLineByBruteForceSearch(adrs, usePreviousLineAdrs);
            if (result != null) {
                found = true;
            }
        }
        return result;
    }

    public long getSetIdFromAdrs(long adrs) {
        long result = adrs >> this.getMemTypeObj().getNumBitsToRightShiftAdrsToGetSetId();
        return result &= (long)(this.listOfSets.size() - 1);
    }

    @Override
    public boolean convertToVirtualWayNumbers(ArrayList<CacheLineDescriptor> cacheLineList, int numWaysPerSet) {
        boolean result = false;
        if (numWaysPerSet == 2 && cacheLineList.size() >= 4) {
            result = true;
            Collections.sort(cacheLineList);
            long setXway0LineAdrs = 0L;
            long setXway1LineAdrs = 0L;
            long setYway0LineAdrs = 0L;
            long setYway1LineAdrs = 0L;
            long distanceX0Y0 = 0L;
            long distanceX0Y1 = 0L;
            long distanceX1Y0 = 0L;
            long distanceX1Y1 = 0L;
            CacheLineDescriptor cacheLineSetXway0 = cacheLineList.get(0);
            CacheLineDescriptor cacheLineSetXway1 = cacheLineList.get(1);
            CacheLineDescriptor cacheLineSetYway0 = null;
            CacheLineDescriptor cacheLineSetYway1 = null;
            boolean setXhasAtLeastOneValidWay = false;
            boolean setYhasAtLeastOneValidWay = false;
            for (int index = numWaysPerSet; index <= cacheLineList.size() - numWaysPerSet; index += numWaysPerSet) {
                cacheLineSetYway0 = cacheLineList.get(index);
                cacheLineSetYway1 = cacheLineList.get(index + 1);
                setXhasAtLeastOneValidWay = cacheLineSetXway0.getValidBit() > 0 || cacheLineSetXway1.getValidBit() > 0;
                setYhasAtLeastOneValidWay = cacheLineSetYway0.getValidBit() > 0 || cacheLineSetYway1.getValidBit() > 0;
                if (setXhasAtLeastOneValidWay && setYhasAtLeastOneValidWay) {
                    setXway0LineAdrs = cacheLineSetXway0.getValidBit() > 0 ? cacheLineSetXway0.getLineAdrs() : Long.MAX_VALUE;
                    setXway1LineAdrs = cacheLineSetXway1.getValidBit() > 0 ? cacheLineSetXway1.getLineAdrs() : Long.MAX_VALUE;
                    setYway0LineAdrs = cacheLineSetYway0.getValidBit() > 0 ? cacheLineSetYway0.getLineAdrs() : Long.MAX_VALUE;
                    setYway1LineAdrs = cacheLineSetYway1.getValidBit() > 0 ? cacheLineSetYway1.getLineAdrs() : Long.MAX_VALUE;
                    distanceX0Y0 = Math.abs(setYway0LineAdrs - setXway0LineAdrs);
                    distanceX0Y1 = Math.abs(setYway1LineAdrs - setXway0LineAdrs);
                    distanceX1Y0 = Math.abs(setYway0LineAdrs - setXway1LineAdrs);
                    distanceX1Y1 = Math.abs(setYway1LineAdrs - setXway1LineAdrs);
                    if (distanceX0Y1 < distanceX0Y0 && distanceX0Y1 < distanceX1Y1 || distanceX1Y0 < distanceX0Y0 && distanceX1Y0 < distanceX1Y1) {
                        this.swapWays(cacheLineSetYway0, cacheLineSetYway1);
                        cacheLineSetXway0 = cacheLineSetYway1;
                        cacheLineSetXway1 = cacheLineSetYway0;
                        continue;
                    }
                    cacheLineSetXway0 = cacheLineSetYway0;
                    cacheLineSetXway1 = cacheLineSetYway1;
                    continue;
                }
                cacheLineSetXway0 = cacheLineSetYway0;
                cacheLineSetXway1 = cacheLineSetYway1;
            }
            Collections.sort(cacheLineList);
        }
        return result;
    }

    public void swapWays(CacheLineDescriptor cacheLineA, CacheLineDescriptor cacheLineB) {
        long tempWayNum = cacheLineA.getWayNumber();
        if (cacheLineA.getLruWay() == (short)cacheLineA.getWayNumber()) {
            cacheLineA.setLruWay((short)cacheLineB.getWayNumber());
            cacheLineB.setLruWay((short)cacheLineB.getWayNumber());
        } else if (cacheLineA.getLruWay() == (short)cacheLineB.getWayNumber()) {
            cacheLineA.setLruWay((short)cacheLineA.getWayNumber());
            cacheLineB.setLruWay((short)cacheLineA.getWayNumber());
        }
        cacheLineA.setWayNumber(cacheLineB.getWayNumber());
        cacheLineB.setWayNumber(tempWayNum);
        cacheLineB.setLruWay(cacheLineA.getLruWay());
    }

    @Override
    public CacheLineDescriptor getCacheLineByBruteForceSearch(long adrs, boolean usePreviousLineAdrs) {
        CacheLineDescriptor result = null;
        boolean found = false;
        UInt63 lineAdrs = new UInt63(0);
        int index = 0;
        while ((long)index < this.numCacheLinesRead) {
            result = this.listCacheLineDescriptors.get(index);
            if (!usePreviousLineAdrs) {
                lineAdrs.setValue(result.getLineAdrs());
            } else {
                lineAdrs.setValue(result.getPreviousLineAdrs());
            }
            if (lineAdrs.getValue() <= adrs && lineAdrs.getValue() + (long)this.getMemTypeObj().getCacheLineSize() > adrs) {
                found = true;
                break;
            }
            ++index;
        }
        if (!found) {
            result = null;
        }
        return result;
    }

    @Override
    public int getNumValidCacheLines() {
        int result = 0;
        int lineCtr = 0;
        for (CacheLineDescriptor line : this.listCacheLineDescriptors) {
            if (line.getValidBit() != 0) {
                ++result;
            }
            if (++lineCtr < this.memTypeObj.getNumCacheLines()) continue;
            break;
        }
        return result;
    }

    public int getNumCacheLines() {
        return this.memTypeObj.getNumCacheLines();
    }

    public String toString() {
        String result = "";
        int i = 0;
        while ((long)i < this.getNumCacheLinesRead()) {
            result = result + this.listCacheLineDescriptors.get(i).toString() + "/n";
            ++i;
        }
        return result;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.cacheTagRamReader != null && this.cacheTagRamReader instanceof IDisposable) {
                    if (!((IDisposable)this.cacheTagRamReader).isDisposed()) {
                        // empty if block
                    }
                    ((IDisposable)this.cacheTagRamReader).dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
    }

    public void acquire() {
    }
}

