/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryServerEventHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import java.util.EventObject;

public class CoreNumberHdlr
implements IMemoryServerEventHandler {
    private RegisterHandler regHdlrCoreNumber = null;
    private RegisterDecoder regDecoderCoreNumber = null;
    private boolean isCoreNumberFromTaskNameAvailable = false;
    private int coreNumberFromTaskName = 0;
    private boolean initComplete = false;
    private TargetHandler target = null;

    public void initOld(TargetHandler target, RegisterList listOfRegHandlers) {
        block12: {
            try {
                this.target = target;
                String taskNameSuffix = "";
                String taskName = this.target.getDspTask().getName();
                int uscoreIndex = taskName.lastIndexOf("_");
                this.coreNumberFromTaskName = 0;
                if (uscoreIndex > 0) {
                    taskNameSuffix = taskName.substring(uscoreIndex + 1, taskName.length());
                    int suffixValue = 0;
                    try {
                        this.coreNumberFromTaskName = suffixValue = Integer.parseInt(taskNameSuffix);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.target.info.getXmlDeviceInfoHandler().getXpathNav() != null) {
                    XmlDeviceInfoHandler xmlHdlr = this.target.info.getXmlDeviceInfoHandler();
                    if (xmlHdlr.getPathToActiveDeviceCore().length() > 0) {
                        MyXPathNavigator xPathNav = xmlHdlr.getXpathNav();
                        XmlHelper xmlHelper = new XmlHelper();
                        MyXPathNodeIterator nodeIterator = xPathNav.select(xmlHdlr.getPathToActiveDeviceCore());
                        XmlElement coreNumberNode = nodeIterator.findFirstNodeWithName("CoreNumber", true, true);
                        String configRegName = "";
                        String decoderName = "";
                        if (coreNumberNode != null) {
                            configRegName = xmlHelper.getString(coreNumberNode, "ConfigReg", "", 0);
                            decoderName = xmlHelper.getString(coreNumberNode, "DecoderName", "", 0);
                        }
                        if (configRegName.length() > 0 && decoderName.length() > 0) {
                            this.regHdlrCoreNumber = listOfRegHandlers.getRegisterHandler(configRegName);
                            if (this.regHdlrCoreNumber != null) {
                                this.regDecoderCoreNumber = this.regHdlrCoreNumber.getDecoder(decoderName);
                            }
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("xmlHdlr.getPathToActiveDeviceCore() returns empty string for " + this.target.info.getXmlDeviceDescriptionFileName(), "CoreNumberHdlr xml constructor", target.info);
                    }
                }
                this.setInitComplete(true);
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block12;
                MemoryServerTrace.logException("Error attempting to read CoreNumber information from Memory Server XML file " + this.target.info.getXmlDeviceDescriptionFileName(), "CoreNumberHdlr xml constructor", ex, target.info);
            }
        }
    }

    public void init(TargetHandler target, RegisterList listOfRegHandlers) {
        block12: {
            try {
                this.target = target;
                String taskNameSuffix = "";
                String taskName = this.target.getDspTask().getName();
                int uscoreIndex = taskName.lastIndexOf("_");
                this.coreNumberFromTaskName = 0;
                if (uscoreIndex > 0) {
                    taskNameSuffix = taskName.substring(uscoreIndex + 1, taskName.length());
                    int suffixValue = 0;
                    try {
                        this.coreNumberFromTaskName = suffixValue = Integer.parseInt(taskNameSuffix);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.target.info.getXmlDeviceInfoHandler().getXpathNav() != null) {
                    XmlDeviceInfoHandler xmlHdlr = this.target.info.getXmlDeviceInfoHandler();
                    if (xmlHdlr.getPathToActiveDeviceCore().length() > 0) {
                        String configRegName = "";
                        String decoderName = "";
                        DeviceXMLReader.CoreInfoItem coreInfoItem = DeviceXMLReader.getInstance(target.getMemoryServerXmlPath()).getCoreInfoItem(xmlHdlr, xmlHdlr.getPathToActiveDeviceCore());
                        if (coreInfoItem != null) {
                            configRegName = coreInfoItem.configReg;
                            decoderName = coreInfoItem.decoderName;
                        }
                        if (configRegName.length() > 0 && decoderName.length() > 0) {
                            this.regHdlrCoreNumber = listOfRegHandlers.getRegisterHandler(configRegName);
                            if (this.regHdlrCoreNumber != null) {
                                this.regDecoderCoreNumber = this.regHdlrCoreNumber.getDecoder(decoderName);
                            }
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("xmlHdlr.getPathToActiveDeviceCore() returns empty string for " + this.target.info.getXmlDeviceDescriptionFileName(), "CoreNumberHdlr xml constructor", target.info);
                    }
                }
                this.setInitComplete(true);
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block12;
                MemoryServerTrace.logException("Error attempting to read CoreNumber information from Memory Server XML file " + this.target.info.getXmlDeviceDescriptionFileName(), "CoreNumberHdlr xml constructor", ex, target.info);
            }
        }
    }

    public RegisterHandler getRegHdlrCoreNumber() {
        return this.regHdlrCoreNumber;
    }

    public RegisterDecoder getRegDecoderCoreNumber() {
        return this.regDecoderCoreNumber;
    }

    public boolean isCoreNumberFromTargetAvailable() {
        boolean result = false;
        if (this.regHdlrCoreNumber != null && this.regDecoderCoreNumber != null) {
            result = true;
        }
        return result;
    }

    public int getCoreNumberForThisTarget() {
        int result = 0;
        result = this.regHdlrCoreNumber != null && this.regDecoderCoreNumber != null ? (int)this.regDecoderCoreNumber.decode() : this.coreNumberFromTaskName;
        return result;
    }

    public boolean isCoreNumberFromTaskNameAvailable() {
        return this.isCoreNumberFromTaskNameAvailable;
    }

    public int getCoreNumberFromTaskName() {
        return this.coreNumberFromTaskName;
    }

    public boolean getInitComplete() {
        return this.initComplete;
    }

    public void setInitComplete(boolean value) {
        this.initComplete = value;
        if (this.initComplete) {
            this.target.info.setCoreNumber(this.getCoreNumberForThisTarget());
        }
    }

    public TargetHandler getTarget() {
        return this.target;
    }

    @Override
    public void handleEvent(EventObject e, EventArgs args) {
    }
}

